/*
 * Decompiled with CFR 0.152.
 */
package charm.liveViz;

import charm.ccs.CcsProgress;
import charm.ccs.CcsThread;
import charm.liveViz.Config;
import charm.liveViz.Controller3d;
import charm.liveViz.MainPanel;
import charm.liveViz.MemImagePanel;
import charm.util.Toolbar;
import charm.util.Vector3d;
import java.awt.Graphics;
import java.awt.Label;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class CcsImagePanel
extends MemImagePanel {
    int redrawCount = 0;
    CcsThread ccs;
    Controller3d cntl = null;
    Toolbar tools;
    Config config = null;
    private boolean imageRequested = false;
    private volatile ByteImage curImg;
    int lastWid = 200;
    int lastHt = 150;

    public CcsImagePanel(MainPanel caller_, Label status_, Toolbar tools_, String server, int port, boolean isTimeoutSet, int timeoutPeriod) {
        this.tools = tools_;
        this.ccs = new CcsThread(new progressToLabel(status_), server, port, isTimeoutSet, timeoutPeriod);
        this.ccs.addRequest(new CcsConfigRequest(this, caller_));
    }

    public void stop() {
        this.ccs.finish();
    }

    private void debug(String state) {
    }

    public void gotConfig(Vector3d min, Vector3d max) {
        if (this.config.is3d) {
            System.out.println("Box size: " + min + " to " + max);
            this.cntl = new Controller3d(this, this.tools, min, max, this.lastWid, this.lastHt);
        }
        if (!this.imageRequested) {
            this.debug("Sending request from gotConfig");
            this.requestImage();
        }
    }

    public void requestImage() {
        this.imageRequested = true;
        Controller3d.ImageRequest3d r = null;
        if (this.cntl != null) {
            r = this.cntl.get3dRequest();
        }
        this.ccs.addRequest(new CcsImageRequest(this, r), true);
    }

    public void gotImage(ByteImage newImg) {
        this.curImg = newImg;
        this.debug("gotImage");
        this.imageRequested = false;
        this.repaint(1L);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.cntl != null) {
            this.cntl.paint(g, this.getSize());
        }
    }

    @Override
    public void fillBuffer(int[] dest, int dWid, int dHt) {
        ByteImage s;
        this.lastWid = dWid;
        this.lastHt = dHt;
        if (this.cntl != null) {
            this.cntl.updateSize(dWid, dHt);
        }
        if ((s = this.curImg) == null) {
            return;
        }
        byte[] src = s.data;
        int w = dWid;
        int h = dHt;
        if (w > s.wid) {
            w = s.wid;
        }
        if (h > s.ht) {
            h = s.ht;
        }
        this.debug("redraw");
        for (int y = 0; y < h; ++y) {
            int x;
            int destIdx;
            int srcIdx;
            if (s.isColor) {
                srcIdx = y * s.wid * 3;
                destIdx = y * dWid;
                for (x = 0; x < w; ++x) {
                    int alpha = 255;
                    int red = src[srcIdx + x * 3 + 0] & 0xFF;
                    int green = src[srcIdx + x * 3 + 1] & 0xFF;
                    int blue = src[srcIdx + x * 3 + 2] & 0xFF;
                    dest[destIdx + x] = (alpha << 24) + (red << 16) + (green << 8) + blue;
                }
                continue;
            }
            srcIdx = y * s.wid;
            destIdx = y * dWid;
            for (x = 0; x < w; ++x) {
                int val = src[srcIdx + x + 0] & 0xFF;
                int alpha = 255;
                int red = val;
                int green = val;
                int blue = val;
                dest[destIdx + x] = (alpha << 24) + (red << 16) + (green << 8) + blue;
            }
        }
        if (!this.imageRequested && (dWid != s.wid || dHt != s.ht || this.config.isPush)) {
            this.debug("Sending request from fillBuffer");
            this.requestImage();
        }
    }

    private class progressToLabel
    implements CcsProgress {
        private Label dest;

        public progressToLabel(Label dest_) {
            this.dest = dest_;
        }

        @Override
        public void setText(String s) {
            this.dest.setText(s);
        }
    }

    private class CcsConfigRequest
    extends CcsThread.request {
        CcsImagePanel dest;
        MainPanel caller;

        public CcsConfigRequest(CcsImagePanel dest_, MainPanel caller_) {
            super("lvConfig", 0);
            this.dest = dest_;
            this.caller = caller_;
        }

        @Override
        public void handleReply(byte[] configData) {
            try {
                DataInputStream is = new DataInputStream(new ByteArrayInputStream(configData));
                CcsImagePanel.this.config = new Config(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Config values: color=" + CcsImagePanel.this.config.isColor + " push=" + CcsImagePanel.this.config.isPush + " 3d=" + CcsImagePanel.this.config.is3d + "\n");
            CcsImagePanel.this.gotConfig(CcsImagePanel.this.config.min, CcsImagePanel.this.config.max);
            this.caller.createGrid();
        }
    }

    private class CcsImageRequest
    extends CcsThread.request {
        int wid;
        int ht;
        CcsImagePanel dest;

        public CcsImageRequest(CcsImagePanel dest_, Controller3d.ImageRequest3d r) {
            super("lvImage", null);
            this.dest = dest_;
            this.wid = CcsImagePanel.this.lastWid;
            this.ht = CcsImagePanel.this.lastHt;
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(bs);
            try {
                os.writeInt(1);
                os.writeInt(1);
                os.writeInt(this.wid);
                os.writeInt(this.ht);
                if (r != null) {
                    r.x.write(os);
                    r.y.write(os);
                    r.z.write(os);
                    r.o.write(os);
                    os.writeDouble(r.minZ);
                    os.writeDouble(r.maxZ);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setData(bs.toByteArray());
        }

        @Override
        public void handleReply(byte[] data) {
            this.dest.gotImage(new ByteImage(data, this.wid, this.ht, CcsImagePanel.this.config.isColor));
        }
    }

    private static class ByteImage {
        public int wid;
        public int ht;
        public byte[] data;
        public boolean isColor;

        public ByteImage(byte[] d, int w, int h, boolean c) {
            this.data = d;
            this.wid = w;
            this.ht = h;
            this.isColor = c;
        }
    }
}

