/*
 * Decompiled with CFR 0.152.
 */
package charm.liveViz;

import charm.liveViz.CcsImagePanel;
import charm.util.Toolbar;
import charm.util.Vector3d;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class Controller3d
implements MouseListener,
MouseMotionListener {
    CcsImagePanel master;
    Toolbar tools;
    int wid;
    int ht;
    double delZ;
    Vector3d o;
    Vector3d x;
    Vector3d y;
    Vector3d z;
    double u2pix;
    double pix2u;
    int rtsoX;
    int rtsoY;
    private static final int TOOL_SCROLL = 0;
    private static final int TOOL_ZOOM = 1;
    private static final int TOOL_ROTATE = 2;
    private static final int TOOL_SLICE = 3;
    private static final int TOOL_INFO = 4;
    private int lastX = -1;
    private int lastY = -1;
    private double starting_pix2u;
    private Vector3d starting_o;
    private boolean inDrag;

    public void updateSize(int wid_, int ht_) {
        this.rtsoX += (wid_ - this.wid) / 2;
        this.rtsoY += (ht_ - this.ht) / 2;
        this.wid = wid_;
        this.ht = ht_;
    }

    private void rebuildAxes() {
        this.x = this.x.normalize();
        this.z = this.x.cross(this.y).normalize();
        this.y = this.z.cross(this.x).normalize();
    }

    public Controller3d(CcsImagePanel master_, Toolbar tools_, Vector3d oMin, Vector3d oMax, int wid_, int ht_) {
        this.master = master_;
        this.master.addMouseListener(this);
        this.master.addMouseMotionListener(this);
        this.tools = tools_;
        if (wid_ <= 0) {
            wid_ = 200;
        }
        if (ht_ <= 0) {
            ht_ = 150;
        }
        this.wid = wid_;
        this.ht = ht_;
        this.o = oMin.plus(oMax).scaleBy(0.5);
        int minPix = this.wid;
        if (minPix > this.ht) {
            minPix = this.ht;
        }
        Vector3d del = oMax.minus(oMin);
        this.pix2u = del.x / (double)minPix;
        this.u2pix = 1.0 / this.pix2u;
        this.x = new Vector3d(1.0, 0.0, 0.0);
        this.y = new Vector3d(0.0, 1.0, 0.0);
        this.rebuildAxes();
        this.rtsoX = this.wid / 2;
        this.rtsoY = this.ht / 2;
        this.delZ = del.z;
    }

    private void update() {
        this.master.requestImage();
        this.master.repaint(200L);
    }

    private Vector3d universe(double sx, double sy) {
        return this.o.plus(this.x.scaleBy((sx - (double)this.rtsoX) * this.pix2u).plus(this.y.scaleBy(-(sy - (double)this.rtsoY) * this.pix2u)));
    }

    public ImageRequest3d get3dRequest() {
        ImageRequest3d ret = new ImageRequest3d();
        ret.wid = this.wid;
        ret.ht = this.ht;
        ret.x = this.x.scaleBy(this.u2pix);
        ret.y = this.y.scaleBy(-this.u2pix);
        ret.z = this.z;
        ret.o = this.universe(0.0, 0.0);
        ret.minZ = -this.delZ;
        ret.maxZ = this.delZ;
        return ret;
    }

    private void drawAxis(Graphics g, Dimension dim, Vector3d dir, String name) {
        double axisLen = 15.0;
        double fontShift = 7.0;
        Vector3d sDir = new Vector3d(dir.dot(this.x), -dir.dot(this.y), 0.0);
        Vector3d aDir = sDir.scaleBy(axisLen);
        Vector3d nDir = sDir.scaleBy(axisLen + fontShift);
        Font f = g.getFont();
        int cx = (int)(2.0 * axisLen);
        int cy = (int)((double)dim.height - 2.0 * axisLen);
        g.drawLine(cx, cy, (int)((double)cx + aDir.x), (int)((double)cy + aDir.y));
        g.drawString(name, (int)((double)cx + nDir.x), (int)((double)cy + nDir.y));
    }

    public void paint(Graphics g, Dimension dim) {
        g.setColor(Color.red);
        this.drawAxis(g, dim, new Vector3d(1.0, 0.0, 0.0), "X");
        g.setColor(Color.green);
        this.drawAxis(g, dim, new Vector3d(0.0, 1.0, 0.0), "Y");
        g.setColor(new Color(70, 70, 255));
        this.drawAxis(g, dim, new Vector3d(0.0, 0.0, 1.0), "Z");
    }

    private void pointInfo(int mx, int my) {
        Vector3d loc = this.universe(mx, my);
        System.out.println("Clicked at " + loc);
    }

    private void updatePoint(MouseEvent evt, boolean firstTime) {
        int mx = evt.getX();
        int my = evt.getY();
        if (firstTime) {
            this.o = this.universe(mx, my);
            this.rtsoX = mx;
            this.rtsoY = my;
            this.starting_o = this.o;
            this.starting_pix2u = this.pix2u;
            if (this.tools.getTool() == 4) {
                this.pointInfo(mx, my);
            }
        } else if (this.lastX != mx || this.lastY != my) {
            switch (this.tools.getTool()) {
                case 0: {
                    this.rtsoX = mx;
                    this.rtsoY = my;
                    this.update();
                    break;
                }
                case 1: {
                    double pix2zoom = 0.02;
                    int d = mx - this.rtsoX + (my - this.rtsoY);
                    this.pix2u = this.starting_pix2u / Math.pow(2.0, (double)d * pix2zoom);
                    this.u2pix = 1.0 / this.pix2u;
                    this.update();
                    break;
                }
                case 2: {
                    double pix2rad = 0.02;
                    double dx = mx - this.lastX;
                    double dy = -(my - this.lastY);
                    this.x = this.x.plus(this.z.scaleBy(-dx * pix2rad));
                    this.y = this.y.plus(this.z.scaleBy(-dy * pix2rad));
                    this.rebuildAxes();
                    this.update();
                    break;
                }
                case 3: {
                    int d = mx - this.rtsoX + (my - this.rtsoY);
                    this.o = this.starting_o.plus(this.z.scaleBy((double)d * this.pix2u));
                    this.update();
                    break;
                }
                case 4: {
                    this.pointInfo(mx, my);
                }
            }
        }
        this.lastX = mx;
        this.lastY = my;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.inDrag = true;
        this.updatePoint(evt, true);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.updatePoint(evt, false);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.updatePoint(evt, false);
        this.inDrag = false;
        this.lastX = -1;
        this.lastY = -1;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    public static class ImageRequest3d {
        public int wid;
        public int ht;
        public Vector3d x;
        public Vector3d y;
        public Vector3d z;
        public Vector3d o;
        public double minZ;
        public double maxZ;
    }
}

