/*
 * Decompiled with CFR 0.152.
 */
package charm.liveViz;

import charm.liveViz.MainPanel;
import java.applet.Applet;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MainApplet
extends Applet {
    private MainPanel panel;
    private Frame frame;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: demo <ccs server><ccs port>\nor:    demo <ccs server> <ccs port> -w <width> -h <height> -timeout <period>");
            System.exit(1);
        }
        int width = 300;
        int height = 200;
        boolean maximized = false;
        boolean wFlag = false;
        boolean hFlag = false;
        boolean tFlag = false;
        String isTimeoutSet = "false";
        String timeoutPeriod = "0";
        for (int i = 2; i < args.length; ++i) {
            if (args[i].equals("-w")) {
                wFlag = true;
                continue;
            }
            if (args[i].equals("-h")) {
                hFlag = true;
                continue;
            }
            if (args[i].equals("-timeout")) {
                tFlag = true;
                continue;
            }
            if (wFlag) {
                width = Integer.parseInt(args[i]);
                wFlag = false;
                continue;
            }
            if (hFlag) {
                height = Integer.parseInt(args[i]);
                hFlag = false;
                continue;
            }
            if (!tFlag) continue;
            isTimeoutSet = "true";
            timeoutPeriod = args[i];
            tFlag = false;
        }
        if (width < 0 || height < 0) {
            System.out.println("ERROR: Invalid width or height");
            System.exit(1);
        }
        MainApplet.createWindow(new MainPanel(args[0], args[1], isTimeoutSet, timeoutPeriod), true, width, height, maximized);
    }

    private static Frame createWindow(MainPanel p, boolean closeExit, int width, int height, boolean maximized) {
        Frame top = new Frame();
        if (maximized) {
            top.setExtendedState(6);
        }
        if (closeExit) {
            top.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        top.setTitle("Parallel Data Visualization");
        top.add(p);
        top.pack();
        top.setSize(width, height);
        top.setVisible(true);
        return top;
    }

    @Override
    public void start() {
        this.panel = new MainPanel(this.getParameter("ccs_server_name"), this.getParameter("ccs_server_port"), this.getParameter("ccs_timeoutset"), this.getParameter("ccs_timeoutperiod"));
        this.frame = MainApplet.createWindow(this.panel, false, 300, 200, false);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }
        });
    }

    @Override
    public void stop() {
        this.panel.stop();
        this.frame.dispose();
        this.panel = null;
        this.frame = null;
    }
}

