/*
 * Decompiled with CFR 0.152.
 */
package charm.liveViz;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.image.MemoryImageSource;

class MemImagePanel
extends Panel {
    int[] pix = null;
    int cached_w = -1;
    int cached_h = -1;

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 300);
    }

    public void fillBuffer(int[] pix, int w, int h) {
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int red = x & 0xFF;
                int green = y & 0xFF;
                int blue = red;
                pix[y * w + x] = -16777216 + (red << 16) + (green << 8) + blue;
            }
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.update_anim(g);
    }

    void init_anim(int w, int h) {
        this.cached_w = w;
        this.cached_h = h;
        this.pix = new int[w * h];
    }

    void update_anim(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.cached_w != w || this.cached_h != h) {
            this.init_anim(w, h);
        }
        this.cached_w = w;
        this.cached_h = h;
        this.fillBuffer(this.pix, w, h);
        Image img = this.createImage(new MemoryImageSource(w, h, this.pix, 0, w));
        g.drawImage(img, 0, 0, null);
    }
}

