/*
 * Decompiled with CFR 0.152.
 */
package charm.util;

import java.awt.event.TextEvent;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class JSelectField
extends JTextField {
    private String lastValue;
    private int lastCaretPosition;

    public JSelectField(String defval, int size) {
        super(defval, size);
        this.setInputVerifier(new RangeVerifier());
        this.lastValue = defval;
    }

    private void checkValue() {
        String tmp = this.getText();
        int l = tmp.length();
        if (l > 0) {
            char c = tmp.charAt(l - 1);
            if (l == 1) {
                if (c < '0' || c > '9') {
                    this.setText(this.lastValue);
                    this.setCaretPosition(this.lastCaretPosition);
                }
            } else {
                char d = tmp.charAt(l - 2);
                if (c == '-' || c == ',' || c == ':') {
                    if (d < '0' || d > '9') {
                        this.setText(this.lastValue);
                        this.setCaretPosition(this.lastCaretPosition);
                    } else if (c == '-' && tmp.substring(0, l - 1).lastIndexOf("-") > tmp.substring(0, l - 1).lastIndexOf(",")) {
                        this.setText(this.lastValue);
                        this.setCaretPosition(this.lastCaretPosition);
                    } else if (c == ':' && tmp.substring(0, l - 1).lastIndexOf("-") < tmp.substring(0, l - 1).lastIndexOf(",")) {
                        this.setText(this.lastValue);
                        this.setCaretPosition(this.lastCaretPosition);
                    }
                }
            }
        }
        this.lastValue = tmp;
    }

    private String cleanItUp(String old) {
        Object tmp = "";
        int len = old.length();
        for (int i = 0; i < len; ++i) {
            char c = old.charAt(i);
            if ((c < '0' || c > '9') && c != '-' && c != ',' && c != ':') continue;
            tmp = (String)tmp + new String("" + c);
        }
        return tmp;
    }

    public SortedSet getValue(int limit) {
        --limit;
        TreeSet<Integer> tmpList = new TreeSet<Integer>();
        String tmp = this.cleanItUp(this.getText());
        if (tmp.length() == 0) {
            tmp = "0";
        }
        try {
            char c = tmp.charAt(tmp.length() - 1);
            while (c < '0' || c > '9') {
                tmp = tmp.substring(0, tmp.length() - 1);
                c = tmp.charAt(tmp.length() - 1);
            }
            int i = 0;
            int low = 0;
            int high = 0;
            int min = 0;
            int max = 0;
            int interval = 1;
            boolean notDone = true;
            while (notDone) {
                while (i < tmp.length() && tmp.charAt(i) >= '0' && tmp.charAt(i) <= '9') {
                    ++i;
                }
                high = i;
                min = Integer.parseInt(tmp.substring(low, high));
                if (i == tmp.length()) {
                    interval = 1;
                    max = min;
                    notDone = false;
                } else if (tmp.charAt(i) == ',') {
                    interval = 1;
                    max = min;
                    low = ++i;
                } else if (tmp.charAt(i) == '-') {
                    low = ++i;
                    while (i < tmp.length() && tmp.charAt(i) >= '0' && tmp.charAt(i) <= '9') {
                        ++i;
                    }
                    high = i;
                    max = Integer.parseInt(tmp.substring(low, high));
                    interval = 1;
                    if (i < tmp.length() && tmp.charAt(i) == ':') {
                        low = ++i;
                        while (i < tmp.length() && tmp.charAt(i) >= '0' && tmp.charAt(i) <= '9') {
                            ++i;
                        }
                        high = i;
                        interval = Integer.parseInt(tmp.substring(low, high));
                    }
                    if (i == tmp.length()) {
                        notDone = false;
                    } else if (tmp.charAt(i) == ',') {
                        low = ++i;
                    } else {
                        System.err.println("Badly formed pelist - should not happen! Please contact Charm++ developers!");
                        System.exit(-1);
                    }
                }
                for (int j = min; j <= max; j += interval) {
                    if (j > limit) continue;
                    tmpList.add(new Integer(j));
                }
            }
        }
        catch (NumberFormatException e) {
            tmpList.clear();
        }
        catch (StringIndexOutOfBoundsException e) {
            tmpList.clear();
        }
        return tmpList;
    }

    public void textValueChanged(TextEvent evt) {
        this.checkValue();
    }

    class RangeVerifier
    extends InputVerifier {
        RangeVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            String procRange = tf.getText();
            for (int i = 0; i < procRange.length(); ++i) {
                char ch = procRange.charAt(i);
                if ('0' <= ch && ch <= '9' || ch == '-' || ch == ',' || ch == ':' || Character.isISOControl(ch)) continue;
                return false;
            }
            return true;
        }
    }
}

