/*
 * Decompiled with CFR 0.152.
 */
package charm.lvClient;

import charm.ccs.CcsLabel;
import charm.ccs.CcsServer;
import charm.ccs.CcsThread;
import charm.ccs.PythonExecute;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class CcsAcceptor {
    CcsThread ccsT;
    int outstandingRequests;

    public CcsAcceptor(String servername, String port) {
        this.ccsT = new CcsThread(new CcsLabel(), servername, Integer.parseInt(port), false, 0);
        this.outstandingRequests = 0;
    }

    public void readyLiveViz(int num) {
        for (int i = 0; i < num; ++i) {
            System.out.println("creating a liveViz request\n");
            CcsImageRequest r = new CcsImageRequest();
            this.ccsT.addRequest(r);
            ++this.outstandingRequests;
        }
    }

    public void DoPythonReq(String pycommand) {
        PythonExecute pe = new PythonExecute(pycommand, false, true, 0);
        this.ccsT.addRequest(new ExecutePythonCode(pe.pack()));
        ++this.outstandingRequests;
    }

    public void finish() {
    }

    private class CcsImageRequest
    extends CcsThread.request {
        int wid;
        int ht;

        public CcsImageRequest() {
            super("lvImage", null);
            this.wid = 400;
            this.ht = 400;
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(bs);
            try {
                os.writeInt(1);
                os.writeInt(1);
                os.writeInt(this.wid);
                os.writeInt(this.ht);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setData(bs.toByteArray());
        }

        @Override
        public void handleReply(byte[] data) {
            System.out.println("Received a LiveViz image\n");
            --CcsAcceptor.this.outstandingRequests;
        }
    }

    private class ExecutePythonCode
    extends CcsThread.request {
        public ExecutePythonCode(byte[] s) {
            super("pycode", s);
        }

        @Override
        public void handleReply(byte[] data) {
            int interpreterHandle = CcsServer.readInt(data, 0);
            System.out.println("Python request was processed\n");
            --CcsAcceptor.this.outstandingRequests;
        }
    }
}

