/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.AllocationGraphDialog;
import charm.debug.AllocationTreePanel;
import charm.debug.MemoryTrace;
import charm.debug.ScrollableAllocationGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;

public class AllocationGraphPanel
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
ItemListener {
    private JMenuBar menuBar;
    private JMenu menuAction;
    private JCheckBoxMenuItem menuAllocationTree;
    private JCheckBoxMenuItem menuAllocationTreeFromBeginning;
    private JScrollPane displayPane;
    private ScrollableAllocationGraph allocationData;
    private JFrame atFrame;
    private AllocationTreePanel at;
    private boolean traceWrite;

    AllocationGraphPanel() {
        this.setLayout(new BorderLayout());
        this.atFrame = null;
        this.menuBar = new JMenuBar();
        this.menuAction = new JMenu("Allocation Tree");
        this.menuBar.add(this.menuAction);
        this.menuAction.setMnemonic('A');
        this.menuAllocationTree = new JCheckBoxMenuItem("Show");
        this.menuAction.add(this.menuAllocationTree);
        this.menuAllocationTree.addItemListener(this);
        this.menuAllocationTreeFromBeginning = new JCheckBoxMenuItem("Start from beginning");
        this.menuAction.add(this.menuAllocationTreeFromBeginning);
        this.menuAllocationTreeFromBeginning.addItemListener(this);
        this.displayPane = new JScrollPane();
        this.add((Component)this.displayPane, "Center");
    }

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    public void load(JFrame frame, MemoryTrace log, AllocationGraphDialog input) {
        Vector logs;
        this.traceWrite = true;
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (AllocationGraphPanel.this.atFrame != null) {
                    AllocationGraphPanel.this.atFrame.dispose();
                }
            }
        });
        try {
            logs = log.readLogs(input.getPe(), input.getFirstEvent(), input.getLastEvent());
        }
        catch (IOException e) {
            System.out.println("An error occured while trying to load the memory logs");
            e.printStackTrace();
            return;
        }
        this.allocationData = new ScrollableAllocationGraph(logs, input.getEventsPerBar(), input.getBarWidth(), input.getHeight());
        this.allocationData.addMouseListener(this);
        this.allocationData.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.allocationData);
        this.displayPane.setViewportView(this.allocationData);
        this.displayPane.setRowHeaderView(this.allocationData.getRowHeader());
        this.displayPane.setCorner("LOWER_LEFT_CORNER", new Corner());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this.menuAllocationTree) {
            if (e.getStateChange() == 1) {
                if (this.atFrame == null) {
                    this.atFrame = new JFrame("Allocation Tree");
                    this.atFrame.setDefaultCloseOperation(1);
                    this.atFrame.addWindowListener(new AllocationTreeWindowClosed(this));
                    AllocationTreePanel newContentPane = this.at = new AllocationTreePanel();
                    newContentPane.setOpaque(true);
                    this.atFrame.setContentPane(newContentPane);
                    this.atFrame.setTitle("Allocation Tree");
                    List logs = this.menuAllocationTreeFromBeginning.isSelected() ? this.allocationData.getLogsFromBeginning() : this.allocationData.getSelectedLogs();
                    this.at.loadMemoryLogs(logs, this.menuAllocationTreeFromBeginning.isSelected());
                    this.atFrame.pack();
                }
                this.atFrame.setVisible(true);
                this.menuAllocationTree.setText("Hide");
            } else {
                this.atFrame.setVisible(false);
                this.menuAllocationTree.setText("Show");
            }
        } else if (e.getItemSelectable() == this.menuAllocationTreeFromBeginning) {
            this.updateAllocationTreeFrame();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.allocationData) {
            this.traceWrite = !this.traceWrite;
            this.updatePosition(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.deletePosition();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.allocationData) {
            this.allocationData.viewX = e.getX();
            this.allocationData.viewY = e.getY();
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.updatePosition(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this.allocationData) {
            JViewport jv = (JViewport)this.allocationData.getParent();
            Point p = jv.getViewPosition();
            int newX = p.x - (e.getX() - this.allocationData.viewX);
            int newY = p.y - (e.getY() - this.allocationData.viewY);
            int maxX = this.allocationData.getWidth() - jv.getWidth();
            int maxY = this.allocationData.getHeight() - jv.getHeight();
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            if (newX < 0) {
                newX = 0;
            }
            if (newY < 0) {
                newY = 0;
            }
            jv.setViewPosition(new Point(newX, newY));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updatePosition(e);
    }

    private void updatePosition(MouseEvent e) {
        if (this.traceWrite) {
            if (e.getSource() == this.allocationData) {
                this.allocationData.selectPosition(e);
            } else {
                this.allocationData.selectPosition(null);
            }
            this.updateAllocationTreeFrame();
        }
    }

    private void updateAllocationTreeFrame() {
        if (this.atFrame != null && this.atFrame.isVisible()) {
            List logs = this.menuAllocationTreeFromBeginning.isSelected() ? this.allocationData.getLogsFromBeginning() : this.allocationData.getSelectedLogs();
            this.at.loadMemoryLogs(logs, this.menuAllocationTreeFromBeginning.isSelected());
        }
    }

    private void deletePosition() {
        if (this.traceWrite) {
            this.allocationData.selectPosition(null);
        }
    }

    class Corner
    extends JComponent {
        Corner() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    class AllocationTreeWindowClosed
    extends WindowAdapter {
        AllocationGraphPanel parent;

        AllocationTreeWindowClosed(AllocationGraphPanel agp) {
            this.parent = agp;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.parent.menuAllocationTree.setSelected(false);
            this.parent.menuAllocationTree.setText("Show");
        }
    }
}

