/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.MemoryLog;
import charm.debug.Symbol;
import charm.debug.inspect.Inspector;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class AllocationPoint
implements TreeNode {
    Symbol location;
    int size;
    int count;
    boolean isLeak;
    Vector children;
    AllocationPoint parent;

    public AllocationPoint(AllocationPoint p) {
        this.parent = p;
        this.count = 0;
        this.size = 0;
        this.isLeak = false;
        this.location = null;
        this.children = null;
    }

    public void readPuppedBuffer(ByteBuffer buf) {
        long key = Inspector.is64bit() ? buf.getLong() : (long)buf.getInt();
        this.location = Symbol.get(key);
        this.size = buf.getInt();
        this.count = buf.getInt();
        this.isLeak = buf.get() > 0;
        int numChildren = buf.getInt();
        this.children = new Vector(numChildren);
        for (int i = 0; i < numChildren; ++i) {
            AllocationPoint child = new AllocationPoint(this);
            this.children.addElement(child);
            child.readPuppedBuffer(buf);
        }
    }

    public void addMemoryLog(MemoryLog log, int depth) {
        if (depth >= 0) {
            if (this.location == null) {
                this.location = Symbol.get(log.getStack(depth));
            }
            this.size += log.getSize();
            ++this.count;
        }
        if (log.getStack().length > depth + 1) {
            AllocationPoint child = this.getChildWithLocation(log.getStack(depth + 1));
            if (child == null) {
                child = new AllocationPoint(this);
                if (this.children == null) {
                    this.children = new Vector();
                }
                this.children.add(child);
            }
            child.addMemoryLog(log, depth + 1);
        }
    }

    public void removeMemoryLog(MemoryLog log, int depth) {
        AllocationPoint child;
        int sizePlus = log.getSize();
        if (sizePlus < 0) {
            sizePlus = -sizePlus;
        }
        if (depth >= 0) {
            if (this.location == null) {
                this.location = Symbol.get(log.getStack(depth));
            }
            this.size -= sizePlus;
            --this.count;
        }
        if (log.getStack().length > depth + 1 && (child = this.getChildWithLocation(log.getStack(depth + 1))) != null) {
            child.removeMemoryLog(log, depth + 1);
            if (child.size == 0) {
                this.children.remove(child);
            }
        }
    }

    AllocationPoint getChildWithLocation(long loc) {
        if (this.children == null) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            AllocationPoint child = (AllocationPoint)this.children.elementAt(i);
            if (!child.location.equals(loc)) continue;
            return child;
        }
        return null;
    }

    public String toString() {
        return (this.isLeak ? "* " : "") + this.location + ": size=" + this.size + ", count=" + this.count;
    }

    public Enumeration children() {
        if (this.children == null) {
            return null;
        }
        return this.children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (AllocationPoint)this.children.elementAt(childIndex);
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        if (this.children == null) {
            return -1;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.elementAt(i) != node) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.children == null || this.children.size() == 0;
    }
}

