/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.MemoryLog;
import charm.debug.MemoryPeak;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class MemoryTrace {
    private String filePrefix;
    private int numProcs;
    private int[] numEvents;
    public static final int BEGIN_TRACE = 11;
    public static final int MALLOC = 24;
    public static final int FREE = 25;

    public MemoryTrace(String prefix, int procs) {
        this.filePrefix = prefix;
        this.numProcs = procs;
        this.numEvents = new int[procs];
    }

    private String getFilename(int i) {
        return this.filePrefix + i;
    }

    public int findPeaks(int procNum, int howMany, Vector result) throws IOException {
        String line;
        String file = this.getFilename(procNum);
        BufferedReader fd = new BufferedReader(new FileReader(file));
        boolean peakValid = true;
        int totalsize = 0;
        int counter = 0;
        while ((line = fd.readLine()) != null) {
            int size;
            ++counter;
            String[] tokens = line.split("\\s");
            int type = Integer.parseInt(tokens[0]);
            if (type == 11) {
                size = Integer.parseInt(tokens[1]);
                if (size > totalsize) {
                    type = 24;
                    size -= totalsize;
                } else {
                    type = 25;
                    size = totalsize - size;
                }
            } else {
                size = Integer.parseInt(tokens[2]);
            }
            if (type == 24) {
                peakValid = true;
                totalsize += size;
                continue;
            }
            if (type == 25) {
                int j;
                totalsize -= size;
                if (!peakValid) continue;
                peakValid = false;
                for (j = result.size(); j > 0 && totalsize > ((MemoryPeak)result.elementAt((int)(j - 1))).size; --j) {
                }
                if (j >= howMany) continue;
                if (result.size() == howMany) {
                    result.remove(howMany - 1);
                }
                result.insertElementAt(new MemoryPeak(counter, totalsize, procNum), j);
                continue;
            }
            throw new IOException("Unrecognized Memory Log format");
        }
        return counter;
    }

    public Vector findAllPeaks(int howMany) throws IOException {
        Vector result = new Vector(howMany);
        for (int i = 0; i < this.numProcs; ++i) {
            this.numEvents[i] = this.findPeaks(i, howMany, result);
        }
        return result;
    }

    public Vector readLogs(int proc, int from, int to) throws IOException {
        Vector<MemoryLog> results = new Vector<MemoryLog>(to - from + 2);
        BufferedReader file = new BufferedReader(new FileReader(this.getFilename(proc)));
        int totalsize = 0;
        for (int i = 0; i < from; ++i) {
            totalsize += this.getNext(file, totalsize, false).getSize();
        }
        long[] stack = new long[]{0L};
        results.add(new MemoryLog(0L, totalsize, 0, stack));
        for (int i = from; i <= to; ++i) {
            MemoryLog log = this.getNext(file, totalsize, true);
            results.add(log);
            totalsize += log.getSize();
        }
        return results;
    }

    private MemoryLog getNext(BufferedReader file, int totalsize, boolean getStack) throws IOException {
        int size;
        long location;
        String line = file.readLine();
        if (line == null) {
            return null;
        }
        String[] tokens = line.split("\\s");
        int type = Integer.parseInt(tokens[0]);
        int recordedStack = 0;
        long[] stack = null;
        if (type == 11) {
            location = 0L;
            size = Integer.parseInt(tokens[1]);
            if (size > totalsize) {
                size -= totalsize;
                stack = new long[]{0L};
            } else {
                size = totalsize - size;
            }
        } else {
            block13: {
                try {
                    location = Long.decode(tokens[1]);
                }
                catch (NumberFormatException ne) {
                    location = 0L;
                    if (tokens[1].equals("(nil)")) break block13;
                    throw ne;
                }
            }
            if (type == 24) {
                size = Integer.parseInt(tokens[2]);
                recordedStack = Integer.parseInt(tokens[3]);
                int stackSize = recordedStack;
                if (stackSize == 0) {
                    stackSize = 1;
                }
                stack = new long[stackSize];
                stack[0] = 0L;
                for (int i = 0; i < recordedStack; ++i) {
                    stack[i] = Long.decode(tokens[i + 4]);
                }
            } else if (type == 25) {
                size = -Integer.parseInt(tokens[2]);
                stack = new long[]{0L};
            } else {
                throw new IOException("Unrecognized Memory Log format");
            }
        }
        return new MemoryLog(location, size, totalsize, stack);
    }

    public static void main(String[] argv) throws IOException {
        Vector peaks;
        for (int i = 0; i < argv.length; ++i) {
            System.out.println("argv " + i + ": " + argv[i]);
        }
        if (argv.length < 1) {
            return;
        }
        String fileName = argv[0];
        int quantity = 10;
        int numProcs = 0;
        if (argv.length > 1) {
            quantity = Integer.parseInt(argv[1]);
        }
        if (argv.length <= 2) {
            log = new MemoryTrace(fileName, numProcs);
            peaks = new Vector(quantity);
            log.findPeaks(0, quantity, peaks);
        } else {
            numProcs = Integer.parseInt(argv[2]);
            log = new MemoryTrace(fileName, numProcs);
            peaks = log.findAllPeaks(quantity);
        }
        for (int i = 0; i < peaks.size(); ++i) {
            System.out.println("Peak #" + (i + 1) + ": " + (MemoryPeak)peaks.elementAt(i));
        }
    }
}

