/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.ccs.PythonExecute;
import charm.ccs.PythonFinished;
import charm.ccs.PythonPrint;
import charm.debug.AllocationGraphDialog;
import charm.debug.AllocationGraphPanel;
import charm.debug.AllocationTreePanel;
import charm.debug.Commands;
import charm.debug.CpdUtil;
import charm.debug.EpCheckBox;
import charm.debug.EpTreeCheckBox;
import charm.debug.EpTreeListener;
import charm.debug.EpTreeRenderer;
import charm.debug.GdbProcess;
import charm.debug.MemoryDialog;
import charm.debug.MemoryPanel;
import charm.debug.MemoryTrace;
import charm.debug.PListOutputArea;
import charm.debug.ParamsDialog;
import charm.debug.PeSet;
import charm.debug.PeSetDialog;
import charm.debug.Processor;
import charm.debug.PythonDialog;
import charm.debug.PythonInstalledCode;
import charm.debug.PythonIteratorGroup;
import charm.debug.PythonIteratorPersistent;
import charm.debug.PythonScript;
import charm.debug.ServThread;
import charm.debug.Symbol;
import charm.debug.event.NotifyEvent;
import charm.debug.event.NotifyListener;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PConsumer;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.inspect.InspectPanel;
import charm.debug.inspect.Inspector;
import charm.debug.pdata.CharePList;
import charm.debug.pdata.ChareTypePList;
import charm.debug.pdata.EpInfo;
import charm.debug.pdata.EpPList;
import charm.debug.pdata.GenericInfo;
import charm.debug.pdata.GenericPList;
import charm.debug.pdata.MemStat;
import charm.debug.pdata.MsgPList;
import charm.debug.pdata.MsgStackPList;
import charm.debug.pdata.MsgTypePList;
import charm.debug.pdata.ReadonlyPList;
import charm.debug.preference.CpdFilter;
import charm.debug.preference.Execution;
import charm.debug.preference.Preference;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xml.sax.SAXException;

public class ParDebug
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final int MAJOR = 10;
    public static final int MINOR = 11;
    private Preference preferences;
    private Execution exec;
    private String portnumber;
    private static String hostnumber;
    private static String envDisplay;
    private static Process sshTunnel;
    public static byte[] globals;
    public static int dataPos;
    static ServThread servthread;
    private static GdbProcess gdb;
    public CpdUtil server;
    private DefaultListModel listModel;
    private PList listItems = null;
    private boolean isRunning = false;
    public static int currentListedPE;
    public int currentPopulatedList;
    private Processor[] pes = null;
    private CharePList groupItems;
    private MsgPList messageQueue;
    private EpPList epItems;
    private MsgTypePList msgItems;
    private ChareTypePList chareItems;
    private int interpreterHandle;
    private PythonInstalledCode installedPythonScripts;
    private Vector notificationListeners;
    private CpdListInfo[] cpdLists;
    private static JFrame appFrame;
    private static boolean noWindow;
    private JButton startButton;
    private JButton continueButton;
    private JButton stepButton;
    private JButton quitButton;
    private JButton freezeButton;
    private JButton startGdbButton;
    private JButton flushButton;
    private DefaultListModel peListModel;
    private JList peList;
    private JTextArea programOutputArea;
    private JScrollPane outputAreaScrollPane;
    private InspectPanel outputPanel;
    private PListOutputArea outputArea;
    private JTextArea newOutputArea;
    private JSplitPane bottomSplitPane;
    private JTextField statusArea;
    private JComboBox listsbox;
    private JComboBox pesbox;
    private JList listItemNames;
    private JScrollPane entryScrollPane;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuAction;
    private JMenuItem menuFileOpen;
    private JMenuItem menuFileEdit;
    private JMenuItem menuFileSave;
    private JMenu menuRecent;
    private JMenuItem menuWindowSettings;
    private JMenuItem menuActionStart;
    private JMenuItem menuActionAttach;
    private JMenuItem menuActionContinue;
    private JMenuItem menuActionQuit;
    private JMenuItem menuActionDisconnect;
    private JMenuItem menuActionFreeze;
    private JMenuItem menuActionPython;
    private JMenuItem menuActionPythonInstalled;
    private JMenu menuMemory;
    private JMenuItem menuMemoryView;
    private JMenuItem menuMemoryAllocationTree;
    private JMenuItem menuMemoryAllocationGraph;
    private JMenuItem menuMemoryLeak;
    private JMenuItem menuMemoryQuickLeak;
    private JMenuItem menuMemoryMark;
    private JMenuItem menuMemoryUnmark;
    private JMenuItem menuMemoryStatistics;
    public static ParDebug debugger;

    public static String infoCommand(String s) {
        return gdb.infoCommand(s);
    }

    private void abort(String problem) {
        System.out.println(problem);
        System.exit(1);
    }

    private String getEnvDisplay() {
        String displayEnv = null;
        String localip = null;
        try {
            localip = InetAddress.getLocalHost().getHostAddress();
            displayEnv = localip + ":0.0";
            System.out.println("DISPLAY variable = " + displayEnv);
        }
        catch (Exception exc) {
            this.abort("Error retrieving IP address for DISPLAY variable: " + exc.getMessage());
        }
        return displayEnv;
    }

    public void displayProgramOutput(String line) {
        this.programOutputArea.append(line);
        this.programOutputArea.scrollRectToVisible(new Rectangle(0, this.programOutputArea.getHeight() - 2, 1, 1));
    }

    public int getNumPes() {
        return this.exec.virtualDebug ? this.exec.virtualNpes : this.exec.npes;
    }

    public GdbProcess getGdb() {
        return gdb;
    }

    public int getSelectedPe() {
        return Integer.parseInt((String)this.pesbox.getSelectedItem());
    }

    public PeSet getSelectedPeSet() {
        return (PeSet)this.peList.getSelectedValue();
    }

    public Processor getSelectedProcessor() {
        return this.pes[this.getSelectedPe()];
    }

    private void addedRunParameter() {
        this.setStatusMessage("Executable: " + this.exec.executable + "        number of pes: " + this.exec.npes);
    }

    private void loadedRunParameter() {
        this.setStatusMessage("Loaded configuration => Executable: " + this.exec.executable + "     number of pes: " + this.exec.npes);
    }

    private void savedRunParameter(String file) {
        this.setStatusMessage("Saved current configuration to file  " + file);
    }

    public void setStatusMessage(String txt) {
        this.statusArea.setText(txt);
    }

    public void addNotifyListener(NotifyListener l) {
        this.notificationListeners.add(l);
    }

    public void removeNotifyListener(NotifyListener l) {
        this.notificationListeners.remove(l);
    }

    public void notify(NotifyEvent e) {
        for (int i = 0; i < this.notificationListeners.size(); ++i) {
            ((NotifyListener)this.notificationListeners.get(i)).receiveNotification(e);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferences.size != null) {
            return this.preferences.size;
        }
        return super.getPreferredSize();
    }

    public Point getPreferredLocation() {
        return this.preferences.location;
    }

    public Preference getPreferences() {
        return this.preferences;
    }

    public MsgPList getMessageList() {
        return new MsgPList(this.messageQueue);
    }

    public void deliverMessage(int index, String command) {
        this.messageQueue.deliverActionPerformed(index, command);
    }

    private void populateNewList(int cpdListIndex, int forPE, DefaultListModel dest) {
        dest.removeAllElements();
        this.outputArea.setList(null);
        this.newOutputArea.setText("");
        this.listItems = null;
        String lName = this.cpdLists[cpdListIndex].name;
        if (lName == null) {
            return;
        }
        GenericPList list = this.cpdLists[cpdListIndex].list;
        if (this.currentPopulatedList != -1 && cpdListIndex != this.currentPopulatedList && this.cpdLists[this.currentPopulatedList].list != null) {
            this.cpdLists[this.currentPopulatedList].list.removePopupMenu(this.listItemNames);
        }
        if (list == null || list.needRefresh()) {
            int nItems = this.server.getListLength(lName, forPE);
            this.listItems = this.server.getPList(lName, forPE, 0, nItems);
        }
        if (list != null) {
            if (list.needRefresh()) {
                list.load(this.listItems);
            }
            list.populate(dest, this.listItemNames);
        } else {
            for (PAbstract cur = this.listItems.elementAt(0); cur != null; cur = cur.getNext()) {
                dest.addElement(cur.getDeepName());
            }
        }
        this.currentPopulatedList = cpdListIndex;
    }

    private void expandListElement(int cpdListIndex, int forPE, int listItem) {
        currentListedPE = forPE;
        String detailedName = this.cpdLists[cpdListIndex].detailedName;
        int position = this.bottomSplitPane.getDividerLocation();
        if (detailedName == null) {
            if (this.cpdLists[cpdListIndex].list != null) {
                this.bottomSplitPane.setRightComponent(this.outputPanel);
                this.bottomSplitPane.setDividerLocation(position);
                Object selected = this.listItemNames.getSelectedValue();
                if (selected instanceof GenericInfo) {
                    ((GenericInfo)selected).getDetails(this.outputPanel);
                } else {
                    System.out.println("Error: element not of type GenericInfo");
                }
            } else {
                this.bottomSplitPane.setRightComponent(this.outputAreaScrollPane);
                this.bottomSplitPane.setDividerLocation(position);
                this.outputArea.setList((PList)this.listItems.elementAt(listItem));
            }
        } else {
            this.bottomSplitPane.setRightComponent(this.outputAreaScrollPane);
            this.bottomSplitPane.setDividerLocation(position);
            PList detailList = this.server.getPList(detailedName, forPE, listItem, listItem + 1);
            this.outputArea.setList(detailList);
        }
    }

    private void listenTo(JMenuItem m, String command, String toolTip) {
        if (toolTip != null) {
            m.setToolTipText(toolTip);
        }
        m.setActionCommand(command);
        m.addActionListener(this);
    }

    public ParDebug(Execution e) {
        CpdListInfo[] cpdListInfoArray = new CpdListInfo[12];
        cpdListInfoArray[0] = new CpdListInfo("-- Display --", null, null, null);
        this.groupItems = new CharePList();
        cpdListInfoArray[1] = new CpdListInfo("Charm Objects", "charm/objectNames", null, this.groupItems);
        cpdListInfoArray[2] = new CpdListInfo("Array Elements", "charm/arrayElements", null, new CharePList());
        this.messageQueue = new MsgPList();
        cpdListInfoArray[3] = new CpdListInfo("Messages in Queue", "converse/localqueue", null, this.messageQueue);
        cpdListInfoArray[4] = new CpdListInfo("Readonly Variables", "charm/readonly", null, new ReadonlyPList());
        cpdListInfoArray[5] = new CpdListInfo("Readonly Messages", "charm/readonlyMsg", null, null);
        cpdListInfoArray[6] = new CpdListInfo("Messages delivered stack", "charm/messageStack", null, new MsgStackPList());
        this.epItems = new EpPList();
        cpdListInfoArray[7] = new CpdListInfo("Entry Points", "charm/entries", null, this.epItems);
        this.chareItems = new ChareTypePList();
        cpdListInfoArray[8] = new CpdListInfo("Chare Types", "charm/chares", null, this.chareItems);
        this.msgItems = new MsgTypePList();
        cpdListInfoArray[9] = new CpdListInfo("Message Types", "charm/messages", null, this.msgItems);
        cpdListInfoArray[10] = new CpdListInfo("Mainchares", "charm/mains", null, null);
        cpdListInfoArray[11] = new CpdListInfo("Viewable Lists", "converse/lists", null, null);
        this.cpdLists = cpdListInfoArray;
        this.isRunning = false;
        this.installedPythonScripts = null;
        this.currentPopulatedList = -1;
        this.preferences = Preference.load();
        if (this.preferences == null) {
            this.preferences = new Preference();
        }
        this.exec = e;
        this.setLayout(new BoxLayout(this, 1));
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuBar.add(this.menuFile);
        this.menuFile.setMnemonic('F');
        this.menuFileOpen = new JMenuItem("Open Configuration", 79);
        this.menuFile.add(this.menuFileOpen);
        this.listenTo(this.menuFileOpen, "openConf", "Open the configuration of a parallel program to debug");
        this.menuFileEdit = new JMenuItem("Edit Configuration", 69);
        this.menuFile.add(this.menuFileEdit);
        this.listenTo(this.menuFileEdit, "editConf", "Edit the parameters for the current configuration");
        this.menuFileSave = new JMenuItem("Save Configuration", 83);
        this.menuFile.add(this.menuFileSave);
        this.listenTo(this.menuFileSave, "saveConf", "Save the current configuration");
        this.menuRecent = new JMenu("Recent Configurations");
        this.menuFile.add(this.menuRecent);
        this.updateRecentConfig();
        this.menuFile.addSeparator();
        this.menuWindowSettings = new JMenuItem("Save Window Settings", 87);
        this.menuFile.add(this.menuWindowSettings);
        this.listenTo(this.menuWindowSettings, "saveWindowSet", "Save the current window settings");
        JMenuItem menuFileExit = new JMenuItem("Exit Debugger", 88);
        this.menuFile.add(menuFileExit);
        this.listenTo(menuFileExit, "exitDebugger", null);
        this.menuAction = new JMenu("Action");
        this.menuBar.add(this.menuAction);
        this.menuAction.setMnemonic('A');
        this.menuActionStart = new JMenuItem("Start", 83);
        this.menuAction.add(this.menuActionStart);
        this.listenTo(this.menuActionStart, "begin", "Start the parallel program");
        this.menuActionAttach = new JMenuItem("Attach", 65);
        this.menuAction.add(this.menuActionAttach);
        this.listenTo(this.menuActionAttach, "attach", "Attach to a running parallel program");
        this.menuActionContinue = new JMenuItem("Continue", 67);
        this.menuAction.add(this.menuActionContinue);
        this.listenTo(this.menuActionContinue, "unfreeze", "Continue to run the parallel program");
        this.menuActionFreeze = new JMenuItem("Freeze", 70);
        this.menuAction.add(this.menuActionFreeze);
        this.listenTo(this.menuActionFreeze, "freeze", "Freeze the parallel program");
        this.menuActionDisconnect = new JMenuItem("Disconnect", 68);
        this.menuAction.add(this.menuActionDisconnect);
        this.listenTo(this.menuActionDisconnect, "disconnect", "Disconnect from the parallel program");
        this.menuActionQuit = new JMenuItem("Quit", 81);
        this.menuAction.add(this.menuActionQuit);
        this.listenTo(this.menuActionQuit, "quit", "Quit the parallel program");
        this.menuAction.addSeparator();
        this.menuActionPython = new JMenuItem("Python script", 80);
        this.menuAction.add(this.menuActionPython);
        this.listenTo(this.menuActionPython, "python", "Run python script on application");
        this.menuActionPython.setEnabled(false);
        this.menuActionPythonInstalled = new JMenuItem("View python scripts", 83);
        this.menuAction.add(this.menuActionPythonInstalled);
        this.listenTo(this.menuActionPythonInstalled, "pythoninstalled", "View python scripts installed");
        this.menuActionPythonInstalled.setEnabled(false);
        this.menuMemory = new JMenu("Memory");
        this.menuBar.add(this.menuMemory);
        this.menuMemory.setMnemonic('M');
        this.menuMemoryView = new JMenuItem("Memory View", 77);
        this.menuMemory.add(this.menuMemoryView);
        this.listenTo(this.menuMemoryView, "memory", "Inspect the application memory");
        this.menuMemoryView.setEnabled(false);
        this.menuMemoryAllocationTree = new JMenuItem("Memory Allocation Tree", 84);
        this.menuMemory.add(this.menuMemoryAllocationTree);
        this.listenTo(this.menuMemoryAllocationTree, "allocationTree", "Print the memory allocation tree");
        this.menuMemoryAllocationTree.setEnabled(false);
        this.menuMemoryAllocationGraph = new JMenuItem("Memory Allocation Graph", 71);
        this.menuMemory.add(this.menuMemoryAllocationGraph);
        this.listenTo(this.menuMemoryAllocationGraph, "allocationGraph", "Print the memory allocation graph");
        this.menuMemory.addSeparator();
        this.menuMemoryQuickLeak = new JMenuItem("Quick Leak Search", 81);
        this.menuMemory.add(this.menuMemoryQuickLeak);
        this.listenTo(this.menuMemoryQuickLeak, "leakquick", "Quick search for memory leacks");
        this.menuMemoryQuickLeak.setEnabled(false);
        this.menuMemoryLeak = new JMenuItem("Leak Search", 76);
        this.menuMemory.add(this.menuMemoryLeak);
        this.listenTo(this.menuMemoryLeak, "leaksearch", "Search for memory leacks");
        this.menuMemoryLeak.setEnabled(false);
        this.menuMemoryMark = new JMenuItem("Mark Memory Clean", 77);
        this.menuMemory.add(this.menuMemoryMark);
        this.listenTo(this.menuMemoryMark, "memorymark", "Mark all existing memory as not leaking");
        this.menuMemoryMark.setEnabled(false);
        this.menuMemoryUnmark = new JMenuItem("Unmark memory Clean", 85);
        this.menuMemory.add(this.menuMemoryUnmark);
        this.listenTo(this.menuMemoryUnmark, "memoryunmark", "Removing not-leak mark on all existing memory");
        this.menuMemoryUnmark.setEnabled(false);
        this.menuMemoryStatistics = new JMenuItem("Statistics", 83);
        this.menuMemory.add(this.menuMemoryStatistics);
        this.listenTo(this.menuMemoryStatistics, "memstat", "Display memory statistics");
        this.menuMemoryStatistics.setEnabled(false);
        this.statusArea = new JTextField(60);
        this.statusArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.statusArea.setMaximumSize(new Dimension(1000000, 40));
        this.statusArea.setEditable(false);
        this.statusArea.setBackground(Color.lightGray);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new BoxLayout(middlePanel, 0));
        this.entryScrollPane = new JScrollPane();
        this.entryScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Set Break Points"), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.entryScrollPane.setPreferredSize(new Dimension(200, 380));
        JPanel secondPanelWithOutput = new JPanel();
        secondPanelWithOutput.setLayout(new BoxLayout(secondPanelWithOutput, 1));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Control Buttons"), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        buttonPanel.setPreferredSize(new Dimension(500, 80));
        this.startButton = new JButton("Start");
        this.startButton.setVerticalTextPosition(0);
        this.startButton.setHorizontalTextPosition(2);
        this.startButton.setMnemonic(83);
        this.startButton.setActionCommand("begin");
        this.startButton.setEnabled(true);
        this.startButton.setToolTipText("Run the parallel program from scratch.");
        this.startButton.addActionListener(this);
        this.startButton.setPreferredSize(new Dimension(100, 80));
        this.stepButton = new JButton("Step");
        this.stepButton.setVerticalTextPosition(3);
        this.stepButton.setHorizontalTextPosition(0);
        this.stepButton.setMnemonic(80);
        this.stepButton.setActionCommand("step");
        this.stepButton.setEnabled(false);
        this.stepButton.setToolTipText("Deliver a single message.");
        this.stepButton.addActionListener(this);
        this.stepButton.setPreferredSize(new Dimension(100, 80));
        this.flushButton = new JButton("Flush");
        this.flushButton.setVerticalTextPosition(3);
        this.flushButton.setHorizontalTextPosition(0);
        this.flushButton.setActionCommand("deliverall");
        this.flushButton.setEnabled(false);
        this.flushButton.setToolTipText("Deliver all pending messages.");
        this.flushButton.addActionListener(this);
        this.flushButton.setPreferredSize(new Dimension(100, 80));
        this.continueButton = new JButton("Continue");
        this.continueButton.setVerticalTextPosition(3);
        this.continueButton.setHorizontalTextPosition(0);
        this.continueButton.setMnemonic(85);
        this.continueButton.setActionCommand("unfreeze");
        this.continueButton.setEnabled(false);
        this.continueButton.setToolTipText("Resume execution.");
        this.continueButton.addActionListener(this);
        this.continueButton.setPreferredSize(new Dimension(100, 80));
        this.freezeButton = new JButton("Freeze");
        this.freezeButton.setVerticalTextPosition(3);
        this.freezeButton.setHorizontalTextPosition(0);
        this.freezeButton.setActionCommand("freeze");
        this.freezeButton.setEnabled(false);
        this.freezeButton.setToolTipText("Stop execution.");
        this.freezeButton.addActionListener(this);
        this.freezeButton.setPreferredSize(new Dimension(100, 80));
        this.quitButton = new JButton("Quit");
        this.quitButton.setVerticalTextPosition(3);
        this.quitButton.setHorizontalTextPosition(0);
        this.quitButton.setMnemonic(81);
        this.quitButton.setActionCommand("quit");
        this.quitButton.setEnabled(false);
        this.quitButton.setToolTipText("End the program.");
        this.quitButton.addActionListener(this);
        this.quitButton.setPreferredSize(new Dimension(100, 80));
        this.startGdbButton = new JButton("GDB");
        this.startGdbButton.setVerticalTextPosition(3);
        this.startGdbButton.setHorizontalTextPosition(0);
        this.startGdbButton.setActionCommand("startgdb");
        this.startGdbButton.setEnabled(false);
        this.startGdbButton.setToolTipText("Start gdb on selected processors.");
        this.startGdbButton.addActionListener(this);
        this.startGdbButton.setPreferredSize(new Dimension(100, 80));
        buttonPanel.add(this.startButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.stepButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.flushButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.continueButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.freezeButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.quitButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.startGdbButton);
        JPanel outputAndPePanel = new JPanel();
        outputAndPePanel.setLayout(new BoxLayout(outputAndPePanel, 0));
        this.programOutputArea = new JTextArea();
        this.programOutputArea.setColumns(100);
        this.programOutputArea.setLineWrap(true);
        JScrollPane programOutputScrollPane = new JScrollPane(this.programOutputArea);
        programOutputScrollPane.setBorder(BorderFactory.createTitledBorder("Program Output"));
        programOutputScrollPane.setPreferredSize(new Dimension(350, 300));
        JPanel pePanel = new JPanel();
        pePanel.setLayout(new BoxLayout(pePanel, 1));
        pePanel.setPreferredSize(new Dimension(50, 380));
        this.peListModel = new DefaultListModel();
        this.peList = new JList(this.peListModel);
        this.peList.setCellRenderer(new PeSet.CellRenderer());
        this.peList.setSelectionMode(0);
        this.peList.getSelectionModel().addListSelectionListener(new PeSetListener());
        PeSet.PopupListener popupListener = new PeSet.PopupListener(this, this.peList);
        this.peList.addMouseListener(popupListener);
        JScrollPane pesScrollPane = new JScrollPane(this.peList);
        pesScrollPane.setBorder(BorderFactory.createTitledBorder("PEs"));
        pePanel.add(pesScrollPane);
        outputAndPePanel.add(programOutputScrollPane);
        outputAndPePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        outputAndPePanel.add(pePanel);
        outputAndPePanel.setPreferredSize(new Dimension(500, 300));
        secondPanelWithOutput.add(buttonPanel);
        secondPanelWithOutput.add(Box.createRigidArea(new Dimension(0, 5)));
        secondPanelWithOutput.add(outputAndPePanel);
        secondPanelWithOutput.setPreferredSize(new Dimension(500, 380));
        JSplitPane middleSplitPane = new JSplitPane(1, this.entryScrollPane, secondPanelWithOutput);
        middleSplitPane.setResizeWeight(0.5);
        middlePanel.add(middleSplitPane);
        middlePanel.setPreferredSize(new Dimension(600, 380));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        JPanel panelForComboBoxes = new JPanel();
        panelForComboBoxes.setLayout(new BoxLayout(panelForComboBoxes, 0));
        panelForComboBoxes.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("View Entities on PE"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        String[] displayStrings = new String[this.cpdLists.length];
        for (int i = 0; i < this.cpdLists.length; ++i) {
            displayStrings[i] = this.cpdLists[i].display;
        }
        this.listsbox = new JComboBox<String>(displayStrings);
        this.listsbox.setActionCommand("lists");
        this.listsbox.addActionListener(this);
        this.listsbox.setEnabled(false);
        this.listsbox.setPreferredSize(new Dimension(450, 70));
        this.pesbox = new JComboBox();
        this.pesbox.setActionCommand("changepe");
        this.pesbox.addActionListener(this);
        this.pesbox.setEnabled(false);
        this.pesbox.setPreferredSize(new Dimension(100, 70));
        panelForComboBoxes.add(this.listsbox);
        panelForComboBoxes.add(Box.createRigidArea(new Dimension(50, 70)));
        panelForComboBoxes.add(this.pesbox);
        panelForComboBoxes.setPreferredSize(new Dimension(600, 70));
        bottomPanel.add(panelForComboBoxes);
        JPanel panelForEntities = new JPanel();
        panelForEntities.setLayout(new BoxLayout(panelForEntities, 0));
        panelForEntities.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        panelForEntities.setPreferredSize(new Dimension(600, 230));
        this.listModel = new DefaultListModel();
        this.listItemNames = new JList(this.listModel);
        this.listItemNames.setSelectionMode(0);
        this.listItemNames.addListSelectionListener(this);
        JScrollPane listScrollPane = new JScrollPane(this.listItemNames);
        listScrollPane.setBorder(BorderFactory.createTitledBorder("Entities"));
        this.outputArea = new PListOutputArea();
        this.newOutputArea = new JTextArea();
        this.newOutputArea.setEditable(false);
        this.newOutputArea.setBackground(this.outputArea.getBackground());
        this.newOutputArea.setLineWrap(true);
        this.newOutputArea.setWrapStyleWord(true);
        this.outputAreaScrollPane = new JScrollPane(this.outputArea);
        this.outputAreaScrollPane.setHorizontalScrollBarPolicy(31);
        this.outputAreaScrollPane.setBorder(BorderFactory.createTitledBorder("Details"));
        this.outputPanel = new InspectPanel();
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Details"));
        this.bottomSplitPane = new JSplitPane(1, listScrollPane, this.outputPanel);
        this.bottomSplitPane.setOneTouchExpandable(true);
        panelForEntities.add(this.bottomSplitPane);
        bottomPanel.add(panelForEntities);
        JSplitPane verticalSplitPane = new JSplitPane(0, middlePanel, bottomPanel);
        verticalSplitPane.setResizeWeight(0.5);
        this.add(verticalSplitPane);
        this.add(this.statusArea);
        gdb = new GdbProcess(this);
        this.addedRunParameter();
        this.notificationListeners = new Vector();
        this.addNotifyListener(new NotifyGUI());
    }

    public void refreshMessageQueue() {
        CpdListInfo list = this.cpdLists[this.listsbox.getSelectedIndex()];
        if (list.list == this.messageQueue) {
            int forPE = Integer.parseInt((String)this.pesbox.getSelectedItem());
            this.populateNewList(this.listsbox.getSelectedIndex(), forPE, this.listModel);
        }
    }

    public void messageDelivered() {
        this.refreshMessageQueue();
        this.setStatusMessage("Single message delivered");
    }

    public void deliverSingle() {
        this.server.bcastCcsRequest("debug/charm/next", "", ((PeSet)this.peList.getSelectedValue()).toIDsArray());
        this.messageDelivered();
    }

    public void deliverAll() {
        this.server.bcastCcsRequest("debug/charm/deliverall", "", ((PeSet)this.peList.getSelectedValue()).toIDsArray());
        this.refreshMessageQueue();
        this.setStatusMessage("All messages delivered");
    }

    public void deliverConditional(int idx) {
        int pe = Integer.parseInt((String)this.pesbox.getSelectedItem());
        this.server.sendCcsRequest("debug/provisional/deliver", "" + idx, pe);
        this.pes[pe].setConditional();
        this.messageDelivered();
    }

    public void endConditional(int idx) {
        int pe = Integer.parseInt((String)this.pesbox.getSelectedItem());
        this.server.sendCcsRequest("debug/provisional/end", "" + idx, pe);
        if (idx == 0) {
            this.pes[pe].setFrozen();
        }
        this.messageDelivered();
    }

    public void commitConditional(int idx, int numConditional) {
        int pe = Integer.parseInt((String)this.pesbox.getSelectedItem());
        this.server.sendCcsRequest("debug/provisional/commit", "" + (idx + 1), pe);
        if (idx == numConditional - 1) {
            this.pes[pe].setFrozen();
        }
        this.messageDelivered();
    }

    public void updateRecentConfig() {
        Object[] files = this.preferences.getRecent();
        this.menuRecent.removeAll();
        if (files.length > 0) {
            this.menuRecent.setEnabled(true);
            for (int i = 0; i < files.length; ++i) {
                JMenuItem item = new JMenuItem((String)files[i]);
                this.listenTo(item, "openRecent", null);
                this.menuRecent.add(item);
            }
        } else {
            this.menuRecent.setEnabled(false);
        }
    }

    public void loadConfigFile(File filename) {
        try {
            this.exec = Execution.load(filename);
        }
        catch (IOException ioe) {
            this.setStatusMessage("Failed to load configuration file");
            return;
        }
        catch (ClassNotFoundException cnfe) {
            this.setStatusMessage("Configuration file corrupted");
            return;
        }
        catch (SAXException se) {
            this.setStatusMessage("Configuration file corrupted");
            return;
        }
        this.loadedRunParameter();
        this.preferences.addRecent(this.exec.locationOnDisk);
        this.updateRecentConfig();
    }

    public void executePython(PythonScript inputPython) {
        int i;
        Vector[] eps = inputPython.getSelectedEPs();
        for (i = 0; i < eps[0].size(); ++i) {
            System.out.println("Python EP before: " + eps[0].elementAt(i));
        }
        for (i = 0; i < eps[1].size(); ++i) {
            System.out.println("Python EP after: " + eps[1].elementAt(i));
        }
        if (eps[0].size() == 0 && eps[1].size() == 0) {
            PythonExecute code = new PythonExecute(inputPython.getText(), inputPython.getMethod(), new PythonIteratorGroup(inputPython.getChareGroup()), false, true, 0);
            code.setKeepPrint(true);
            code.setWait(true);
            code.setPersistent(true);
            if (this.interpreterHandle > 0) {
                code.setInterpreter(this.interpreterHandle);
            }
            System.out.println("Sending python request " + (code.isHighLevel() ? " highlevel" : "") + (code.isKeepPrint() ? " keepPrint" : "") + (code.isKeepWait() ? " keepWait" : "") + (code.isPersistent() ? " persistent" : "") + (code.isIterate() ? " iterative" : ""));
            byte[] reply = this.server.sendCcsRequestBytes("CpdPythonGroup", code.pack(), 0, true);
            if (reply.length == 0) {
                System.out.println("The python module was not linked in the application");
                return;
            }
            this.interpreterHandle = CcsServer.readInt(reply, 0);
            System.out.println("Python interpreter: " + this.interpreterHandle);
            PythonFinished finished = new PythonFinished(this.interpreterHandle, true);
            byte[] finishReply = this.server.sendCcsRequestBytes("CpdPythonGroup", finished.pack(), 0, true);
            PythonPrint print = new PythonPrint(this.interpreterHandle, false);
            byte[] output = this.server.sendCcsRequestBytes("CpdPythonGroup", print.pack(), 0, true);
            System.out.println("Python printed: " + new String(output));
        } else {
            int i2;
            int[] epIdx = new int[eps[0].size() + eps[1].size()];
            int count = 0;
            for (i2 = 0; i2 < eps[0].size(); ++i2) {
                epIdx[count++] = -((EpInfo)eps[0].elementAt(i2)).getEpIndex();
            }
            for (i2 = 0; i2 < eps[1].size(); ++i2) {
                epIdx[count++] = ((EpInfo)eps[1].elementAt(i2)).getEpIndex();
            }
            PythonExecute code = new PythonExecute(inputPython.getText(), inputPython.getMethod(), new PythonIteratorPersistent(inputPython.getChareGroup(), eps[0].size() + eps[1].size(), epIdx), true, true, 0);
            code.setKeepPrint(false);
            code.setWait(false);
            byte[] reply = this.server.sendCcsRequestBytes("CpdPythonPersistent", code.pack(), 0, true);
            if (reply.length == 0) {
                System.out.println("The python module was not linked in the application");
                return;
            }
            this.installedPythonScripts.add(inputPython.getOriginalCode(), eps, inputPython.getChare());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("openConf")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.addChoosableFileFilter(new CpdFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.loadConfigFile(chooser.getSelectedFile());
            }
        } else if (e.getActionCommand().equals("editConf")) {
            ParamsDialog dialogbox = new ParamsDialog((Frame)appFrame, true, this.exec);
            dialogbox.setLocationRelativeTo(appFrame);
            dialogbox.pack();
            dialogbox.setVisible(true);
        } else if (e.getActionCommand().equals("saveConf")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.addChoosableFileFilter(new CpdFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                int response;
                File filename = chooser.getSelectedFile();
                if (!filename.getName().endsWith(".cpd")) {
                    filename = new File(filename.getAbsolutePath() + ".cpd");
                }
                if (filename.exists() && (response = JOptionPane.showConfirmDialog(this, "Do you want to overwrite the file?", "File overwrite", 0)) != 0) {
                    this.setStatusMessage("Save aborted");
                    return;
                }
                try {
                    this.exec.save(filename);
                }
                catch (IOException ioe) {
                    this.setStatusMessage("Failed to save configuration file");
                    return;
                }
                this.savedRunParameter(filename.getAbsolutePath());
                this.exec.locationOnDisk = filename.getAbsolutePath();
                this.preferences.addRecent(this.exec.locationOnDisk);
                this.updateRecentConfig();
            }
        } else if (e.getActionCommand().equals("openRecent")) {
            JMenuItem item = (JMenuItem)e.getSource();
            String filename = item.getText();
            System.out.println("Loading configuration file: " + filename);
            this.loadConfigFile(new File(filename));
        } else if (e.getActionCommand().equals("saveWindowSet")) {
            this.preferences.location = this.getParent().getLocationOnScreen();
            this.preferences.size = this.getParent().getSize();
        } else if (e.getActionCommand().equals("begin")) {
            this.startProgram(false);
        } else if (e.getActionCommand().equals("attach")) {
            this.startProgram(true);
        } else if (e.getActionCommand().equals("freeze")) {
            this.server.bcastCcsRequest("debug/converse/freeze", "", ((PeSet)this.peList.getSelectedValue()).toIDsArray());
            Iterator iter = ((PeSet)this.peList.getSelectedValue()).iterator();
            while (iter.hasNext()) {
                ((Processor)iter.next()).setFreezing();
            }
            this.enableButtons();
            this.setStatusMessage("Program is frozen on selected pes");
            this.peList.repaint();
        } else if (e.getActionCommand().equals("unfreeze")) {
            this.command_continue();
            this.peList.repaint();
        } else if (e.getActionCommand().equals("step")) {
            this.deliverSingle();
        } else if (e.getActionCommand().equals("deliverall")) {
            this.deliverAll();
            this.peList.repaint();
        } else if (e.getActionCommand().equals("disconnect")) {
            servthread.terminate();
            servthread.interrupt();
        } else if (e.getActionCommand().equals("quit")) {
            this.server.bcastCcsRequest("debug/converse/quit", "");
            servthread.terminate();
        } else if (e.getActionCommand().equals("startgdb")) {
            SortedSet set = ((PeSet)this.peList.getSelectedValue()).getList();
            for (int i = 0; i < this.getNumPes(); ++i) {
                if (!set.contains(this.pes[i])) continue;
                PList pl = this.server.getPList("hostinfo", i);
                PList cur = (PList)pl.elementAt(0);
                byte[] addr = ((PString)cur.elementNamed("address")).getBytes();
                int[] address = new int[4];
                for (int j = 0; j < 4; ++j) {
                    address[j] = addr[j];
                    if (address[j] >= 0) continue;
                    int n = j;
                    address[n] = address[n] + 256;
                }
                int pid = ((PNative)cur.elementNamed("pid")).getIntValue(0);
                Object sshCommand = null;
                String[] str = null;
                String ipAddress = address[0] + "." + address[1] + "." + address[2] + "." + address[3];
                String script = "ssh " + (String)(this.exec.sshport > 0 ? "-p " + this.exec.sshport : "") + ipAddress + " \"cat > /tmp/start_gdb." + pid + " << END_OF_SCRIPT\nshell /bin/rm -f /tmp/start_gdb." + pid + "\nhandle SIGWINCH nostop noprint\nhandle SIGWAITING nostop noprint\nattach " + pid + "\nEND_OF_SCRIPT\ngdb " + new File(this.getFilename()).getAbsolutePath() + " -x /tmp/start_gdb." + pid + "\"";
                if (!this.exec.hostname.equals("localhost") && this.exec.sshTunnel) {
                    sshCommand = "ssh -T " + this.exec.hostname + " ssh -T";
                    str = new String[9];
                    str[5] = this.exec.hostname;
                    str[6] = "ssh";
                    str[7] = ipAddress;
                    str[8] = script;
                } else {
                    sshCommand = "ssh -T";
                    str = new String[7];
                    str[6] = script;
                }
                str[0] = "xterm";
                str[1] = "-title";
                str[2] = "Node " + i;
                str[3] = "-e";
                str[4] = "/bin/bash";
                str[5] = "-c";
                for (int k = 0; k < str.length; ++k) {
                    System.out.print(str[k] + " ");
                }
                System.out.println();
                try {
                    Runtime.getRuntime().exec(str);
                    continue;
                }
                catch (Exception e1) {
                    System.err.println(e);
                }
            }
            this.setStatusMessage("Gdb started on selected pes");
        } else if (e.getActionCommand().equals("breakpoints")) {
            EpCheckBox chkbox = (EpCheckBox)e.getSource();
            this.command_breakpoint(chkbox);
        } else if (e.getActionCommand().equals("memory")) {
            MemoryDialog input = new MemoryDialog((Frame)appFrame, true, this.getNumPes());
            if (input.confirmed()) {
                MemoryPanel memory;
                JFrame frame = new JFrame("Memory visualization");
                frame.setDefaultCloseOperation(2);
                MemoryPanel newContentPane = memory = new MemoryPanel();
                newContentPane.setOpaque(true);
                frame.setContentPane(newContentPane);
                memory.loadData(input);
                frame.setTitle("Memory Processor " + input.getPe());
                frame.setJMenuBar(memory.getMenu());
                frame.pack();
                frame.setVisible(true);
            }
        } else if (e.getActionCommand().equals("allocationTree")) {
            AllocationTreePanel at;
            JFrame frame = new JFrame("Allocation Tree");
            frame.setDefaultCloseOperation(2);
            AllocationTreePanel newContentPane = at = new AllocationTreePanel();
            newContentPane.setOpaque(true);
            frame.setContentPane(newContentPane);
            frame.setTitle("Allocation Tree");
            at.loadTree(frame);
            frame.pack();
            frame.setVisible(true);
        } else if (e.getActionCommand().equals("allocationGraph")) {
            AllocationGraphDialog input = new AllocationGraphDialog((Frame)appFrame, true, this.getNumPes());
            if (input.confirmed()) {
                AllocationGraphPanel at;
                JFrame frame = new JFrame("Allocation Graph");
                frame.setDefaultCloseOperation(2);
                AllocationGraphPanel newContentPane = at = new AllocationGraphPanel();
                newContentPane.setOpaque(true);
                frame.setContentPane(newContentPane);
                frame.setTitle("Allocation Graph");
                String executable = new File(this.getFilename()).getAbsolutePath();
                Object logFile = new File(executable).getParent();
                if (logFile == null) {
                    logFile = ".";
                }
                logFile = (String)logFile + "/memoryLog_";
                at.load(frame, new MemoryTrace((String)logFile, this.getNumPes()), input);
                frame.setJMenuBar(at.getMenu());
                frame.pack();
                frame.setVisible(true);
            }
        } else if (e.getActionCommand().equals("leaksearch") || e.getActionCommand().equals("leakquick")) {
            int inputValue;
            String input = JOptionPane.showInputDialog("Processor to scan (-1 for all)");
            try {
                inputValue = Integer.parseInt(input);
            }
            catch (NumberFormatException ex) {
                return;
            }
            int pe = inputValue;
            if (pe >= this.getNumPes()) {
                JOptionPane.showMessageDialog(this, "There are only " + this.getNumPes() + " processors.", "Error", 0);
                return;
            }
            if (inputValue == -1) {
                pe = 0;
            }
            CcsServer.writeInt(globals, globals.length - 8, e.getActionCommand().equals("leakquick") ? 1 : 0);
            CcsServer.writeInt(globals, globals.length - 4, inputValue);
            ParDebug.debugger.server.sendCcsRequestBytes("debug/memory/leak", globals, pe, true);
        } else if (e.getActionCommand().equals("memorymark") || e.getActionCommand().equals("memoryunmark")) {
            int pe;
            String input = JOptionPane.showInputDialog("Processor to mark (-1 for all)");
            try {
                pe = Integer.parseInt(input);
            }
            catch (NumberFormatException ex) {
                return;
            }
            if (pe >= this.getNumPes()) {
                JOptionPane.showMessageDialog(this, "There are only " + this.getNumPes() + " processors.", "Error", 0);
                return;
            }
            if (pe == -1) {
                pe = 0;
            }
            byte[] data = new byte[]{e.getActionCommand().equals("memorymark") ? (byte)1 : 0};
            ParDebug.debugger.server.sendCcsRequestBytes("debug/memory/mark", data, pe, false);
        } else if (e.getActionCommand().equals("memstat")) {
            int pe;
            String input = JOptionPane.showInputDialog("Processor to load (-1 for all)");
            try {
                pe = Integer.parseInt(input);
            }
            catch (NumberFormatException ex) {
                return;
            }
            if (pe >= this.getNumPes()) {
                JOptionPane.showMessageDialog(this, "There are only " + this.getNumPes() + " processors.", "Error", 0);
                return;
            }
            if (pe == -1) {
                pe = 0;
            }
            byte[] buf = ParDebug.debugger.server.sendCcsRequestBytes("debug/memory/stat", input, pe);
            PConsumer cons = new PConsumer();
            cons.decode(buf);
            PList stat = cons.getList();
            System.out.println(stat);
            MemStat m = new MemStat();
            m.load(stat);
            System.out.println(m.toString());
            JOptionPane.showMessageDialog(this, m.display(), "Memory Statistics", 1);
        } else if (e.getActionCommand().equals("python")) {
            new PythonDialog(this, false, this.groupItems, this.chareItems, gdb, this.server);
        } else if (e.getActionCommand().equals("pythoninstalled")) {
            this.installedPythonScripts.setVisible(true);
        } else if (e.getActionCommand().equals("newPeSet")) {
            Iterator iter;
            PeSetDialog input = new PeSetDialog((Frame)appFrame, true, this.getNumPes());
            if (input.confirmed() && (iter = input.getPes().iterator()).hasNext()) {
                TreeSet<Processor> set = new TreeSet<Processor>();
                while (iter.hasNext()) {
                    set.add(this.pes[(Integer)iter.next()]);
                }
                PeSet newset = new PeSet(input.getName(), set);
                this.peListModel.addElement(newset);
                this.peList.setSelectedValue(newset, true);
            }
        } else if (e.getActionCommand().equals("deletePeSet")) {
            int idx = this.peList.getSelectedIndex();
            if (idx > 0) {
                this.peListModel.remove(idx);
            }
        } else if (e.getActionCommand().equals("peSetDetails")) {
            PeSet pes = (PeSet)this.peList.getSelectedValue();
            String bufTitle = new String("Details for set \"" + pes.getName() + "\"");
            String buf = pes.getDetail();
            System.out.println(bufTitle + ": {" + buf + " }");
            JOptionPane.showMessageDialog(this, buf, bufTitle, 1);
        } else if (e.getActionCommand().equals("lists") || e.getActionCommand().equals("changepe")) {
            System.out.println("Starting generation new list " + new Date().getTime());
            if (this.pesbox.getSelectedItem() != null) {
                int forPE = Integer.parseInt((String)this.pesbox.getSelectedItem());
                this.populateNewList(this.listsbox.getSelectedIndex(), forPE, this.listModel);
            }
            System.out.println("Ended generation new list " + new Date().getTime());
        } else if (e.getActionCommand().equals("exitDebugger")) {
            if (this.isRunning) {
                this.server.bcastCcsRequest("debug/converse/quit", "");
                this.quitProgram();
            }
            this.preferences.save();
            System.exit(0);
        }
    }

    public void command_continue() {
        this.server.bcastCcsRequest("debug/charm/continue", "", ((PeSet)this.peList.getSelectedValue()).toIDsArray());
        Iterator iter = ((PeSet)this.peList.getSelectedValue()).iterator();
        while (iter.hasNext()) {
            ((Processor)iter.next()).setRunning();
        }
        this.enableButtons();
        this.setStatusMessage("Program is running on selected pes");
    }

    public void command_breakpoint(int epIdx) {
        EpCheckBox chkbox = this.epItems.getEntryFor(epIdx).getCheckBox();
        chkbox.doClick();
    }

    public void command_breakpoint(EpCheckBox chkbox) {
        int breakpointIndex = chkbox.ep.getEpIndex();
        String entryPointName = "" + breakpointIndex;
        if (((PeSet)this.peList.getSelectedValue()).isSomeConditional()) {
            chkbox.setSelected(!chkbox.isSelected());
            JOptionPane.showMessageDialog(this, "Cannot set breakpoints while in conditional mode!", "Error", 0);
            return;
        }
        if (chkbox.isSelected()) {
            chkbox.ep.addBP(((PeSet)this.peList.getSelectedValue()).getList());
            reply = this.server.bcastCcsRequest("debug/charm/bp/set", entryPointName, ((PeSet)this.peList.getSelectedValue()).toIDsArray());
            if (reply[0] != 0) {
                this.setStatusMessage("Break Point set at entry point " + entryPointName);
            } else {
                JOptionPane.showMessageDialog(this, "Could not set breakpoint!", "Error", 0);
            }
        } else {
            chkbox.ep.removeBP(((PeSet)this.peList.getSelectedValue()).getList());
            reply = this.server.bcastCcsRequest("debug/charm/bp/remove", entryPointName, ((PeSet)this.peList.getSelectedValue()).toIDsArray());
            if (reply[0] != 0) {
                this.setStatusMessage("Break Point removed at entry point " + entryPointName + " on selected Pes");
            } else {
                JOptionPane.showMessageDialog(this, "Could not remove breakpoint!", "Error", 0);
            }
        }
        PeSet set = (PeSet)this.peList.getSelectedValue();
        if (set != null) {
            chkbox.setCoverageColor(set.getList());
        }
        CpdListInfo list = this.cpdLists[this.listsbox.getSelectedIndex()];
        if (list.list == this.messageQueue) {
            int forPE = Integer.parseInt((String)this.pesbox.getSelectedItem());
            this.populateNewList(this.listsbox.getSelectedIndex(), forPE, this.listModel);
        }
        System.out.println("breakpoint triggered");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        System.out.println("Starting generation new detailed information " + new Date().getTime());
        JList theList = (JList)e.getSource();
        if (theList == this.listItemNames && !theList.isSelectionEmpty()) {
            int forPE = Integer.parseInt((String)this.pesbox.getSelectedItem());
            this.expandListElement(this.listsbox.getSelectedIndex(), forPE, theList.getSelectedIndex());
        }
        System.out.println("Ended generation new detailed information " + new Date().getTime());
    }

    private void enableButtons() {
        PeSet set = (PeSet)this.peList.getSelectedValue();
        this.stepButton.setEnabled(true);
        this.flushButton.setEnabled(true);
        this.continueButton.setEnabled(true);
        this.menuActionContinue.setEnabled(true);
        this.freezeButton.setEnabled(true);
        this.menuActionFreeze.setEnabled(true);
    }

    public void setCcsParameters(String host, String port) {
        this.exec.ccshost = host;
        this.exec.port = port;
    }

    public void startProgram(boolean attachMode) {
        block56: {
            gdb.terminate();
            this.isRunning = true;
            this.interpreterHandle = 0;
            if (!noWindow) {
                this.installedPythonScripts = new PythonInstalledCode(false);
            }
            this.programOutputArea.setText("");
            String executable = new File(this.getFilename()).getAbsolutePath();
            String charmrunDir = new File(executable).getParent();
            if (charmrunDir == null) {
                charmrunDir = ".";
            }
            String charmrunPath = charmrunDir + "/charmrun";
            if (envDisplay.length() == 0) {
                envDisplay = this.getEnvDisplay();
            }
            String totCommandLine = charmrunPath + " +p" + this.exec.npes + " " + executable + " " + this.exec.parameters + "  +cpd +DebugDisplay " + envDisplay + " ++server";
            if (!this.exec.doNotSuspend) {
                totCommandLine = totCommandLine + " +DebugSuspend";
            }
            if (this.exec.virtualDebug) {
                totCommandLine = totCommandLine + " +bgnetwork dummy +LBPeriod 1000000 +x1 +y1 +z";
                totCommandLine = !this.exec.recplayActive || !this.exec.recplayDetailActive || !this.exec.replayDetail ? totCommandLine + this.exec.virtualNpes : totCommandLine + "1";
            }
            if (this.exec.recplayActive) {
                if (this.exec.record) {
                    totCommandLine = totCommandLine + " +record";
                } else {
                    totCommandLine = totCommandLine + " +replay";
                    if (this.exec.recplayDetailActive) {
                        totCommandLine = this.exec.recordDetail ? totCommandLine + " +record-detail " + this.exec.selectedPes : totCommandLine + " +replay-detail " + this.exec.selectedPes + "/" + this.exec.npes;
                    }
                }
                switch (this.exec.recplayChecksum) {
                    case 1: {
                        totCommandLine = totCommandLine + " +recplay-xor";
                        break;
                    }
                    case 2: {
                        totCommandLine = totCommandLine + " +recplay-crc";
                        break;
                    }
                }
            }
            if (this.exec.port.length() != 0) {
                totCommandLine = totCommandLine + " ++server-port " + this.exec.port;
            }
            if (!this.exec.hostname.equals("localhost") || this.exec.sshport != 0) {
                if (this.exec.workingDir != null && this.exec.workingDir.length() != 0) {
                    totCommandLine = "cd " + this.exec.workingDir + "; " + totCommandLine;
                }
                if (this.exec.username.length() > 0) {
                    totCommandLine = "-l " + this.exec.username + " " + totCommandLine;
                }
                if (this.exec.sshport > 0) {
                    totCommandLine = "-p " + this.exec.sshport + " " + totCommandLine;
                }
                totCommandLine = "ssh " + this.exec.hostname + " " + totCommandLine;
            }
            System.out.println("ParDebug> " + totCommandLine);
            Process p = null;
            Runtime runtime = null;
            runtime = Runtime.getRuntime();
            if (!attachMode) {
                this.programOutputArea.setText(totCommandLine);
                try {
                    File workDir = null;
                    if (this.exec.workingDir != null && this.exec.workingDir.length() != 0) {
                        workDir = new File(this.exec.workingDir);
                    }
                    p = runtime.exec(totCommandLine, null, workDir);
                }
                catch (Exception exc) {
                    System.out.println("ParDebug> Error executing " + totCommandLine);
                    this.quitProgram();
                    return;
                }
                servthread = new ServThread.Charmrun(this, p);
                servthread.start();
                while (servthread.getFlag() == 0) {
                }
                if (servthread.getFlag() != 1) {
                    this.setStatusMessage("Failed to start program");
                    return;
                }
            } else {
                this.programOutputArea.setText("Attaching to running program\n");
                servthread = !this.exec.inputFile.equals("") ? new ServThread.File(this, new File(this.exec.inputFile), this.exec.waitFile) : new ServThread.CCS(this, this.exec);
                servthread.start();
            }
            try {
                int i;
                long iter = 0L;
                if (!attachMode || !this.exec.inputFile.equals("")) {
                    while (ParDebug.servthread.portno == null) {
                        if (!this.exec.waitFile) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (iter++ <= 600L) continue;
                            this.abort("Timeout waiting for program to start up (and print its CCS port number)");
                            continue;
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (attachMode && this.exec.inputFile.equals("") && (this.exec.port.length() == 0 || this.exec.ccshost.equals("localhost"))) {
                    JOptionPane.showMessageDialog(this, "Hostname and port number must be specified in attach mode", "Error", 0);
                    this.quitProgram();
                    return;
                }
                this.portnumber = this.exec.port.length() == 0 ? ParDebug.servthread.portno : this.exec.port;
                if (this.exec.hostname.equals("localhost")) {
                    hostnumber = ParDebug.servthread.hostName;
                }
                System.out.println("ParDebug> Charmrun started (CCS IP " + (this.exec.hostname.equals("localhost") ? hostnumber : this.exec.hostname) + ", port " + this.portnumber + ")");
                String[] ccsArgs = new String[]{this.exec.hostname.equals("localhost") ? hostnumber : this.exec.hostname, this.portnumber};
                if (this.exec.sshTunnel) {
                    System.out.println("ParDebug> Tunneling connection through ssh");
                    try {
                        String str = "ssh" + (String)(this.exec.sshport > 0 ? " -p " + this.exec.sshport : "") + " -2 -c blowfish -L " + this.portnumber + ":localhost:" + this.portnumber + " " + this.exec.hostname;
                        System.out.println("> " + str);
                        sshTunnel = runtime.exec(str);
                    }
                    catch (Exception exc) {
                        System.out.println("ParDebug> Could not create ssh tunnel");
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException exc) {
                        // empty catch block
                    }
                    ccsArgs[0] = "localhost";
                }
                System.out.println("Connecting to: " + this.exec.username + (this.exec.username.length() > 0 ? "@" : "") + (this.exec.hostname.equals("localhost") ? hostnumber : this.exec.hostname) + ":" + this.portnumber);
                CcsServer ccs = CcsServer.create(ccsArgs, false);
                this.server = new CpdUtil(ccs);
                Inspector.initialize(this.server);
                boolean success = this.getInitialInfo();
                if (!success) {
                    JOptionPane.showMessageDialog(this, "Could not gather information from executable", "Error", 0);
                    this.quitProgram();
                    return;
                }
                if (attachMode) {
                    if (this.exec.virtualDebug) {
                        JOptionPane.showInternalMessageDialog(this, "Warning, attach mode does not yet support virtual debugging!");
                    }
                    Date start = new Date();
                    byte[] stat = this.server.bcastCcsRequest("debug/converse/status", "");
                    System.out.println("status: received " + stat.length + " bytes");
                    this.exec.virtualDebug = Inspector.isEmulated();
                    this.exec.virtualNpes = this.exec.npes = stat.length / 8;
                    this.pes = new Processor[this.exec.npes];
                    for (int i2 = 0; i2 < this.exec.npes; ++i2) {
                        String peNumber = new Integer(i2).toString();
                        this.pesbox.addItem(peNumber);
                        this.pes[i2] = new Processor(i2);
                    }
                    IntBuffer b = ByteBuffer.wrap(stat).asIntBuffer();
                    for (i = 0; i < this.exec.npes; ++i) {
                        if (b.get(i * 2 + 1) != 1) continue;
                        this.pes[b.get(i * 2)].setRunning();
                    }
                    System.out.println("Single bcast connection: " + (new Date().getTime() - start.getTime()));
                } else if (this.exec.recplayActive && this.exec.recplayDetailActive && this.exec.replayDetail) {
                    this.pes = new Processor[1];
                    this.pesbox.addItem(this.exec.selectedPes);
                    this.pes[0] = new Processor(Integer.parseInt(this.exec.selectedPes));
                } else {
                    this.pes = new Processor[this.getNumPes()];
                    for (int i3 = 0; i3 < this.getNumPes(); ++i3) {
                        String peNumber = new Integer(i3).toString();
                        this.pesbox.addItem(peNumber);
                        this.pes[i3] = new Processor(i3);
                    }
                }
                if (attachMode) {
                    Processor[] fakePE = new Processor[this.exec.npes];
                    Date start = new Date();
                    byte[][] status = this.server.bcastCcsRequest("debug/converse/status", "", this.exec.npes);
                    for (i = 0; i < this.exec.npes; ++i) {
                        IntBuffer buf = ByteBuffer.wrap(status[i]).asIntBuffer();
                        if (buf.get(1) != 1) continue;
                        fakePE[buf.get(0)].setRunning();
                    }
                    System.out.println("Multiple ptp connection: " + (new Date().getTime() - start.getTime()));
                }
                PeSet all = new PeSet("all", this.pes);
                this.peListModel.addElement(all);
                this.peList.setSelectedIndex(0);
                this.peList.updateUI();
                this.startButton.setEnabled(false);
                this.menuActionStart.setEnabled(false);
                this.menuActionAttach.setEnabled(false);
                this.stepButton.setEnabled(true);
                this.flushButton.setEnabled(true);
                this.continueButton.setEnabled(true);
                this.menuActionContinue.setEnabled(true);
                this.quitButton.setEnabled(false);
                this.freezeButton.setEnabled(false);
                this.startGdbButton.setEnabled(true);
                this.menuActionDisconnect.setEnabled(true);
                this.menuActionPython.setEnabled(true);
                this.menuActionPythonInstalled.setEnabled(true);
                this.menuMemoryView.setEnabled(true);
                this.menuMemoryAllocationTree.setEnabled(true);
                this.menuMemoryLeak.setEnabled(true);
                this.menuMemoryQuickLeak.setEnabled(true);
                this.menuMemoryMark.setEnabled(true);
                this.menuMemoryUnmark.setEnabled(true);
                this.menuMemoryStatistics.setEnabled(true);
                this.enableButtons();
                int nItems = this.server.getListLength("charm/chares", 0);
                this.chareItems.load(this.server.getPList("charm/chares", 0, 0, nItems));
                this.epItems.setLookups(this.chareItems);
                nItems = this.server.getListLength("charm/entries", 0);
                this.epItems.load(this.server.getPList("charm/entries", 0, 0, nItems));
                DefaultMutableTreeNode[] chareRoots = new DefaultMutableTreeNode[this.chareItems.size()];
                System.out.println("allocated " + this.chareItems.size() + " chareRoots");
                Vector items = this.epItems.getUserEps();
                int l = items.size();
                int i4 = 0;
                DefaultMutableTreeNode root = new DefaultMutableTreeNode();
                DefaultMutableTreeNode userRoot = new DefaultMutableTreeNode("User Entries");
                for (i4 = 0; i4 < l; ++i4) {
                    EpCheckBox chkbox = new EpCheckBox((EpInfo)items.elementAt(i4));
                    chkbox.addActionListener(this);
                    chkbox.setActionCommand("breakpoints");
                    int chareType = ((EpInfo)items.elementAt(i4)).getChareType();
                    if (chareRoots[chareType] == null) {
                        chareRoots[chareType] = new DefaultMutableTreeNode(this.chareItems.elementAt(chareType).getType());
                        userRoot.add(chareRoots[chareType]);
                    }
                    chareRoots[chareType].add(new EpTreeCheckBox(chkbox));
                }
                items = this.epItems.getSystemEps();
                l = items.size();
                DefaultMutableTreeNode sysRoot = new DefaultMutableTreeNode("System Entries");
                for (i4 = 0; i4 < l; ++i4) {
                    EpCheckBox chkbox = new EpCheckBox((EpInfo)items.elementAt(i4));
                    chkbox.addActionListener(this);
                    chkbox.setActionCommand("breakpoints");
                    int chareType = ((EpInfo)items.elementAt(i4)).getChareType();
                    if (chareRoots[chareType] == null) {
                        chareRoots[chareType] = new DefaultMutableTreeNode(this.chareItems.elementAt(chareType).getType());
                        sysRoot.add(chareRoots[chareType]);
                    }
                    chareRoots[chareType].add(new EpTreeCheckBox(chkbox));
                }
                root.add(sysRoot);
                root.add(userRoot);
                JTree treeBP = new JTree(root);
                treeBP.setRootVisible(false);
                treeBP.collapseRow(0);
                treeBP.expandRow(1);
                treeBP.addMouseListener(new EpTreeListener(treeBP));
                treeBP.setCellRenderer(new EpTreeRenderer());
                treeBP.getSelectionModel().setSelectionMode(1);
                this.entryScrollPane.setViewportView(treeBP);
                nItems = this.server.getListLength("charm/messages", 0);
                this.msgItems.load(this.server.getPList("charm/messages", 0, 0, nItems));
                this.messageQueue.setLookups(this.epItems, this.msgItems, this.chareItems);
                nItems = this.server.getListLength("charm/objectNames", 0);
                this.groupItems.load(this.server.getPList("charm/objectNames", 0, 0, nItems));
            }
            catch (Exception e) {
                System.out.println("Error while starting the application (error: " + e + ". Aborting...");
                e.printStackTrace();
                if (attachMode) break block56;
                p.destroy();
            }
        }
        this.listsbox.setEnabled(true);
        this.pesbox.setEnabled(true);
        this.quitButton.setEnabled(true);
        this.listsbox.setSelectedIndex(3);
    }

    public void quitProgram() {
        gdb.terminate();
        this.isRunning = false;
        if (sshTunnel != null) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sshTunnel.destroy();
            sshTunnel = null;
        }
        this.startButton.setEnabled(true);
        this.stepButton.setEnabled(false);
        this.flushButton.setEnabled(false);
        this.continueButton.setEnabled(false);
        this.quitButton.setEnabled(false);
        this.freezeButton.setEnabled(false);
        this.startGdbButton.setEnabled(false);
        this.listModel.removeAllElements();
        this.outputArea.setList(null);
        this.newOutputArea.setText("");
        this.listsbox.setEnabled(false);
        this.pesbox.removeAllItems();
        this.pesbox.setEnabled(false);
        this.menuActionStart.setEnabled(true);
        this.menuActionAttach.setEnabled(true);
        this.menuActionContinue.setEnabled(false);
        this.menuActionFreeze.setEnabled(false);
        this.menuActionDisconnect.setEnabled(false);
        this.menuActionQuit.setEnabled(false);
        this.menuActionPython.setEnabled(false);
        this.menuActionPythonInstalled.setEnabled(false);
        this.menuMemoryView.setEnabled(false);
        this.menuMemoryAllocationTree.setEnabled(false);
        this.menuMemoryLeak.setEnabled(false);
        this.menuMemoryQuickLeak.setEnabled(false);
        this.menuMemoryMark.setEnabled(false);
        this.menuMemoryUnmark.setEnabled(false);
        this.menuMemoryStatistics.setEnabled(false);
        this.peList.removeAll();
        this.peListModel.removeAllElements();
        this.peList.updateUI();
        if (this.installedPythonScripts != null) {
            this.installedPythonScripts.dispose();
        }
        this.entryScrollPane.setViewportView(new JLabel());
        this.setStatusMessage(new String("Ready to start new program"));
    }

    private boolean getInitialInfo() {
        boolean success;
        String initialInfo;
        String executable = new File(this.getFilename()).getAbsolutePath();
        String OS = System.getProperty("os.name");
        System.out.println("OS: " + OS);
        boolean macOS = false;
        if (OS.startsWith("Mac OS")) {
            macOS = true;
        }
        String totCommandLine = macOS ? "size -m -l " + executable : "size -A " + executable;
        System.out.println(totCommandLine);
        String hostname = this.getHostname();
        Object commandLinePrefix = "";
        if (!hostname.equals("localhost")) {
            commandLinePrefix = hostname + " ";
            String username = this.getUsername();
            if (!username.equals("")) {
                commandLinePrefix = "-l " + username + " " + (String)commandLinePrefix;
            }
            commandLinePrefix = "ssh " + (String)commandLinePrefix;
        }
        try {
            int c;
            Process p = Runtime.getRuntime().exec((String)commandLinePrefix + totCommandLine);
            BufferedReader output = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuffer reply = new StringBuffer();
            while ((c = output.read()) != -1) {
                reply.append((char)c);
            }
            initialInfo = reply.toString();
        }
        catch (Exception e) {
            System.out.println("Failed to start gdb info program");
            return false;
        }
        int dataSize = 0;
        int bssPos = 0;
        int bssSize = 0;
        if (!macOS) {
            try {
                int dataInitial = initialInfo.indexOf("\n.data ");
                dataFinal = initialInfo.indexOf("\n", dataInitial + 1);
                dataValues = initialInfo.substring(dataInitial + 6, dataFinal).trim();
                endSize = dataValues.indexOf(32);
                startPos = dataValues.lastIndexOf(32);
                dataSize = Integer.parseInt(dataValues.substring(0, endSize));
                dataPos = Integer.parseInt(dataValues.substring(startPos + 1));
                System.out.println("string1: |" + initialInfo.substring(dataInitial + 6, dataFinal).trim() + "| " + dataSize + " " + dataPos);
                bssInitial = initialInfo.indexOf("\n.bss");
                bssFinal = initialInfo.indexOf("\n", bssInitial + 1);
                bssValues = initialInfo.substring(bssInitial + 6, bssFinal).trim();
                endSize = bssValues.indexOf(32);
                startPos = bssValues.lastIndexOf(32);
                bssSize = Integer.parseInt(bssValues.substring(0, endSize));
                bssPos = Integer.parseInt(bssValues.substring(startPos + 1));
                System.out.println("string1: |" + initialInfo.substring(bssInitial + 5, bssFinal).trim() + "| " + bssSize + " " + bssPos);
                success = true;
            }
            catch (Exception e) {
                System.out.println("Failed to read ELF format" + e);
                success = false;
            }
        } else {
            try {
                int dataInitial = initialInfo.indexOf("data:");
                dataFinal = initialInfo.indexOf("\n", dataInitial + 1);
                dataValues = initialInfo.substring(dataInitial + 7, dataFinal).trim();
                endSize = dataValues.indexOf(32);
                startPos = dataValues.lastIndexOf(32);
                dataSize = Integer.parseInt(dataValues.substring(0, endSize));
                dataPos = Integer.parseInt(dataValues.substring(startPos + 1, dataValues.length() - 1));
                System.out.println("string1: |" + initialInfo.substring(dataInitial + 6, dataFinal).trim() + "| " + dataSize + " " + dataPos);
                bssInitial = initialInfo.indexOf("bss:");
                bssFinal = initialInfo.indexOf("\n", bssInitial + 1);
                bssValues = initialInfo.substring(bssInitial + 6, bssFinal).trim();
                endSize = bssValues.indexOf(32);
                startPos = bssValues.lastIndexOf(32);
                bssSize = Integer.parseInt(bssValues.substring(0, endSize));
                bssPos = Integer.parseInt(bssValues.substring(startPos + 1, bssValues.length() - 1));
                System.out.println("string1: |" + initialInfo.substring(bssInitial + 5, bssFinal).trim() + "| " + bssSize + " " + bssPos);
                success = true;
            }
            catch (Exception e) {
                System.out.println("Failed to read MAC format: " + e.toString());
                success = false;
            }
        }
        if (!success) {
            totCommandLine = "dump -h -Xany " + executable;
            try {
                int c;
                Process p = Runtime.getRuntime().exec((String)commandLinePrefix + totCommandLine);
                BufferedReader output = new BufferedReader(new InputStreamReader(p.getInputStream()));
                StringBuffer reply = new StringBuffer();
                while ((c = output.read()) != -1) {
                    reply.append((char)c);
                }
                initialInfo = reply.toString();
            }
            catch (Exception e) {
                System.out.println("Failed to start gdb info program");
                return false;
            }
            try {
                int dataInitial = initialInfo.indexOf("Section Header for .data");
                dataInitial = initialInfo.indexOf("0x", dataInitial + 1);
                int dataFinal = initialInfo.indexOf(32, dataInitial + 1);
                dataPos = (int)Long.parseLong(initialInfo.substring(dataInitial + 2, dataFinal), 16);
                dataInitial = initialInfo.indexOf("0x", dataInitial + 1);
                dataInitial = initialInfo.indexOf("0x", dataInitial + 1);
                dataInitial = initialInfo.indexOf("0x", dataInitial + 1);
                dataFinal = initialInfo.indexOf(32, dataInitial + 1);
                dataSize = Integer.parseInt(initialInfo.substring(dataInitial + 2, dataFinal), 16);
                System.out.println("string1: " + dataSize + " " + dataPos);
                int bssInitial = initialInfo.indexOf("Section Header for .bss");
                bssInitial = initialInfo.indexOf("0x", bssInitial + 1);
                int bssFinal = initialInfo.indexOf(32, bssInitial + 1);
                bssPos = (int)Long.parseLong(initialInfo.substring(bssInitial + 2, bssFinal), 16);
                bssInitial = initialInfo.indexOf("0x", bssInitial + 1);
                bssInitial = initialInfo.indexOf("0x", bssInitial + 1);
                bssInitial = initialInfo.indexOf("0x", bssInitial + 1);
                bssFinal = initialInfo.indexOf(32, bssInitial + 1);
                bssSize = Integer.parseInt(initialInfo.substring(bssInitial + 2, bssFinal), 16);
                System.out.println("string1: " + bssSize + " " + bssPos);
                success = true;
            }
            catch (Exception e) {
                System.out.println("Failed to read XCOFF format");
                success = false;
            }
        }
        if (!success) {
            return false;
        }
        if (Inspector.is64bit()) {
            globals = new byte[40];
            CcsServer.writeLong(globals, 0, dataPos);
            CcsServer.writeLong(globals, 8, dataPos + dataSize);
            CcsServer.writeLong(globals, 16, bssPos);
            CcsServer.writeLong(globals, 24, bssPos + bssSize);
        } else {
            globals = new byte[24];
            CcsServer.writeInt(globals, 0, dataPos);
            CcsServer.writeInt(globals, 4, dataPos + dataSize);
            CcsServer.writeInt(globals, 8, bssPos);
            CcsServer.writeInt(globals, 12, bssPos + bssSize);
        }
        return true;
    }

    public static void printUsage() {
        System.out.println("Usage: charmdebug [options] [<executable> [<arguments>] ]");
        System.out.println("  -host <name>        remote host where to start the application");
        System.out.println("  -user <name>        username to use for ssh");
        System.out.println("  -sshport <num>      port to use for ssh");
        System.out.println("  -port <num>         use specific CCS port");
        System.out.println("  -pes <num> (or +p<num>)");
        System.out.println("                      number of processors to use");
        System.out.println("  -dir <dir>          specify working directory");
        System.out.println("  -outputfile <file>  file where to read program output (for attach)");
        System.out.println("  -waitfile           wait for output file to be created (for attach)");
        System.out.println("  -sshtunnel          tunnel CCS requests though ssh");
        System.out.println("  -config <file>      read configuration parameters from file");
        System.out.println("  -commands <file>    execute commands read from file at startup");
        System.out.println("  -virtual <num>      number of virtual processors to use (must use Charm++ built with bigsim support)");
    }

    String getFilename() {
        if (this.exec.executable.charAt(0) == '/') {
            return this.exec.executable;
        }
        return this.exec.workingDir + (this.exec.workingDir.equals("") || this.exec.workingDir.endsWith("/") ? "" : "/") + this.exec.executable;
    }

    String getHostname() {
        return this.exec.hostname;
    }

    String getUsername() {
        return this.exec.username;
    }

    int getSshPort() {
        return this.exec.sshport;
    }

    EpPList getEpItems() {
        return (EpPList)this.epItems.clone();
    }

    CharePList getGroupItems() {
        return this.groupItems;
    }

    Execution getExecution() {
        return this.exec;
    }

    public static void main(String[] args) {
        int i;
        Execution exec = new Execution();
        exec.hostname = "localhost";
        exec.username = "";
        exec.executable = "";
        exec.workingDir = System.getProperty("user.dir");
        exec.port = "";
        exec.ccshost = "";
        exec.npes = 1;
        String numberPesString = "1";
        String sshportString = null;
        exec.parameters = "";
        exec.inputFile = "";
        exec.waitFile = false;
        envDisplay = "";
        exec.sshTunnel = false;
        sshTunnel = null;
        noWindow = false;
        File commands = null;
        boolean gotFilename = false;
        for (i = 0; i < args.length; i += 2) {
            if (args[i].equals("-host")) {
                exec.hostname = args[i + 1];
                continue;
            }
            if (args[i].equals("-user")) {
                exec.username = args[i + 1];
                continue;
            }
            if (args[i].equals("-sshport")) {
                sshportString = args[i + 1];
                try {
                    exec.sshport = Integer.parseInt(sshportString);
                }
                catch (NumberFormatException e) {
                    System.out.println("Could not understand the specified ssh port number");
                }
                continue;
            }
            if (args[i].equals("-ccshost")) {
                exec.ccshost = args[i + 1];
                continue;
            }
            if (args[i].equals("-port")) {
                exec.port = args[i + 1];
                continue;
            }
            if (args[i].equals("-file")) {
                exec.executable = args[i + 1];
                continue;
            }
            if (args[i].equals("-param")) {
                exec.parameters = args[i + 1];
                continue;
            }
            if (args[i].equals("-pes") || args[i].equals("+p")) {
                numberPesString = args[i + 1];
                try {
                    exec.npes = Integer.parseInt(numberPesString);
                }
                catch (NumberFormatException e) {
                    System.out.println("Could not understand the specified number of processors");
                }
                continue;
            }
            if (args[i].equals("-virtual")) {
                exec.virtualDebug = true;
                try {
                    exec.virtualNpes = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Could not understand the specified number of virtual processors");
                }
                continue;
            }
            if (args[i].equals("-display")) {
                envDisplay = args[i + 1];
                continue;
            }
            if (args[i].equals("-dir")) {
                exec.workingDir = args[i + 1];
                continue;
            }
            if (args[i].equals("-outputfile")) {
                exec.inputFile = args[i + 1];
                continue;
            }
            if (args[i].equals("-waitfile")) {
                exec.waitFile = true;
                --i;
                continue;
            }
            if (args[i].equals("-sshtunnel")) {
                exec.sshTunnel = true;
                --i;
                continue;
            }
            if (args[i].equals("-noWindow")) {
                noWindow = true;
                --i;
                continue;
            }
            if (args[i].equals("-config")) {
                try {
                    File config = new File(args[i + 1]);
                    System.out.println("Config: " + config.getAbsolutePath());
                    exec = Execution.load(new File(args[i + 1]));
                }
                catch (IOException ioe) {
                    System.out.println("Could not open configuration file ");
                    ioe.printStackTrace();
                }
                catch (ClassNotFoundException cnfe) {
                    System.out.println("Configuration file corrupted");
                }
                catch (SAXException se) {
                    System.out.println("Configuration file corrupted");
                }
                continue;
            }
            if (args[i].equals("-commands")) {
                commands = new File(args[i + 1]);
                continue;
            }
            if (args[i].startsWith("+p")) {
                numberPesString = args[i].substring(2);
                try {
                    exec.npes = Integer.parseInt(numberPesString);
                }
                catch (NumberFormatException e) {
                    System.out.println("Could not understand the specified number of processors");
                }
            } else if (!gotFilename) {
                if (args[i].startsWith("-") || args[i].startsWith("+")) {
                    ParDebug.printUsage();
                    System.exit(1);
                } else {
                    exec.executable = args[i];
                    gotFilename = true;
                }
            } else {
                exec.parameters = exec.parameters + " " + args[i];
            }
            --i;
        }
        if (i > args.length) {
            ParDebug.printUsage();
            System.exit(1);
        }
        PeSet.CellRenderer.initIcons();
        debugger = new ParDebug(exec);
        if (!noWindow) {
            appFrame = new JFrame("Charm Parallel Debugger");
            appFrame.setSize(1000, 1000);
            appFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (ParDebug.debugger.isRunning) {
                        ParDebug.debugger.server.bcastCcsRequest("debug/converse/quit", "");
                        debugger.quitProgram();
                    }
                    ParDebug.debugger.preferences.save();
                    System.exit(0);
                }
            });
            appFrame.getContentPane().add((Component)debugger, "Center");
            Rectangle bounds = appFrame.getGraphicsConfiguration().getBounds();
            appFrame.setLocation(50 + bounds.x, 50 + bounds.y);
            appFrame.setJMenuBar(ParDebug.debugger.menuBar);
            appFrame.pack();
            if (debugger.getPreferredSize() != null) {
                appFrame.setSize(debugger.getPreferredSize());
            }
            if (debugger.getPreferredLocation() != null) {
                appFrame.setLocation(debugger.getPreferredLocation());
            }
            appFrame.setVisible(true);
        }
        if (commands != null) {
            Commands cmds = new Commands(commands, debugger);
            debugger.addNotifyListener(cmds);
            SwingUtilities.invokeLater(cmds);
        }
    }

    static {
        appFrame = null;
    }

    private class CpdListInfo {
        public String display;
        public String name;
        public String detailedName;
        public GenericPList list;

        public CpdListInfo(String display_, String name_) {
            this.display = display_;
            this.name = name_;
            this.detailedName = null;
            this.list = null;
        }

        public CpdListInfo(String display_, String name_, String detailed_, GenericPList list_) {
            this.display = display_;
            this.name = name_;
            this.detailedName = detailed_;
            this.list = list_;
        }
    }

    private class PeSetListener
    implements ListSelectionListener {
        private PeSetListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            PeSet set = (PeSet)ParDebug.this.peList.getSelectedValue();
            if (set != null) {
                int i;
                ParDebug.this.enableButtons();
                SortedSet actualSet = set.getList();
                Vector data = ParDebug.this.epItems.getSystemEps();
                for (i = 0; i < data.size(); ++i) {
                    ((EpInfo)data.elementAt(i)).getCheckBox().setCoverageColor(actualSet);
                }
                data = ParDebug.this.epItems.getUserEps();
                for (i = 0; i < data.size(); ++i) {
                    ((EpInfo)data.elementAt(i)).getCheckBox().setCoverageColor(actualSet);
                }
                ParDebug.this.entryScrollPane.repaint();
            }
        }
    }

    private class NotifyGUI
    implements NotifyListener {
        private NotifyGUI() {
        }

        @Override
        public void receiveNotification(NotifyEvent e) {
            switch (e.type) {
                case 1: {
                    this.notifyBreakpoint(e.pe, e.txt);
                    break;
                }
                case 4: {
                    this.notifyFreeze(e.pe, e.txt);
                    break;
                }
                case 2: {
                    this.notifyAbort(e.pe, e.txt);
                    break;
                }
                case 3: {
                    this.notifySignal(e.pe, e.txt);
                    break;
                }
                case 5: {
                    this.notifyCorruption(e.pe, e.txt);
                }
            }
        }

        public void notifyBreakpoint(int pe, String txt) {
            int forPE;
            System.out.println("notifyBreakpoint: " + txt + " pe=" + pe);
            if (ParDebug.this.pes[pe].isFrozen()) {
                System.err.println("Error: processor " + pe + " already frozen!");
                return;
            }
            ParDebug.this.pes[pe].setFrozen();
            ParDebug.this.enableButtons();
            ParDebug.this.peList.repaint();
            CpdListInfo list = ParDebug.this.cpdLists[ParDebug.this.listsbox.getSelectedIndex()];
            if (list.list == ParDebug.this.messageQueue && (forPE = Integer.parseInt((String)ParDebug.this.pesbox.getSelectedItem())) == pe) {
                ParDebug.this.populateNewList(ParDebug.this.listsbox.getSelectedIndex(), forPE, ParDebug.this.listModel);
            }
        }

        public void notifyFreeze(int pe, String txt) {
            int forPE;
            System.out.println("notifyFreeze: " + txt + " pe=" + pe);
            if (ParDebug.this.pes[pe].isFrozen()) {
                System.err.println("Error: processor " + pe + " already frozen!");
                return;
            }
            ParDebug.this.pes[pe].setFrozen();
            ParDebug.this.enableButtons();
            ParDebug.this.peList.repaint();
            CpdListInfo list = ParDebug.this.cpdLists[ParDebug.this.listsbox.getSelectedIndex()];
            if (list.list == ParDebug.this.messageQueue && (forPE = Integer.parseInt((String)ParDebug.this.pesbox.getSelectedItem())) == pe) {
                ParDebug.this.populateNewList(ParDebug.this.listsbox.getSelectedIndex(), forPE, ParDebug.this.listModel);
            }
        }

        public void notifyAbort(int pe, String txt) {
            int forPE;
            System.out.println("notifyAbort: " + txt + " pe=" + pe);
            ParDebug.this.pes[pe].setDead();
            ParDebug.this.enableButtons();
            ParDebug.this.peList.repaint();
            CpdListInfo list = ParDebug.this.cpdLists[ParDebug.this.listsbox.getSelectedIndex()];
            if (list.list == ParDebug.this.messageQueue && (forPE = Integer.parseInt((String)ParDebug.this.pesbox.getSelectedItem())) == pe) {
                ParDebug.this.populateNewList(ParDebug.this.listsbox.getSelectedIndex(), forPE, ParDebug.this.listModel);
            }
        }

        public void notifySignal(int pe, String txt) {
            int forPE;
            int signal = Integer.parseInt(txt);
            System.out.println("notifySignal: " + txt + " pe=" + pe + ", sigNo=" + signal);
            ParDebug.this.pes[pe].setDead();
            ParDebug.this.enableButtons();
            ParDebug.this.peList.repaint();
            CpdListInfo list = ParDebug.this.cpdLists[ParDebug.this.listsbox.getSelectedIndex()];
            if (list.list == ParDebug.this.messageQueue && (forPE = Integer.parseInt((String)ParDebug.this.pesbox.getSelectedItem())) == pe) {
                ParDebug.this.populateNewList(ParDebug.this.listsbox.getSelectedIndex(), forPE, ParDebug.this.listModel);
            }
        }

        public void notifyCorruption(int pe, String txt) {
            int i;
            int space = txt.indexOf(32);
            String address = txt.substring(0, space);
            txt = txt.substring(space + 1);
            space = txt.indexOf(32);
            int chare = Integer.parseInt(txt.substring(0, space));
            txt = txt.substring(space + 1);
            space = txt.indexOf(32);
            int owner = Integer.parseInt(txt.substring(0, space));
            System.out.print("cross corruption: chare " + chare + " accessed memory location " + address + " owned by chare " + owner);
            txt = txt.substring(space + 1);
            space = txt.indexOf(32);
            int count = Integer.parseInt(txt.substring(0, space));
            if (count > 0) {
                System.out.println(": {");
            }
            for (i = 0; i < count; ++i) {
                txt = txt.substring(space + 1);
                space = txt.indexOf(32);
                System.out.println("  " + Symbol.get(Long.parseLong(txt.substring(2, space), 16)));
            }
            if (count > 0) {
                System.out.print("}");
            }
            if ((count = Integer.parseInt((txt = txt.substring(space + 1)).substring(0, space = txt.indexOf(32)))) > 0) {
                System.out.println(" Stack trace of corruption: {");
            }
            for (i = 0; i < count; ++i) {
                txt = txt.substring(space + 1);
                space = txt.indexOf(32);
                System.out.println("  " + Symbol.get(Long.parseLong(txt.substring(2, space), 16)));
            }
            if (count > 0) {
                System.out.print("}");
            }
            System.out.println();
        }
    }
}

