/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PasswordDialog
extends JDialog
implements ActionListener {
    private static String OK = "ok";
    private static String CANCEL = "cancel";
    private char[] result;
    private JPasswordField passwordField;

    public PasswordDialog(char[] res) {
        this.setTitle("Password Requested");
        this.result = res;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                PasswordDialog.this.passwordField.requestFocusInWindow();
            }

            public void windowClosing() {
                PasswordDialog.this.result = null;
                PasswordDialog.this.dispose();
            }
        });
        JPanel main = new JPanel();
        main.setLayout(new GridLayout(0, 1));
        this.passwordField = new JPasswordField(10);
        this.passwordField.setActionCommand(OK);
        this.passwordField.addActionListener(this);
        JLabel label = new JLabel("Enter the password: ");
        label.setLabelFor(this.passwordField);
        JComponent buttonPane = this.createButtonPanel();
        JPanel textPane = new JPanel(new FlowLayout(4));
        textPane.add(label);
        textPane.add(this.passwordField);
        main.add(textPane);
        main.add(buttonPane);
        this.setContentPane(main);
        this.pack();
        this.setVisible(true);
    }

    protected JComponent createButtonPanel() {
        JPanel p = new JPanel(new GridLayout(1, 0));
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.setActionCommand(OK);
        cancelButton.setActionCommand(CANCEL);
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        p.add(okButton);
        p.add(cancelButton);
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (CANCEL.equals(cmd)) {
            this.result = null;
        } else if (OK.equals(cmd)) {
            this.result = this.passwordField.getPassword();
        }
    }

    protected void resetFocus() {
        this.passwordField.requestFocusInWindow();
    }
}

