/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.Processor;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;

public class PeSet {
    private String name;
    SortedSet list;
    int numRunning = 0;
    int numDead = 0;
    int numConditional;

    public PeSet(String n, Processor[] l) {
        this.name = n;
        this.list = new TreeSet();
        for (int i = 0; i < l.length; ++i) {
            this.list.add(l[i]);
            l[i].addToSet(this);
            if (l[i].isDead()) {
                ++this.numDead;
                continue;
            }
            if (l[i].isFrozen()) continue;
            ++this.numRunning;
        }
    }

    public PeSet(String n, SortedSet l) {
        this.name = n;
        this.list = l;
        for (Processor p : l) {
            p.addToSet(this);
            if (p.isDead()) {
                ++this.numDead;
                continue;
            }
            if (p.isFrozen()) continue;
            ++this.numRunning;
        }
    }

    public String toString() {
        return this.name;
    }

    public String getDetail() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.getList().iterator();
        while (iter.hasNext()) {
            buf.append(" " + iter.next());
        }
        return buf.toString();
    }

    public String getName() {
        return this.name;
    }

    public SortedSet getList() {
        return this.list;
    }

    void setRunning() {
        ++this.numRunning;
    }

    void setFrozen() {
        --this.numRunning;
    }

    void setDead() {
        ++this.numDead;
    }

    void unsetDead() {
        --this.numDead;
    }

    void setConditional() {
        ++this.numConditional;
    }

    void unsetConditional() {
        --this.numConditional;
    }

    public boolean isAllRunning() {
        return this.numRunning == this.list.size();
    }

    public boolean isAllFrozen() {
        return this.numRunning == 0;
    }

    public boolean isSomeDead() {
        return this.numDead > 0;
    }

    public boolean isSomeConditional() {
        return this.numConditional > 0;
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public PeSetIterator runningIterator() {
        return new Running();
    }

    public PeSetIterator frozenIterator() {
        return new Frozen();
    }

    public int[] toIDsArray() {
        int[] result = new int[this.list.size()];
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i] = ((Processor)iter.next()).getId();
            ++i;
        }
        return result;
    }

    public class Running
    extends PeSetIterator {
        Object next;

        public Running() {
            this.iter = PeSet.this.list.iterator();
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Object result = this.next;
            this.next = null;
            while (this.iter.hasNext()) {
                Object tmp = this.iter.next();
                if (!((Processor)tmp).isRunning()) continue;
                this.next = tmp;
                break;
            }
            return result;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    public class Frozen
    extends PeSetIterator {
        Object next;

        public Frozen() {
            this.iter = PeSet.this.list.iterator();
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Object result = this.next;
            this.next = null;
            while (this.iter.hasNext()) {
                Object tmp = this.iter.next();
                if (!((Processor)tmp).isFrozen()) continue;
                this.next = tmp;
                break;
            }
            return result;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    public static class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        static ImageIcon runningIcon;
        static ImageIcon frozenIcon;
        static ImageIcon run_frozenIcon;
        static ImageIcon deadIcon;

        public static void initIcons() {
            runningIcon = new ImageIcon(CellRenderer.class.getResource("running.gif"));
            frozenIcon = new ImageIcon(CellRenderer.class.getResource("frozen.gif"));
            run_frozenIcon = new ImageIcon(CellRenderer.class.getResource("run-frozen.gif"));
            deadIcon = new ImageIcon(CellRenderer.class.getResource("dead.gif"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            PeSet set = (PeSet)value;
            if (set.isSomeDead()) {
                this.setIcon(deadIcon);
            } else if (set.isAllRunning()) {
                this.setIcon(runningIcon);
            } else if (set.isAllFrozen()) {
                this.setIcon(frozenIcon);
            } else {
                this.setIcon(run_frozenIcon);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    public static class PopupListener
    extends MouseAdapter {
        JPopupMenu popupShort;
        JPopupMenu popupLong;
        JList list;

        PopupListener(ActionListener listener, JList l) {
            this.list = l;
            this.popupShort = new JPopupMenu();
            this.popupLong = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Create new...");
            menuItem.setActionCommand("newPeSet");
            menuItem.addActionListener(listener);
            this.popupShort.add(menuItem);
            menuItem = new JMenuItem("Create new...");
            menuItem.setActionCommand("newPeSet");
            menuItem.addActionListener(listener);
            this.popupLong.add(menuItem);
            menuItem = new JMenuItem("View details");
            menuItem.setActionCommand("peSetDetails");
            menuItem.addActionListener(listener);
            this.popupLong.add(menuItem);
            menuItem = new JMenuItem("Delete");
            menuItem.setActionCommand("deletePeSet");
            menuItem.addActionListener(listener);
            this.popupLong.add(menuItem);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            int idx;
            if (e.isPopupTrigger() && (idx = this.list.locationToIndex(e.getPoint())) >= 0) {
                Rectangle range = this.list.getCellBounds(idx, idx);
                if (range.contains(e.getPoint())) {
                    this.list.setSelectedIndex(idx);
                    this.popupLong.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    this.popupShort.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    public abstract class PeSetIterator
    implements Iterator {
        Iterator iter;

        public int[] toIDs() {
            Processor p;
            int size = PeSet.this.list.size();
            int[] result = new int[size];
            int count = 0;
            while ((p = (Processor)this.next()) != null) {
                result[count++] = p.getId();
            }
            if (count != size) {
                result = Arrays.copyOf(result, count);
            }
            return result;
        }
    }
}

