/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.ParDebug;
import java.util.Hashtable;

public class Symbol {
    public static Hashtable symbolTable = new Hashtable();
    private long location;
    private String function;
    private int line;
    private String file;

    public String toString() {
        return this.function + " (0x" + Long.toHexString(this.location) + ") at " + this.file + ":" + this.line;
    }

    public Symbol(long loc, String str, int l, String f) {
        this.location = loc;
        this.function = str;
        this.line = l;
        this.file = f;
    }

    public String getFunction() {
        return this.function;
    }

    public boolean equals(Symbol o) {
        return this.location == o.location;
    }

    public boolean equals(long loc) {
        return this.location == loc;
    }

    public static Symbol get(long location) {
        Symbol s = (Symbol)symbolTable.get(new Long(location));
        if (s == null) {
            int index2;
            String res1 = ParDebug.infoCommand("info symbol " + location + "\n");
            int index = res1.indexOf(43);
            String funcName = index >= 0 ? res1.substring(0, index).trim() : "??";
            String res2 = ParDebug.infoCommand("info line *" + location + "\n");
            index = res2.indexOf("Line");
            String fileName = "??";
            int line = 0;
            if (index >= 0 && (index2 = res2.indexOf(32, index + 5)) >= 0) {
                line = Integer.parseInt(res2.substring(index + 5, index2));
                index = res2.indexOf(34);
                index2 = res2.indexOf(34, index + 1);
                fileName = res2.substring(index + 1, index2).trim();
            }
            s = new Symbol(location, funcName, line, fileName);
            Symbol.put(location, s);
        }
        return s;
    }

    public static void put(long location, Symbol s) {
        symbolTable.put(new Long(location), s);
    }
}

