/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.ParDebug;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.inspect.DataType;
import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.InspectedElement;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.JTreeVisitor;
import charm.debug.inspect.SuperClassElement;
import charm.debug.inspect.VariableElement;
import charm.debug.pdata.MsgPList;
import charm.debug.pdata.Slot;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.ByteBuffer;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class InspectPanel
extends JPanel
implements ActionListener {
    private JScrollPane scroll;
    private JTree tree;
    int pe;
    JMenuItem menuItemFollow;
    JMenuItem menuItemCast;
    JMenuItem menuItemCastReset;

    public InspectPanel() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(100, 100));
        this.scroll = new JScrollPane();
        this.add(this.scroll);
    }

    public void clear() {
        this.scroll.setViewportView(new JLabel(""));
    }

    public void load(String s) {
        this.scroll.setViewportView(new JLabel(s));
    }

    public boolean load(int pe, Slot slot, GenericType type) {
        this.pe = pe;
        long location = slot.getLocation();
        System.out.println("location = " + (int)location + ", " + (int)(location >>> 32));
        if (slot.getType() == 4) {
            PList list = ParDebug.debugger.server.getPList("converse/message", pe, (int)location, (int)(location >>> 32));
            MsgPList msg = ParDebug.debugger.getMessageList();
            msg.load(list);
            msg.elementAt(0).getDetails(this);
            return true;
        }
        PList list = ParDebug.debugger.server.getPList("memory/data", pe, (int)location, (int)(location >>> 32));
        if (list == null) {
            System.out.println("list is null!");
        }
        PList cur = (PList)list.elementAt(0);
        int size = ((PNative)cur.elementNamed("size")).getIntValue(0);
        System.out.println("Got memory data size = " + size);
        if (size > 0) {
            ByteBuffer buf = null;
            int startingPoint = 0;
            PAbstract info = cur.elementNamed("value");
            if (info != null) {
                buf = ByteBuffer.wrap(((PString)info).getBytes()).order(Inspector.getByteOrder());
            }
            if (type == null) {
                Object request2 = "info symbol 0x";
                request2 = Inspector.is64bit() ? (String)request2 + Long.toHexString(buf.getLong()) : (String)request2 + Integer.toHexString(buf.getInt());
                String result = ParDebug.infoCommand((String)(request2 = (String)request2 + "\n"));
                if (result.startsWith("vtable for")) {
                    String strtype = result.substring(10, result.indexOf(43)).trim();
                    GenericType gt = Inspector.getTypeCreate(strtype);
                    this.load(new SuperClassElement(gt, 0), buf, 0);
                    return true;
                }
                buf.rewind();
                for (int i = 0; i < size; ++i) {
                    System.out.print("0x" + Integer.toHexString(buf.get()) + " ");
                }
                JOptionPane.showMessageDialog(this, "The selected memory block does not contain enough information to be displayed.", "Unknown data", 1);
                return false;
            }
            this.load(new SuperClassElement(type, 0), buf, startingPoint);
            return true;
        }
        JOptionPane.showMessageDialog(this, "The selected memory block does not contain any data.", "No data", 1);
        return false;
    }

    public void load(GenericElement type, ByteBuffer buf, int starting) {
        JTreeVisitor jtv = new JTreeVisitor(buf, starting, type.getName());
        jtv.visit(type);
        this.tree = (JTree)jtv.getResult();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.scroll.setViewportView(this.tree);
        JPopupMenu popup = new JPopupMenu();
        this.menuItemFollow = new JMenuItem("Follow pointer");
        this.menuItemFollow.setActionCommand("dereference");
        this.menuItemFollow.addActionListener(this);
        popup.add(this.menuItemFollow);
        this.menuItemCast = new JMenuItem("Cast");
        this.menuItemCast.setActionCommand("cast");
        this.menuItemCast.addActionListener(this);
        popup.add(this.menuItemCast);
        this.menuItemCast = new JMenuItem("Reset Cast");
        this.menuItemCast.setActionCommand("resetcast");
        this.menuItemCast.addActionListener(this);
        popup.add(this.menuItemCast);
        PopupListener popupListener = new PopupListener(popup);
        this.tree.addMouseListener(popupListener);
    }

    public void addBeforeTree(MutableTreeNode node) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        model.insertNodeInto(node, root, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode obj = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        InspectedElement el = (InspectedElement)obj.getUserObject();
        if (el.value == null) {
            return;
        }
        long location = Long.parseLong(el.value.substring(el.value.indexOf("0x") + 2), 16);
        if (e.getActionCommand().equals("dereference")) {
            if (location > 0L) {
                PList list = ParDebug.debugger.server.getPList("memory/data", this.pe, (int)location, (int)(location >>> 32));
                if (list == null) {
                    System.out.println("list is null!");
                }
                PList cur = (PList)list.elementAt(0);
                int size = ((PNative)cur.elementNamed("size")).getIntValue(0);
                System.out.println("Got memory data size = " + size);
                if (size > 0) {
                    ByteBuffer buf = null;
                    PAbstract info = cur.elementNamed("value");
                    if (info != null) {
                        buf = ByteBuffer.wrap(((PString)info).getBytes()).order(Inspector.getByteOrder());
                    }
                    JTreeVisitor jtv = new JTreeVisitor(buf, 0, el.e.getType().getName());
                    int arraySize = 0;
                    arraySize = el.e.getPointer() > 1 ? size / Inspector.getPointerSize() : size / el.e.getType().getSize();
                    if (arraySize == 1) {
                        arraySize = 0;
                    }
                    VariableElement vel = new VariableElement(el.e.getType(), null, arraySize, el.e.getPointer() + el.e.getType().getPointer() - 1, 0);
                    jtv.visit(vel);
                    ((DefaultTreeModel)this.tree.getModel()).insertNodeInto((DefaultMutableTreeNode)jtv.top.getFirstChild(), obj, 0);
                } else {
                    JOptionPane.showMessageDialog(this, "No data found", "Missing data", 0);
                }
            }
        } else if (e.getActionCommand().equals("cast")) {
            String newType = JOptionPane.showInputDialog("Please enter the new type name");
            if (newType != null) {
                newType = newType.trim();
                int pointer = 0;
                while (newType.charAt(newType.length() - pointer - 1) == '*') {
                    ++pointer;
                }
                GenericType nt = Inspector.getTypeCreate(newType = newType.substring(0, newType.length() - pointer).trim());
                if (nt instanceof DataType && ((DataType)nt).desc == null) {
                    JOptionPane.showMessageDialog(this, "The specified type does not exist.", "No such type", 0);
                    return;
                }
                if (pointer == 0 && nt.getPointer() == 0) {
                    JOptionPane.showMessageDialog(this, "The specified type is not a pointer.", "Not a pointer", 0);
                    return;
                }
                el.e = el.e.castNewType(nt, pointer);
            }
        } else if (e.getActionCommand().equals("resetcast")) {
            el.e = el.original;
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            TreePath tp = InspectPanel.this.tree.getPathForLocation(e.getX(), e.getY());
            if (tp != null) {
                DefaultMutableTreeNode obj = (DefaultMutableTreeNode)tp.getLastPathComponent();
                if (!(obj.getUserObject() instanceof InspectedElement)) {
                    return;
                }
                InspectedElement el = (InspectedElement)obj.getUserObject();
                System.out.println(el);
                if (e.isPopupTrigger() && el.isPointer()) {
                    if (obj.isLeaf()) {
                        InspectPanel.this.menuItemFollow.setEnabled(true);
                    } else {
                        InspectPanel.this.menuItemFollow.setEnabled(false);
                    }
                    InspectPanel.this.tree.setSelectionPath(tp);
                    this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

