/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.fmt.PList;
import charm.debug.fmt.PString;
import charm.debug.inspect.InspectPanel;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.VariableElement;
import charm.debug.pdata.ChareTypeInfo;
import charm.debug.pdata.EpInfo;
import charm.debug.pdata.GenericInfo;
import charm.debug.pdata.MsgTypeInfo;
import java.nio.ByteBuffer;
import javax.swing.tree.DefaultMutableTreeNode;

public class MsgInfo
extends GenericInfo {
    int from;
    int prioBits;
    int userSize;
    MsgTypeInfo type;
    int envType;
    ChareTypeInfo chare;
    EpInfo ep;
    PList userData;
    int flags;
    int destID;
    long destPtr;
    ArrayElement idx;
    public static final int BREAKPOINT = 1;
    public static final int CONDITIONAL = 16;
    public static final int NewChareMsg = 1;
    public static final int NewVChareMsg = 2;
    public static final int BocInitMsg = 3;
    public static final int ForChareMsg = 4;
    public static final int ForBocMsg = 5;
    public static final int ForVidMsg = 6;
    public static final int FillVidMsg = 7;
    public static final int DeleteVidMsg = 8;
    public static final int RODataMsg = 9;
    public static final int ROMsgMsg = 10;
    public static final int ROPeerCompletionMsg = 11;
    public static final int ROChildCompletionMsg = 12;
    public static final int StartExitMsg = 13;
    public static final int ExitMsg = 14;
    public static final int ReqStatMsg = 15;
    public static final int StatMsg = 16;
    public static final int StatDoneMsg = 17;
    public static final int NodeBocInitMsg = 18;
    public static final int ForNodeBocMsg = 19;
    public static final int ArrayEltInitMsg = 20;
    public static final int ForArrayEltMsg = 21;
    public static final int ForIDedObjMsg = 22;
    public static final int BocBcastMsg = 23;
    public static final int ArrayBcastMsg = 24;
    public static final int ArrayBcastFwdMsg = 25;
    public static final int WarnMsg = 26;
    public static final int WarnDoneMsg = 27;
    public static final String[] envTypes = new String[]{"", "NewChareMsg", "NewVChareMsg", "BocInitMsg", "ForChareMsg", "ForBocMsg", "ForVidMsg", "FillVidMsg", "DeleteVidMsg", "RODataMsg", "ROMsgMsg", "ROPeerCompletionMsg", "ROChildCompletionMsg", "StartExitMsg", "ExitMsg", "ReqStatMsg", "StatMsg", "StatDoneMsg", "NodeBocInitMsg", "ForNodeBocMsg", "ArrayEltInitMsg", "ForArrayEltMsg", "ForIDedObjMsg", "BocBcastMsg", "ArrayBcastMsg", "ArrayBcastFwdMsg", "WarnMsg", "WarnDoneMsg"};

    MsgInfo(int f, int p, int s, MsgTypeInfo t, int mf, ChareTypeInfo c, EpInfo e, PList d, int fl) {
        this.from = f;
        this.prioBits = p;
        this.userSize = s;
        this.type = t;
        this.envType = mf;
        this.chare = c;
        this.ep = e;
        this.userData = d;
        this.flags = fl;
        this.destID = -1;
        this.destPtr = -1L;
        this.idx = null;
    }

    public void setArrayElement(int aID, int nI, int dim, int[] index) {
        this.destID = aID;
        this.idx = new ArrayElement(nI, dim, index);
    }

    public void setGroupID(int gID) {
        this.destID = gID;
    }

    public void setObjectPtr(long ptr) {
        this.destPtr = ptr;
    }

    public boolean isConditional() {
        return (this.flags & 0x10) != 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("<html><body");
        if ((this.flags & 0x10) != 0) {
            buf.append(" bgcolor=\"#b545ff\"");
        } else if ((this.flags & 1) != 0) {
            buf.append(" bgcolor=\"#FF3333\"");
        } else if (this.ep.checkBox.isSelected()) {
            buf.append(" bgcolor=\"#EEAA55\"");
        }
        buf.append(">");
        buf.append(this.chare.getType() + "::" + this.ep.toString());
        buf.append("</body>");
        buf.append("</html>");
        return buf.toString();
    }

    @Override
    public void getDetails(InspectPanel panel) {
        System.out.println(Inspector.getTypeCreate(this.chare.getType()));
        StringBuffer buf = new StringBuffer();
        if (this.userData.elementNamed("Bytes") != null) {
            panel.load(new VariableElement(this.type.type, "", 1, 0, 0), ByteBuffer.wrap(((PString)this.userData.elementNamed("Bytes")).getBytes()).order(Inspector.getByteOrder()), 0);
            DefaultMutableTreeNode envelope = new DefaultMutableTreeNode("envelope");
            envelope.add(new DefaultMutableTreeNode("Sender processor: " + this.from));
            envelope.add(new DefaultMutableTreeNode("Envelope type: " + envTypes[this.envType]));
            DefaultMutableTreeNode destination = new DefaultMutableTreeNode("Destination: " + this.chare.getType() + "::" + this.ep.toString());
            envelope.add(destination);
            if (this.idx != null) {
                buf.append("array id=" + this.destID + ", index=[");
                for (int i = 0; i < this.idx.dimension; ++i) {
                    buf.append(this.idx.index[i] + ",");
                }
                buf.setLength(buf.length() - 1);
                buf.append("]");
                destination.add(new DefaultMutableTreeNode(buf.toString()));
            } else if (this.destID != -1) {
                destination.add(new DefaultMutableTreeNode("group id=" + this.destID));
            } else if (this.destPtr != -1L) {
                destination.add(new DefaultMutableTreeNode("ptr=0x" + Long.toHexString(this.destPtr)));
            }
            envelope.add(new DefaultMutableTreeNode("Size: " + this.userSize));
            panel.addBeforeTree(envelope);
        } else {
            buf.append("<html><table><tr><td>Sender processor:</td><td>" + this.from + "</td></tr><tr><td>Envelope type:</td><td>" + envTypes[this.envType] + "</td></tr><tr><td>Destination:</td><td>" + this.chare.getType() + "::" + this.ep.toString());
            if (this.idx != null) {
                buf.append("</td></tr><tr><td></td><td>array id=" + this.destID + ", index=[");
                for (int i = 0; i < this.idx.dimension; ++i) {
                    buf.append(this.idx.index[i] + ",");
                }
                buf.setLength(buf.length() - 1);
                buf.append("]");
            } else if (this.destID != -1) {
                buf.append("</td></tr><tr><td></td><td>group id=" + this.destID);
            } else if (this.destPtr != -1L) {
                buf.append("</td></tr><tr><td></td><td>ptr=0x" + Long.toHexString(this.destPtr));
            }
            buf.append("</td></tr>");
            buf.append("<tr><td>Size:</td><td>" + this.userSize + "</td></tr><tr><td>User data:</td><td>" + this.userData.toString() + "</td></tr</table></html>");
            panel.load(buf.toString());
            System.out.println("Msg: " + this.type.toString() + "\n desc: " + this.type.getDescription());
        }
    }

    class ArrayElement {
        int nInts;
        int dimension;
        int[] index;

        ArrayElement(int nI, int dim, int[] idx) {
            this.nInts = nI;
            this.dimension = dim;
            this.index = idx;
        }
    }
}

