/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.ParDebug;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.pdata.ChareTypePList;
import charm.debug.pdata.EpInfo;
import charm.debug.pdata.EpPList;
import charm.debug.pdata.GenericPList;
import charm.debug.pdata.MsgInfo;
import charm.debug.pdata.MsgTypePList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MsgPList
extends GenericPList
implements ActionListener {
    EpPList epList;
    MsgTypePList msgList;
    ChareTypePList chareList;
    PopupListener popup;
    JList list;
    int numConditional;
    int hasBpMessage;

    public MsgInfo elementAt(int i) {
        if (i >= this.data.size()) {
            return null;
        }
        return (MsgInfo)this.data.elementAt(i);
    }

    public MsgPList() {
        this.createPopupMenu();
    }

    public MsgPList(MsgPList msg) {
        this.epList = msg.epList;
        this.msgList = msg.msgList;
        this.chareList = msg.chareList;
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        this.popup = new PopupListener(this);
    }

    @Override
    public boolean needRefresh() {
        return true;
    }

    public void setLookups(EpPList ep, MsgTypePList msg, ChareTypePList chare) {
        this.epList = ep;
        this.msgList = msg;
        this.chareList = chare;
    }

    @Override
    public void load(PList list) {
        this.data.clear();
        if (list == null) {
            System.out.println("list is null!");
        }
        this.numConditional = 0;
        this.hasBpMessage = 0;
        for (PAbstract cur = list.elementAt(0); cur != null; cur = cur.getNext()) {
            PList lcur = (PList)cur;
            PList msg = (PList)lcur.elementNamed("charmMsg");
            if (msg == null) continue;
            int from = ((PNative)msg.elementNamed("from")).getIntValue(0);
            int prioBits = ((PNative)msg.elementNamed("prioBits")).getIntValue(0);
            int userSize = ((PNative)msg.elementNamed("userSize")).getIntValue(0);
            int msgType = ((PNative)msg.elementNamed("msgType")).getIntValue(0);
            int envType = ((PNative)msg.elementNamed("envType")).getIntValue(0);
            int ep = ((PNative)msg.elementNamed("ep")).getIntValue(0);
            PList msgData = (PList)msg.elementNamed("data");
            EpInfo epEntry = this.epList.getEntryFor(ep);
            int flags = 0;
            if (((PString)lcur.elementNamed("name")).getString().equals("Breakpoint")) {
                flags |= 1;
                this.hasBpMessage = 1;
            }
            if (((PString)lcur.elementNamed("name")).getString().contains("Conditional")) {
                flags |= 0x10;
                ++this.numConditional;
            }
            MsgInfo info = new MsgInfo(from, prioBits, userSize, this.msgList.elementAt(msgType), envType, this.chareList.elementAt(epEntry.getChareType()), epEntry, msgData, flags);
            this.data.add(info);
            if (msg.elementNamed("arrID") != null && msg.elementNamed("nInts") != null && msg.elementNamed("dimension") != null) {
                System.out.println(msg);
                int arrayID = ((PNative)msg.elementNamed("arrID")).getIntValue(0);
                int nInts = ((PNative)msg.elementNamed("nInts")).getIntValue(0);
                int dimension = ((PNative)msg.elementNamed("dimension")).getIntValue(0);
                int[] index = null;
                if (dimension > 0 && dimension <= 6) {
                    index = new int[dimension];
                    for (int i = 0; i < dimension; ++i) {
                        index[i] = ((PNative)msg.elementNamed("index")).getIntValue(i);
                    }
                }
                info.setArrayElement(arrayID, nInts, dimension, index);
            }
            if (msg.elementNamed("groupID") != null) {
                info.setGroupID(((PNative)msg.elementNamed("groupID")).getIntValue(0));
            }
            if (msg.elementNamed("ptr") == null) continue;
            info.setObjectPtr(((PNative)msg.elementNamed("ptr")).getLongValue(0));
        }
    }

    @Override
    public void addPopupMenu(JList l) {
        this.list = l;
        if (!Arrays.asList(this.list.getMouseListeners()).contains(this.popup)) {
            this.list.addMouseListener(this.popup);
        }
    }

    @Override
    public void removePopupMenu(JList l) {
        this.list.removeMouseListener(this.popup);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.deliverActionPerformed(this.list.getSelectedIndex(), e.getActionCommand());
    }

    public void deliverActionPerformed(int index, String command) {
        int idx = index - this.numConditional;
        if (command.equals("deliver")) {
            String method = null;
            method = idx == 0 ? "debug/charm/next" : "debug/charm/deliver";
            ParDebug.debugger.server.sendCcsRequestBytes(method, "" + (idx - this.hasBpMessage), ParDebug.debugger.getSelectedPe());
            ParDebug.debugger.messageDelivered();
        } else if (command.equals("conditional")) {
            ParDebug.debugger.deliverConditional(idx - this.hasBpMessage);
        } else if (command.equals("end")) {
            ParDebug.debugger.endConditional(0);
        } else if (command.equals("undeliver")) {
            ParDebug.debugger.endConditional(index);
        } else if (command.equals("confirm")) {
            ParDebug.debugger.commitConditional(index, this.numConditional);
        }
    }

    public class PopupListener
    extends MouseAdapter {
        JPopupMenu popupNormal = new JPopupMenu();
        JPopupMenu popupConditional1;
        JPopupMenu popupConditional2;

        PopupListener(MsgPList parent) {
            JMenuItem delivernow = new JMenuItem("Deliver now");
            delivernow.setActionCommand("deliver");
            delivernow.addActionListener(parent);
            this.popupNormal.add(delivernow);
            JMenuItem conditional1 = new JMenuItem("Deliver provisional");
            conditional1.setActionCommand("conditional");
            conditional1.addActionListener(parent);
            this.popupNormal.add(conditional1);
            this.popupConditional1 = new JPopupMenu();
            JMenuItem end1 = new JMenuItem("End provisional");
            end1.setActionCommand("end");
            end1.addActionListener(parent);
            this.popupConditional1.add(end1);
            JMenuItem conditional2 = new JMenuItem("Deliver provisional");
            conditional2.setActionCommand("deliver");
            conditional2.addActionListener(parent);
            this.popupConditional1.add(conditional2);
            this.popupConditional2 = new JPopupMenu();
            JMenuItem undeliver = new JMenuItem("Undeliver");
            undeliver.setActionCommand("undeliver");
            undeliver.addActionListener(parent);
            this.popupConditional2.add(undeliver);
            JMenuItem end2 = new JMenuItem("End provisional");
            end2.setActionCommand("end");
            end2.addActionListener(parent);
            this.popupConditional2.add(end2);
            JMenuItem confirm = new JMenuItem("Permanently deliver");
            confirm.setActionCommand("confirm");
            confirm.addActionListener(parent);
            this.popupConditional2.add(confirm);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int idx = MsgPList.this.list.locationToIndex(e.getPoint());
            MsgPList.this.list.setSelectedIndex(idx);
            MsgInfo mi = (MsgInfo)MsgPList.this.list.getModel().getElementAt(idx);
            System.out.println("mousePressed");
            if (e.isPopupTrigger()) {
                if (ParDebug.debugger.getSelectedProcessor().isConditional()) {
                    if (mi.isConditional()) {
                        this.popupConditional2.show(e.getComponent(), e.getX(), e.getY());
                    } else {
                        this.popupConditional1.show(e.getComponent(), e.getX(), e.getY());
                    }
                } else {
                    this.popupNormal.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

