/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.inspect.GenericType;
import charm.debug.inspect.InspectPanel;
import charm.debug.inspect.VariableElement;
import charm.debug.pdata.GenericInfo;
import java.nio.ByteBuffer;

public class ReadonlyInfo
extends GenericInfo {
    String name;
    GenericType type;
    long size;
    ByteBuffer memory;

    ReadonlyInfo(String n, GenericType t, long s, ByteBuffer m) {
        this.name = n;
        this.type = t;
        this.size = s;
        this.memory = m;
    }

    public String toString() {
        return this.type.getName() + " " + this.name;
    }

    @Override
    public void getDetails(InspectPanel panel) {
        System.out.print("memory = " + this.memory + " ");
        for (int i = 0; i < this.memory.limit(); ++i) {
            System.out.print(" " + Integer.toHexString(this.memory.get(i)));
        }
        if (this.type != null) {
            VariableElement el = new VariableElement(this.type, this.name, 0, 0, 0);
            panel.load(el, this.memory, 0);
        } else {
            panel.load(this.type.getName() + " " + this.name + " = " + this.type.memoryToString(this.memory));
        }
    }
}

