/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.inspect.Inspector;
import charm.debug.pdata.GenericPList;
import charm.debug.pdata.ReadonlyInfo;
import java.nio.ByteBuffer;

public class ReadonlyPList
extends GenericPList {
    public ReadonlyInfo elementAt(int i) {
        if (i >= this.data.size()) {
            return null;
        }
        return (ReadonlyInfo)this.data.elementAt(i);
    }

    @Override
    public boolean needRefresh() {
        return true;
    }

    @Override
    public void load(PList list) {
        this.data.clear();
        if (list == null) {
            System.out.println("list is null!");
        }
        for (PAbstract cur = list.elementAt(0); cur != null; cur = cur.getNext()) {
            PList lcur = (PList)cur;
            String name = ((PString)lcur.elementNamed("name")).getString();
            String type = ((PString)lcur.elementNamed("type")).getString();
            long size = ((PNative)lcur.elementNamed("size")).getLongValue(0);
            byte[] memory = ((PString)lcur.elementNamed("value")).getBytes();
            this.data.add(new ReadonlyInfo(name, Inspector.getTypeCreate(type), size, ByteBuffer.wrap(memory).order(Inspector.getByteOrder())));
        }
    }
}

