/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.ParDebug;
import charm.debug.PeSet;
import charm.debug.PythonScript;
import charm.debug.event.NotifyEvent;
import charm.debug.event.NotifyListener;
import charm.debug.fmt.PConsumer;
import charm.debug.fmt.PList;
import charm.debug.pdata.EpInfo;
import charm.debug.pdata.EpPList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class Commands
implements NotifyListener,
Runnable {
    ParDebug debugger;
    Vector list;
    int position;
    Vector events;
    boolean waiting;

    public Commands(File f, ParDebug d) {
        this.debugger = d;
        this.list = null;
        this.position = 0;
        try {
            BufferedReader com = new BufferedReader(new FileReader(f));
            System.out.println("Loading commands: " + f.getAbsolutePath());
            this.list = new Vector();
            this.events = new Vector();
            String str = null;
            while ((str = com.readLine()) != null) {
                this.list.add(str);
            }
        }
        catch (IOException ioe) {
            System.out.println("Could not open command file ");
            ioe.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.apply();
    }

    public String getNext() {
        if (this.position == this.list.size()) {
            return null;
        }
        return (String)this.list.elementAt(this.position++);
    }

    public void pushBack() {
        --this.position;
    }

    public void apply() {
        String command;
        while ((command = this.getNext()) != null) {
            System.out.println("applying command: " + command);
            if (command.charAt(0) == '#') continue;
            if (command.startsWith("sleep")) {
                long now;
                long time = Integer.parseInt(command.substring(command.indexOf(32)).trim());
                long end = new Date().getTime() + time;
                while ((now = new Date().getTime()) < end) {
                    try {
                        Thread.sleep(end - now);
                    }
                    catch (InterruptedException e) {}
                }
                continue;
            }
            if (command.equals("start")) {
                this.debugger.startProgram(false);
                continue;
            }
            if (command.startsWith("attach")) {
                if (!command.equals("attach")) {
                    String parameters = command.substring(command.indexOf(32) + 1);
                    String hostname = parameters.substring(0, parameters.indexOf(32));
                    String port = parameters.substring(parameters.indexOf(32) + 1);
                    this.debugger.setCcsParameters(hostname, port);
                }
                this.debugger.startProgram(true);
                continue;
            }
            if (command.startsWith("python")) {
                int next;
                String code;
                command = command.substring(command.indexOf(32)).trim();
                File f = new File(command.substring(0, command.indexOf(32)));
                PythonScript script = new PythonScript(this.debugger.getGdb());
                try {
                    code = script.loadPythonCode(f);
                }
                catch (IOException e) {
                    System.out.println("could not load file " + f.getAbsolutePath());
                    break;
                }
                try {
                    script.parseCode(code);
                }
                catch (ParseException e) {
                    System.out.println("could not parse python code: " + code);
                }
                command = command.substring(command.indexOf(32)).trim();
                int boundChare = Integer.parseInt(command.substring(0, (command + " ").indexOf(32)));
                script.setChare(this.debugger.getGroupItems().elementAt(boundChare));
                while ((next = command.indexOf(32)) != -1) {
                    int ep = Integer.parseInt((command = command.substring(next).trim()).substring(0, (command + " ").indexOf(32)));
                    int where = ep > 0 ? 1 : 0;
                    ep = ep > 0 ? ep : -ep;
                    script.addEP(where, this.debugger.getEpItems().getEntryFor(ep));
                }
                this.debugger.executePython(script);
                continue;
            }
            if (command.startsWith("time")) {
                Date now = new Date();
                System.out.println(command.substring(5) + " " + now + " (" + now.getTime() + ")");
                continue;
            }
            if (command.startsWith("peset")) {
                PeSet pes = this.debugger.getSelectedPeSet();
                String bufTitle = new String("Details for set \"" + pes.getName() + "\"");
                String buf = pes.getDetail();
                System.out.println(bufTitle + ": {" + buf + " }");
                continue;
            }
            if (command.equals("quit")) {
                this.debugger.server.bcastCcsRequest("debug/converse/quit", "");
                this.debugger.quitProgram();
                continue;
            }
            if (command.equals("continue")) {
                this.debugger.command_continue();
                continue;
            }
            if (command.equals("step")) {
                this.debugger.deliverSingle();
                continue;
            }
            if (command.startsWith("memstat")) {
                String input = command.substring(command.indexOf(32)).trim();
                int pe = Integer.parseInt(input);
                if (pe == -1) {
                    pe = 0;
                }
                byte[] buf = ParDebug.debugger.server.sendCcsRequestBytes("debug/memory/stat", input, pe);
                PConsumer cons = new PConsumer();
                cons.decode(buf);
                PList stat = cons.getList();
                System.out.println(stat);
                continue;
            }
            if (command.equals("allocation")) continue;
            if (command.startsWith("breakpoint")) {
                String condition = command.substring(command.indexOf(32)).trim();
                String chareName = condition.substring(0, condition.indexOf(32));
                String epName = condition.substring(condition.indexOf(32)).trim();
                EpPList eps = ParDebug.debugger.getEpItems();
                Iterator it = eps.iterate();
                EpInfo info = null;
                boolean found = false;
                while (it.hasNext()) {
                    info = (EpInfo)it.next();
                    if (!info.equals(chareName, epName)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                System.out.println("Setting breakpoint: " + info.getChareName() + "::" + info.toString() + " (" + info.getEpIndex() + ")");
                this.debugger.command_breakpoint(info.getEpIndex());
                continue;
            }
            if (command.startsWith("wait")) {
                String condition = command.substring(command.indexOf(32)).trim();
                boolean matchSuccess = false;
                int type = 0;
                if (condition.equals("breakpoint")) {
                    type = 1;
                } else if (condition.equals("freeze")) {
                    type = 4;
                }
                for (int i = 0; i < this.events.size(); ++i) {
                    if (((NotifyEvent)this.events.get((int)i)).type != type) continue;
                    matchSuccess = true;
                    this.events.remove(i);
                    break;
                }
                if (matchSuccess) continue;
                this.pushBack();
                this.waiting = true;
                break;
            }
            if (command.startsWith("deliver") || command.startsWith("conditional") || command.startsWith("undeliver") || command.startsWith("confirm")) {
                int separator = command.indexOf(32);
                int index = 0;
                try {
                    index = Integer.parseInt(command.substring(separator + 1));
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Incorrect delivery index");
                }
                this.debugger.deliverMessage(index, command.substring(0, separator));
                continue;
            }
            if (command.startsWith("repeat")) {
                int match;
                int count = 1;
                int start = command.indexOf(32);
                int end = command.indexOf(32, start + 1);
                if (end == -1) {
                    end = command.length();
                }
                try {
                    count = Integer.parseInt(command.substring(start + 1, end));
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Could not understand how many times to repeat... defaulting to 1");
                }
                String terminator = command.substring(end).trim();
                if (terminator.length() > 0) {
                    for (match = this.position + 1; match < this.list.size() && !terminator.equals(this.list.elementAt(match)); ++match) {
                    }
                    if (match == this.list.size()) {
                        System.err.println("Commands: Could not find a match for repeat string \"" + terminator + "\"");
                        System.exit(1);
                    }
                    this.list.removeElementAt(match);
                }
                for (int i = 1; i < count; ++i) {
                    for (int j = match - 1; j >= this.position; --j) {
                        this.list.insertElementAt(this.list.elementAt(j), match);
                    }
                }
                continue;
            }
            System.out.println("Command not recognized: " + command);
        }
    }

    @Override
    public void receiveNotification(NotifyEvent e) {
        this.events.add(e);
        System.out.println("Received notification " + e);
        if (this.waiting) {
            this.waiting = false;
            this.apply();
        }
    }
}

