
          /*************** jacobi.h *************
	   *                                    *
	   *        for plate demo prject       *
	   *       Rui Liu,  February 1999      *
	   **************************************/

#include <charm++.h>
#include "jacobi.decl.h"

extern CkGroupID strategyID;

#ifndef NOWEB
extern void CWebPlateRegisterCell();
extern void CWebPlateUnregisterCell();
extern void CWebPlateDataDeposit(
	         int timestep,
		 int cellx,
		 int celly,
		 int rows,
		 int columns,
		 int **data);

extern int CWebPlateCheckRefine(int *);
extern void CWebPlateInit(int);
#endif

//#define CELL_DIM  16  /* - the number of cells in each dimension  */
#define CELL_DIM  2  /* - the number of cells in each dimension  */
#define DISPLAY_CELL_SIZE 16  /* - the number of rows (and columns) in each cell */
#define TIMESTEP_JUMP 100
             /* - the number of timesteps you will skip (for preventing
	     excessive bandwidth requirement). ie, you will call the Function
	     CWebPlateDataDeposit() at timesteps 0, TIMESTEP_JUMP, 
	     2 * TIMESTEP_JUMP, ...  */

#define LDB_TIMESTEP 40
#define REFINE_AT 120
#define RUN_UNTIL 280
#define PRINT_TIME 5

enum {lbstrategy = 2};
//#define AVOID_PE_ZERO
//#define DO_INITIAL_BALANCE

#define N_BALANCING_STEPS 2

#define TEMP_SOURCE  100
#define TEMP_INITIAL 0
#define TEMP_RANGE   100
#define COLOR_RANGE  256

class initializer : public Group {
public:
#ifdef NOWEB
  initializer(void) { };
#else 
  initializer(void) { CWebPlateInit(2); };
#endif
  initializer(CkMigrateMessage *m) {}
};

