#include "pgm.h"

CkChareID mainhandle;

void 
UserArray::doAllreduce(void)
{
  int i;
  double in=thisIndex, out;
  for(i=0;i<NITER;i++) {
    ckTempoAllReduce(TEMPO_SUM, &in, &out, 1, TEMPO_DOUBLE);
  }
  CProxy_main pm(mainhandle);
  pm.Finish();
}

main::main(CkArgMsg *m)
{
  int i;
  int nblocks = CmiNumPes();
  CkArrayID aid = CProxy_UserArray::ckNew(nblocks);
  CProxy_UserArray  pua(aid);
  pua.doAllreduce(); // broadcast to all array elements
  mainhandle = thishandle;
  starttime = CkTimer();
}

void 
main::Finish(void)
{
  endtime = CkTimer();
  CkPrintf("Time per Allreduce = %lf microseconds\n", 
           (endtime-starttime)*1.e6/NITER);
  CkExit();
}

#include "pgm.def.h"
