recursive subroutine AMPI_Main
  use ampi
  implicit none

  integer :: thisIndex, ierr, nblocks, i
  double precision, allocatable, dimension(:) :: inbuf, outbuf

  call AMPI_Init(ierr)
  call AMPI_Comm_rank(AMPI_COMM_WORLD, thisIndex, ierr)
  call AMPI_Comm_size(AMPI_COMM_WORLD, nblocks, ierr)

  allocate(inbuf(0:nblocks-1))
  allocate(outbuf(0:nblocks-1))

  do i = 0, nblocks-1
    inbuf(i) = i
    outbuf(i) = -1
  enddo

  call AMPI_Alltoall(inbuf, 1, AMPI_DOUBLE_PRECISION, outbuf, 1, &
&                    AMPI_DOUBLE_PRECISION, AMPI_COMM_WORLD, ierr)

  ierr = 0
  do i = 0, nblocks-1
    if (outbuf(i) .ne. thisIndex) then
      call AMPI_Print('Message corrupted')
      ierr = 1
    end if
  enddo
  if (ierr .eq. 0) then
    call AMPI_Print('alltoall test passed')
  end if
  call AMPI_Finalize(ierr)

end subroutine
