#include "BlueGene.h"
#define  computeID  1

extern "C" void compute(ThreadInfo *) ;

class MyMsg : public PacketMsg
{
public:
  int dummy ;
} ;

void BgInit(Main *main)
{}

void* BgNodeInit(BgNode *bgNode)
{
     // ckout << "entered BgNodeInit " << bgNode->thisIndex.x <<" "
     // << bgNode->thisIndex.y <<" "<< bgNode->thisIndex.z << endl ;

  bgNode->registerHandler(computeID, compute) ;

  if(bgNode->thisIndex.x==0 && 
     bgNode->thisIndex.y==0 && 
     bgNode->thisIndex.z==0) 
  {
    MyMsg *msg = new MyMsg ;
    msg->dummy = 0 ;
    bgNode->addMessage(msg, computeID, LARGE_WORK) ; 
  }
  return NULL;
}

void BgFinish() {}

void compute(ThreadInfo *info) 
{
  int i, j, k ;
  int iter;
  MyMsg *m = (MyMsg *) (info->msg);
  BgNode *bn = info->bgNode;

  bn->getXYZ(i,j,k) ; 

  iter = m->dummy;
  if(iter==200000 && i==0 && j==0 && k==0)
  {
/*
    ckout << "finished " << iter/2 << " rings." << endl;
    ckout << "BgNode No: " << i <<", "<< j <<", "<< k 
          << " Emulation Time " << info->getTime()*1.e-6 
          << " seconds" << endl ;
*/
    bn->finish() ;  
    return ;
  }

  k = k + 1 ;
  if( k==bn->numBgZ )
  {
    k = 0 ;
    j = j+1 ;
    if ( j==bn->numBgY )
    {
      j = 0 ;
      i = i+1 ;
      if ( i==bn->numBgX )
      {
        i = 0 ;
      }
    }
  }
  m->dummy = iter+1 ;
  info->sendPacket(i, j, k, m, computeID, LARGE_WORK) ;
}
