#include "ccs.h"
#include <stdio.h>

static void  usage(void)
{
  fprintf(stderr, "Usage: client svrIP svrPort bocHostName\n");
  exit(1);
}

main(int argc, char **argv)
{
  CcsServer svr;
  int i;
  char reply[1024];
  if(argc < 4) {
    usage();
  }
  CcsConnect(&svr, argv[1], atoi(argv[2]));
  printf("Connection established with host\n");
  i = CcsNodeNum(&svr, argv[3]);
  if (i==-1) {
    CcsFinalize(&svr);
    printf("No branch on this machine.\n");
    exit(1);
  }
  CcsSendRequest(&svr, "migrate", CcsNodeFirst(&svr,i), 
		 strlen("migrate")+1, "migrate");
  printf("Request Sent.\nShutting down client.\n");
  CcsFinalize(&svr);
  exit(0);
}
