#include "jacobi.h"

void
jacobi::run(void)
{
  // initialize
  int i, j;
  for(i=1;i<=WIDTH;i++)
    for(j=0;j<HEIGHT;j++)
      data[i][j] = HEIGHT*i+j;
  // actual iterations
  int iter;
  int left = (thisIndex-1+NBLOCKS)%NBLOCKS;
  int right = (thisIndex+1)%NBLOCKS;
  for(iter=0; iter<3; iter++) {
    int tag = iter*NBLOCKS+thisIndex;
    int tagLeft = iter*NBLOCKS+left;
    int tagRight = iter*NBLOCKS+right;
    // send left
    ckTempoSendElem(tag, &data[1][0], HEIGHT*sizeof(double), left);
    // recv from right
    ckTempoRecv(tagRight, &data[WIDTH+1][0], HEIGHT*sizeof(double));
    // send right
    ckTempoSendElem(tag, &data[WIDTH][0], HEIGHT*sizeof(double), right);
    // recv from left
    ckTempoRecv(tagLeft, &data[0][0], HEIGHT*sizeof(double));
    // now do computation
    for(i=1; i<=WIDTH; i++)
      for(j=1; j<(HEIGHT-1); j++)
        data[i][j] = 0.2 * (data[i][j] + data[i-1][j] + data[i+1][j]
                           + data[i][j-1] + data[i][j+1]);
    ckout << "Done iteration " << iter << " for element " << thisIndex << endl;
  }
  itersDone();
}

#include "jacobi.def.h"
