#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <semaphore.h>
#include <netdb.h>
#include <signal.h>
#include <strings.h>

#define MAX_CONN 20
#define MAX_SIZE 1024 

#define MCHARM  0        // migratable charm jobs, started on all processors.
#define MPI     1        // MPI jobs.
#define NCHARM  2        // Non migratable charm jobs, default.
#define UNI     3        // Uni processor jobs.

#define QUEUED    0
#define RUNNING   1
#define CONNECTED 2
#define SUSPENDED 3
#define FINISHED  4
//#define BITMAPSET 5

extern "C"{
#include "ccs.h"
}

#define MAX_STRING_SIZE 256

struct job_net_stats{
    unsigned int port,ip,pid;
};

class Job{
 public:  

    unsigned int port,ip,pid;
    int client_soc_fd;

    int type, priority;
    int min_proc;
    int max_proc;
    int num_system_proc;
    int num_allocated_proc;

    CcsServer svr;
    
    char ** argv;
    char argbuf[1024];
    char bit_map[256];

    char *working_directory;
    char *Stdin, *Stdout, *Stderr;
    int dbid;
    char name[MAX_STRING_SIZE];

    int status;
    int bitmap_changed;
    Job *next;
    
    Job(int nproc);
    ~Job();
 
    void parse_query(char *query);
    void init_arg();

    int connect();
    int ping();
    void Kill();
    int set_bitmap();    
    
    void add_proc(int p);
    int delete_proc();
    int delete_all(char *bit_map);

    void started();
};

class SchedulingStrategy{
 public:
    virtual int is_available(Job *j, Job *waitq, Job *runq) = 0;
    virtual void allocate_processors(Job *waitq, Job *runq) = 0;
    
    char *free_proc_vector;
    int num_free_proc;
    int nproc;
};

#endif
