#include <pthread.h>

struct Node{
    char name[256];
    Node *next;
};

#include "common.h"

class Scheduler{
 public:

    Scheduler(int port, int nproc);
    void start_scheduler();
    
    void Connect(Job *j);

    // Functions called by the handlers.
    void wait_for_request();
    void execute_job();
    void load_nodelist(char *node_listfile);
    void remove_job();
    int  start_job(Job *j);
    void dump_stats(FILE *fp);
    void activelist_manager();

 private:

    int port;
    int host_ip;
    int sch_socfd;

    char nodesfile[256]; // scheduler nodelist file name.
    
    Job *runq;

    // To be initialized from the database.
    int max_port;
    char *free_proc_vector;
    int num_free_proc;

    pthread_mutex_t * proc_mutex;

    SchedulingStrategy *strategy;
    int nproc;
    Node *activelist, *freelist;
    
    char *create_nodes_file(Job *j);
    void handle_request(int fd);

    int is_alive(char *);
    int job_running(int pos);
    Node *get_live_node();
    void update_nodesfile();
    void list_jobs(FILE *fp);
};





