/*
 * Decompiled with CFR 0.152.
 */
package projections.SamplePlots;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;
import projections.SamplePlots.MyActionHandler;
import projections.gui.graph.DataSource1D;
import projections.gui.graph.Graph;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxisFixed;

public class SamplePlottingMain {
    public static void main(String[] args) {
        System.out.println("Displaying two Sample graphs");
        SamplePlottingMain.createPlotInFrameJFreeChart();
        SamplePlottingMain.createPlotInFrameGraph();
    }

    public static void createPlotInFrameJFreeChart() {
        XYSeries s = new XYSeries((Comparable)((Object)"All Event Types"), true, false);
        for (int i = 0; i < 20; ++i) {
            s.add((double)i, Math.random());
        }
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        dataset.addSeries(s);
        NumberAxis domainAxis = new NumberAxis("My X Axis Label");
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis rangeAxis = new NumberAxis("My Y Axis Label");
        StackedXYBarRenderer renderer = new StackedXYBarRenderer();
        renderer.setDrawBarOutline(true);
        XYPlot plot = new XYPlot(dataset, domainAxis, rangeAxis, renderer);
        JFreeChart chart = new JFreeChart("Plot Name", plot);
        ChartPanel chartpanel = new ChartPanel(chart);
        JFrame window = new JFrame("Plot Window jfreechart");
        window.setLayout(new BorderLayout());
        window.add((Component)chartpanel, "Center");
        JButton mybutton = new JButton("Click Me");
        window.add((Component)mybutton, "South");
        MyActionHandler h = new MyActionHandler(plot);
        mybutton.addActionListener(h);
        window.pack();
        window.setVisible(true);
    }

    public static void createPlotInFrameGraph() {
        XAxisFixed x = new XAxisFixed("My X Axis Label", "u");
        YAxisFixed y = new YAxisFixed("My Y Axis Label", "u", 0.0);
        int[] data = new int[20];
        for (int i = 0; i < 20; ++i) {
            data[i] = (int)(Math.random() * 10.0);
        }
        DataSource1D d = new DataSource1D("Plot Name", data);
        Graph g = new Graph();
        g.setData(d, x, y);
        JFrame window = new JFrame("Plot Window projection.gui.graph");
        window.setLayout(new BorderLayout());
        window.add((Component)g, "Center");
        window.pack();
        window.setVisible(true);
    }
}

