/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.CommunicationOverTime;

import java.io.IOException;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

class ThreadedFileReader
implements Runnable {
    private int pe;
    private long startInterval;
    private long endInterval;
    private long intervalSize;
    private int myRun = 0;
    private double[][] globalMessagesSend;
    private double[][] globalMessagesRecv;
    private double[][] globalBytesSend;
    private double[][] globalBytesRecv;
    private double[][] globalExternalMessageRecv;
    private double[][] globalExternalBytesRecv;

    protected ThreadedFileReader(int pe, long intervalSize, long startInterval, long endInterval, double[][] globalMessagesSend, double[][] globalMessagesRecv, double[][] globalBytesSend, double[][] globalBytesRecv, double[][] globalExternalMessageRecv, double[][] globalExternalBytesRecv) {
        this.pe = pe;
        this.startInterval = startInterval;
        this.endInterval = endInterval;
        this.intervalSize = intervalSize;
        this.globalMessagesSend = globalMessagesSend;
        this.globalMessagesRecv = globalMessagesRecv;
        this.globalBytesSend = globalBytesSend;
        this.globalBytesRecv = globalBytesRecv;
        this.globalExternalMessageRecv = globalExternalMessageRecv;
        this.globalExternalBytesRecv = globalExternalBytesRecv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        GenericLogReader reader = new GenericLogReader(this.pe, MainWindow.runObject[this.myRun].getVersion());
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        int numIntervals = (int)(this.endInterval - this.startInterval + 1L);
        double[][] localMessagesSend = new double[numIntervals][numEPs];
        double[][] localMessagesRecv = new double[numIntervals][numEPs];
        double[][] localBytesSend = new double[numIntervals][numEPs];
        double[][] localBytesRecv = new double[numIntervals][numEPs];
        double[][] localExternalMessageRecv = new double[numIntervals][numEPs];
        double[][] localExternalBytesRecv = new double[numIntervals][numEPs];
        try {
            while (true) {
                int timeInterval;
                int destEP;
                LogEntryData logdata = reader.nextEvent();
                if (logdata.type == 1) {
                    destEP = logdata.entry;
                    timeInterval = this.getInterval(logdata.time);
                    if (timeInterval < 0 || timeInterval >= numIntervals) continue;
                    double[] dArray = localMessagesSend[timeInterval];
                    int n = destEP;
                    dArray[n] = dArray[n] + 1.0;
                    double[] dArray2 = localBytesSend[timeInterval];
                    int n2 = destEP;
                    dArray2[n2] = dArray2[n2] + (double)logdata.msglen;
                    continue;
                }
                if (logdata.type == 20 || logdata.type == 21) {
                    destEP = logdata.entry;
                    timeInterval = this.getInterval(logdata.time);
                    if (timeInterval < 0 || timeInterval >= numIntervals) continue;
                    double[] dArray = localMessagesSend[timeInterval];
                    int n = destEP;
                    dArray[n] = dArray[n] + (double)logdata.numPEs;
                    double[] dArray3 = localBytesSend[timeInterval];
                    int n3 = destEP;
                    dArray3[n3] = dArray3[n3] + (double)(logdata.msglen * logdata.numPEs);
                    continue;
                }
                if (logdata.type != 2) continue;
                int currEPindex = MainWindow.runObject[this.myRun].getEntryIndex(logdata.entry);
                int srcPe = logdata.pe;
                int timeInterval2 = this.getInterval(logdata.time);
                if (timeInterval2 < 0 || timeInterval2 >= numIntervals) continue;
                double[] dArray = localMessagesRecv[timeInterval2];
                int n = currEPindex;
                dArray[n] = dArray[n] + 1.0;
                double[] dArray4 = localBytesRecv[timeInterval2];
                int n4 = currEPindex;
                dArray4[n4] = dArray4[n4] + (double)logdata.msglen;
                if (this.pe == srcPe) continue;
                double[] dArray5 = localExternalMessageRecv[timeInterval2];
                int n5 = currEPindex;
                dArray5[n5] = dArray5[n5] + 1.0;
                double[] dArray6 = localExternalBytesRecv[timeInterval2];
                int n6 = currEPindex;
                dArray6[n6] = dArray6[n6] + (double)logdata.msglen;
            }
        }
        catch (EndOfLogSuccess e) {
        }
        catch (IOException e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + this.pe);
        }
        double[][] dArray = this.globalMessagesSend;
        synchronized (this.globalMessagesSend) {
            int j;
            int i;
            for (i = 0; i < numIntervals; ++i) {
                for (j = 0; j < numEPs; ++j) {
                    double[] dArray7 = this.globalMessagesSend[i];
                    int n = j;
                    dArray7[n] = dArray7[n] + localMessagesSend[i][j];
                }
            }
            // ** MonitorExit[var10_13] (shouldn't be in output)
            dArray = this.globalMessagesRecv;
            synchronized (this.globalMessagesRecv) {
                for (i = 0; i < numIntervals; ++i) {
                    for (j = 0; j < numEPs; ++j) {
                        double[] dArray8 = this.globalMessagesRecv[i];
                        int n = j;
                        dArray8[n] = dArray8[n] + localMessagesRecv[i][j];
                    }
                }
                // ** MonitorExit[var10_13] (shouldn't be in output)
                dArray = this.globalBytesSend;
                synchronized (this.globalBytesSend) {
                    for (i = 0; i < numIntervals; ++i) {
                        for (j = 0; j < numEPs; ++j) {
                            double[] dArray9 = this.globalBytesSend[i];
                            int n = j;
                            dArray9[n] = dArray9[n] + localBytesSend[i][j];
                        }
                    }
                    // ** MonitorExit[var10_13] (shouldn't be in output)
                    dArray = this.globalBytesRecv;
                    synchronized (this.globalBytesRecv) {
                        for (i = 0; i < numIntervals; ++i) {
                            for (j = 0; j < numEPs; ++j) {
                                double[] dArray10 = this.globalBytesRecv[i];
                                int n = j;
                                dArray10[n] = dArray10[n] + localBytesRecv[i][j];
                            }
                        }
                        // ** MonitorExit[var10_13] (shouldn't be in output)
                        dArray = this.globalExternalMessageRecv;
                        synchronized (this.globalExternalMessageRecv) {
                            for (i = 0; i < numIntervals; ++i) {
                                for (j = 0; j < numEPs; ++j) {
                                    double[] dArray11 = this.globalExternalMessageRecv[i];
                                    int n = j;
                                    dArray11[n] = dArray11[n] + localExternalMessageRecv[i][j];
                                }
                            }
                            // ** MonitorExit[var10_13] (shouldn't be in output)
                            dArray = this.globalExternalBytesRecv;
                            synchronized (this.globalExternalBytesRecv) {
                                for (i = 0; i < numIntervals; ++i) {
                                    for (j = 0; j < numEPs; ++j) {
                                        double[] dArray12 = this.globalExternalBytesRecv[i];
                                        int n = j;
                                        dArray12[n] = dArray12[n] + localExternalBytesRecv[i][j];
                                    }
                                }
                                // ** MonitorExit[var10_13] (shouldn't be in output)
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    private int getInterval(long currTime) {
        long ginterval = currTime / this.intervalSize;
        return (int)(ginterval - this.startInterval);
    }
}

