/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.CommunicationPerPE;

import java.io.IOException;
import java.util.ArrayList;
import projections.Tools.CommunicationPerPE.CommWindow;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

class ThreadedFileReader
implements Runnable {
    private int pe;
    private int pIdx;
    private long startTime;
    private long endTime;
    private int myRun = 0;
    private double[][] sentMsgCount;
    private double[][] sentByteCount;
    private double[][] receivedMsgCount;
    private double[][] receivedByteCount;
    private double[][] exclusiveRecv;
    private double[][] exclusiveBytesRecv;
    private int[][] hopCount;
    public ArrayList<Integer> localHistogram = new ArrayList();

    protected ThreadedFileReader(int pe, int pIdx, long startTime, long endTime, double[][] sentMsgCount, double[][] sentByteCount, double[][] receivedMsgCount, double[][] receivedByteCount, double[][] exclusiveRecv, double[][] exclusiveBytesRecv, int[][] hopCount) {
        this.pe = pe;
        this.pIdx = pIdx;
        this.startTime = startTime;
        this.endTime = endTime;
        this.sentMsgCount = sentMsgCount;
        this.sentByteCount = sentByteCount;
        this.receivedMsgCount = receivedMsgCount;
        this.receivedByteCount = receivedByteCount;
        this.exclusiveRecv = exclusiveRecv;
        this.exclusiveBytesRecv = exclusiveBytesRecv;
        this.hopCount = hopCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        GenericLogReader reader = new GenericLogReader(this.pe, MainWindow.runObject[this.myRun].getVersion());
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        try {
            double[][] dArray = this.sentMsgCount;
            synchronized (this.sentMsgCount) {
                this.sentMsgCount[this.pIdx] = new double[numEPs];
                this.sentByteCount[this.pIdx] = new double[numEPs];
                this.receivedMsgCount[this.pIdx] = new double[numEPs];
                this.receivedByteCount[this.pIdx] = new double[numEPs];
                this.exclusiveRecv[this.pIdx] = new double[numEPs];
                this.exclusiveBytesRecv[this.pIdx] = new double[numEPs];
                if (MainWindow.BLUEGENE) {
                    this.hopCount[this.pIdx] = new int[numEPs];
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                LogEntryData logdata = reader.nextEventOnOrAfter(this.startTime);
                while (logdata.time <= this.endTime || logdata.type != 1 && logdata.type != 2) {
                    int EPid;
                    logdata = reader.nextEvent();
                    if (logdata.type == 1) {
                        EPid = MainWindow.runObject[this.myRun].getEntryIndex(logdata.entry);
                        double[] dArray2 = this.sentMsgCount[this.pIdx];
                        int n = EPid;
                        dArray2[n] = dArray2[n] + 1.0;
                        double[] dArray3 = this.sentByteCount[this.pIdx];
                        int n2 = EPid;
                        dArray3[n2] = dArray3[n2] + (double)logdata.msglen;
                        this.localHistogram.add(new Integer(logdata.msglen));
                        continue;
                    }
                    if (logdata.type == 20 || logdata.type == 21) {
                        EPid = MainWindow.runObject[this.myRun].getEntryIndex(logdata.entry);
                        double[] dArray4 = this.sentMsgCount[this.pIdx];
                        int n = EPid;
                        dArray4[n] = dArray4[n] + (double)logdata.numPEs;
                        double[] dArray5 = this.sentByteCount[this.pIdx];
                        int n3 = EPid;
                        dArray5[n3] = dArray5[n3] + (double)(logdata.msglen * logdata.numPEs);
                        continue;
                    }
                    if (logdata.type != 2) continue;
                    EPid = MainWindow.runObject[this.myRun].getEntryIndex(logdata.entry);
                    double[] dArray6 = this.receivedMsgCount[this.pIdx];
                    int n = EPid;
                    dArray6[n] = dArray6[n] + 1.0;
                    double[] dArray7 = this.receivedByteCount[this.pIdx];
                    int n4 = EPid;
                    dArray7[n4] = dArray7[n4] + (double)logdata.msglen;
                    if (logdata.pe == this.pe) continue;
                    double[] dArray8 = this.exclusiveRecv[this.pIdx];
                    int n5 = EPid;
                    dArray8[n5] = dArray8[n5] + 1.0;
                    double[] dArray9 = this.exclusiveBytesRecv[this.pIdx];
                    int n6 = EPid;
                    dArray9[n6] = dArray9[n6] + (double)logdata.msglen;
                    if (!MainWindow.BLUEGENE) continue;
                    int[] nArray = this.hopCount[this.pIdx];
                    int n7 = EPid;
                    nArray[n7] = nArray[n7] + CommWindow.manhattanDistance(this.pe, logdata.pe);
                }
            }
        }
        catch (EndOfLogSuccess e) {
        }
        catch (IOException e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
        }
        {
            try {
                reader.close();
            }
            catch (IOException e1) {
                System.err.println("Error: could not close log file reader for processor " + this.pe);
            }
            return;
        }
    }
}

