/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Extrema;

import java.io.IOException;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

class ThreadedFileReader
implements Runnable {
    private static int myRun = 0;
    private int pe;
    private long startTime;
    private long endTime;
    private int numActivities;
    private int numActivityPlusSpecial;
    private int selectedActivity;
    private int selectedAttribute;
    double[] myData;

    protected ThreadedFileReader(int pe, long startTime2, long endTime2, int numActivities, int numActivityPlusSpecial, int selectedActivity, int selectedAttribute) {
        this.pe = pe;
        this.startTime = startTime2;
        this.endTime = endTime2;
        this.numActivities = numActivities;
        this.numActivityPlusSpecial = numActivityPlusSpecial;
        this.selectedActivity = selectedActivity;
        this.selectedAttribute = selectedAttribute;
    }

    public void run() {
        int e;
        GenericLogReader reader;
        block23: {
            this.myData = new double[this.numActivityPlusSpecial];
            reader = new GenericLogReader(this.pe, MainWindow.runObject[myRun].getVersion());
            try {
                if (this.selectedActivity == 1) {
                    LogEntryData logData = reader.nextEventOfType(100);
                    LogEntryData logDataEnd = reader.nextEventOfType(100);
                    while (logData.time < this.startTime) {
                        logData = reader.nextEventOfType(100);
                        logDataEnd = reader.nextEventOfType(100);
                    }
                    int eventIndex = 0;
                    do {
                        int n = eventIndex = MainWindow.runObject[myRun].getUserDefinedEventIndex(logData.userEventID);
                        this.myData[n] = this.myData[n] + (double)(logDataEnd.time - logData.time);
                        logData = reader.nextEventOfType(100);
                        logDataEnd = reader.nextEventOfType(100);
                    } while (logDataEnd.time <= this.endTime);
                    break block23;
                }
                int nestingLevel = 0;
                LogEntryData prevBeginProc = null;
                LogEntryData prevBeginIdle = null;
                while (true) {
                    LogEntryData logData = reader.nextEvent();
                    switch (logData.type) {
                        case 1: {
                            int eventIndex = logData.entry;
                            if (this.selectedAttribute == 2) {
                                int n = eventIndex;
                                this.myData[n] = this.myData[n] + 1.0;
                                break;
                            }
                            if (this.selectedAttribute != 3) break;
                            int n = eventIndex;
                            this.myData[n] = this.myData[n] + (double)logData.msglen;
                            break;
                        }
                        case 2: {
                            if (++nestingLevel != 1) break;
                            prevBeginProc = logData;
                            break;
                        }
                        case 3: {
                            if (--nestingLevel == 0) {
                                if (this.selectedAttribute == 0 || this.selectedAttribute == 1 || this.selectedAttribute == 4 || this.selectedAttribute == 5 || this.selectedAttribute == 6 || this.selectedAttribute == 7) {
                                    int n = logData.entry;
                                    this.myData[n] = this.myData[n] + (double)(logData.time - prevBeginProc.time);
                                }
                                prevBeginProc = null;
                                break;
                            }
                            if (nestingLevel >= 0) break;
                            nestingLevel = 0;
                            prevBeginProc = null;
                            break;
                        }
                        case 14: {
                            prevBeginIdle = logData;
                            break;
                        }
                        case 15: {
                            if (this.selectedAttribute == 0 || this.selectedAttribute == 1 || this.selectedAttribute == 4 || this.selectedAttribute == 5 || this.selectedAttribute == 6 || this.selectedAttribute == 7) {
                                int n = this.numActivities;
                                this.myData[n] = this.myData[n] + (double)(logData.time - prevBeginIdle.time);
                            }
                            prevBeginIdle = null;
                        }
                    }
                }
            }
            catch (EndOfLogSuccess e2) {
            }
            catch (IOException e3) {
                System.err.println("Outlier Analysis: Error in reading log data for processor " + this.pe);
                System.err.println(e3);
            }
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + this.pe);
        }
        this.myData[this.numActivities + 1] = this.endTime - this.startTime;
        for (e = 0; e < this.numActivities + 1; ++e) {
            int n = this.numActivities + 1;
            this.myData[n] = this.myData[n] - this.myData[e];
        }
        if (this.selectedAttribute == 1 || this.selectedAttribute == 4) {
            for (e = 0; e < this.myData.length; ++e) {
                this.myData[e] = this.myData[e] * 100.0 / (double)(this.endTime - this.startTime);
            }
        }
    }
}

