/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Histogram;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import projections.Tools.Histogram.BinDialogPanel;
import projections.Tools.Histogram.ThreadedFileReader;
import projections.analysis.TimedProgressThreadExecutor;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;
import projections.gui.U;
import projections.gui.Util;

public class HistogramWindow
extends GenericGraphWindow
implements ActionListener {
    private int myRun = 0;
    protected static final int NUM_TYPES = 2;
    protected static final int TYPE_TIME = 0;
    protected static final int TYPE_MSG_SIZE = 1;
    private JButton entrySelectionButton;
    private JButton epTableButton;
    private JRadioButton timeBinButton;
    private JRadioButton msgSizeBinButton;
    private ButtonGroup binTypeGroup;
    private BinDialogPanel binpanel;
    private double[][][] counts;
    private int binType = 0;
    private int timeNumBins;
    private long timeBinSize;
    private long timeMinBinSize;
    private int msgNumBins;
    private long msgBinSize;
    private long msgMinBinSize;
    private HistogramWindow thisWindow = this;
    private DecimalFormat _format = new DecimalFormat();

    public HistogramWindow(MainWindow mainWindow) {
        super("Projections Histograms", mainWindow);
        this.setTitle("Projections Histograms - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.createMenus();
        this.getContentPane().add(this.getMainPanel());
        this.pack();
        this.showDialog();
    }

    public void close() {
        super.close();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.binpanel = new BinDialogPanel();
            this.dialog = new RangeDialog(this, "Select Histogram Time Range", this.binpanel, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    HistogramWindow.this.timeNumBins = HistogramWindow.this.binpanel.getTimeNumBins();
                    HistogramWindow.this.timeBinSize = HistogramWindow.this.binpanel.getTimeBinSize();
                    HistogramWindow.this.timeMinBinSize = HistogramWindow.this.binpanel.getTimeMinBinSize();
                    HistogramWindow.this.msgNumBins = HistogramWindow.this.binpanel.getMsgNumBins();
                    HistogramWindow.this.msgBinSize = HistogramWindow.this.binpanel.getMsgBinSize();
                    HistogramWindow.this.msgMinBinSize = HistogramWindow.this.binpanel.getMsgMinBinSize();
                    HistogramWindow.this.binType = HistogramWindow.this.binpanel.getSelectedType();
                    HistogramWindow.access$802(HistogramWindow.this, new double[2][][]);
                    int numEPs = MainWindow.runObject[HistogramWindow.this.myRun].getNumUserEntries();
                    ((HistogramWindow)HistogramWindow.this).counts[0] = new double[HistogramWindow.this.timeNumBins + 1][numEPs];
                    ((HistogramWindow)HistogramWindow.this).counts[1] = new double[HistogramWindow.this.msgNumBins + 1][numEPs];
                    LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
                    OrderedIntList processorList = HistogramWindow.this.dialog.getSelectedProcessors();
                    while (processorList.hasMoreElements()) {
                        int nextPe = processorList.nextElement();
                        readyReaders.add(new ThreadedFileReader(HistogramWindow.this.counts, nextPe, HistogramWindow.this.dialog.getStartTime(), HistogramWindow.this.dialog.getEndTime(), HistogramWindow.this.timeNumBins, HistogramWindow.this.timeBinSize, HistogramWindow.this.timeMinBinSize, HistogramWindow.this.msgNumBins, HistogramWindow.this.msgBinSize, HistogramWindow.this.msgMinBinSize));
                    }
                    Component guiRootForProgressBar = null;
                    if (HistogramWindow.this.thisWindow != null && HistogramWindow.this.thisWindow.isVisible()) {
                        guiRootForProgressBar = HistogramWindow.this.thisWindow;
                    } else if (MainWindow.runObject[((HistogramWindow)HistogramWindow.this).myRun].guiRoot != null && MainWindow.runObject[((HistogramWindow)HistogramWindow.this).myRun].guiRoot.isVisible()) {
                        guiRootForProgressBar = MainWindow.runObject[((HistogramWindow)HistogramWindow.this).myRun].guiRoot;
                    }
                    TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Histograms in Parallel", readyReaders, guiRootForProgressBar, true);
                    threadManager.runAll();
                    return null;
                }

                protected void done() {
                    if (HistogramWindow.this.binType == 1) {
                        HistogramWindow.this.msgSizeBinButton.setSelected(true);
                    } else {
                        HistogramWindow.this.timeBinButton.setSelected(true);
                    }
                    HistogramWindow.this.setGraphSpecificData();
                    HistogramWindow.this.refreshGraph();
                    HistogramWindow.this.thisWindow.setVisible(true);
                }
            };
            worker.execute();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem m = (JMenuItem)e.getSource();
            if (m.getText().equals("Set Range")) {
                this.showDialog();
            } else if (m.getText().equals("Close")) {
                this.close();
            }
        } else if (e.getSource() == this.timeBinButton) {
            this.binType = 0;
            this.setGraphSpecificData();
            this.refreshGraph();
        } else if (e.getSource() == this.msgSizeBinButton) {
            this.binType = 1;
            this.setGraphSpecificData();
            this.refreshGraph();
        } else if (e.getSource() == this.entrySelectionButton) {
            System.out.println("selecting entries for display");
        } else if (e.getSource() == this.epTableButton) {
            System.out.println("Showing out of range entries");
        }
    }

    protected JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        mainPanel.setLayout(gbl);
        JPanel graphPanel = super.getMainPanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Histogram Controls"));
        this.entrySelectionButton = new JButton("Select Entries");
        this.entrySelectionButton.addActionListener(this);
        this.epTableButton = new JButton("Out-of-Range EPs");
        this.epTableButton.addActionListener(this);
        this.timeBinButton = new JRadioButton("Execution Time", true);
        this.timeBinButton.addActionListener(this);
        this.msgSizeBinButton = new JRadioButton("Message Size");
        this.msgSizeBinButton.addActionListener(this);
        this.binTypeGroup = new ButtonGroup();
        this.binTypeGroup.add(this.timeBinButton);
        this.binTypeGroup.add(this.msgSizeBinButton);
        buttonPanel.add(this.timeBinButton);
        buttonPanel.add(this.msgSizeBinButton);
        Util.gblAdd(mainPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(mainPanel, buttonPanel, gbc, 0, 1, 1, 1, 0, 0);
        return mainPanel;
    }

    protected void setGraphSpecificData() {
        if (this.binType == 0) {
            this.setXAxis("Entry Method Duration (at " + U.humanReadableString(this.timeBinSize) + " resolution)", "Time", this.timeMinBinSize, this.timeBinSize);
            this.setYAxis("Number of Occurrences", "");
            this.setDataSource("Histogram", this.counts[0], this.thisWindow);
        } else if (this.binType == 1) {
            this.setXAxis("Message Size (at " + this._format.format(this.msgBinSize) + " byte resolution)", "", this.msgMinBinSize, this.msgBinSize);
            this.setYAxis("Number of Occurrences", "");
            this.setDataSource("Histogram", this.counts[1], this.thisWindow);
        }
    }

    protected void refreshGraph() {
        super.refreshGraph();
    }

    public String[] getPopup(int xVal, int yVal) {
        if (this.binType == 0) {
            return this.getTimePopup(xVal, yVal);
        }
        if (this.binType == 1) {
            return this.getMsgSizePopup(xVal, yVal);
        }
        return null;
    }

    private String[] getTimePopup(int xVal, int yVal) {
        String[] bubbleText = new String[]{MainWindow.runObject[this.myRun].getEntryNameByIndex(yVal), "Count: " + this.counts[0][xVal][yVal], xVal < this.timeNumBins ? "Bin: " + U.humanReadableString((long)xVal * this.timeBinSize + this.timeMinBinSize) + " to " + U.humanReadableString((long)(xVal + 1) * this.timeBinSize + this.timeMinBinSize) : "Bin: > " + U.humanReadableString((long)this.timeNumBins * this.timeBinSize + this.timeMinBinSize)};
        return bubbleText;
    }

    private String[] getMsgSizePopup(int xVal, int yVal) {
        String[] bubbleText = new String[]{MainWindow.runObject[this.myRun].getEntryNameByIndex(yVal), "Count: " + this.counts[1][xVal][yVal], xVal < this.msgNumBins ? "Bin: " + this._format.format((long)xVal * this.msgBinSize + this.msgMinBinSize) + " bytes to " + this._format.format((long)(xVal + 1) * this.msgBinSize + this.msgMinBinSize) + " bytes" : "Bin: > " + this._format.format((long)this.msgNumBins * this.msgBinSize + this.msgMinBinSize) + " bytes"};
        return bubbleText;
    }

    protected void createMenus() {
        super.createMenus();
        this.menuBar.add(Util.makeJMenu("View", new Object[]{new JCheckBoxMenuItem("Show Longest EPs", true)}, this));
    }

    static /* synthetic */ double[][][] access$802(HistogramWindow x0, double[][][] x1) {
        x0.counts = x1;
        return x1;
    }
}

