/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Histogram;

import java.io.IOException;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

class ThreadedFileReader
implements Runnable {
    private int pe;
    private long startTime;
    private long endTime;
    private int myRun = 0;
    private int timeNumBins;
    private long timeBinSize;
    private long timeMinBinSize;
    private int msgNumBins;
    private long msgBinSize;
    private long msgMinBinSize;
    private double[][][] outputCounts;

    protected ThreadedFileReader(double[][][] outputCounts, int pe, long startTime, long endTime, int timeNumBins, long timeBinSize, long timeMinBinSize, int msgNumBins, long msgBinSize, long msgMinBinSize) {
        this.pe = pe;
        this.startTime = startTime;
        this.endTime = endTime;
        this.timeNumBins = timeNumBins;
        this.timeBinSize = timeBinSize;
        this.timeMinBinSize = timeMinBinSize;
        this.msgNumBins = msgNumBins;
        this.msgBinSize = msgBinSize;
        this.msgMinBinSize = msgMinBinSize;
        this.outputCounts = outputCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        double[][][] myCounts = this.getCounts();
        double[][][] dArray = this.outputCounts;
        synchronized (this.outputCounts) {
            for (int i = 0; i < this.outputCounts.length; ++i) {
                for (int j = 0; j < this.outputCounts[i].length; ++j) {
                    for (int k = 0; k < this.outputCounts[i][j].length; ++k) {
                        double[] dArray2 = this.outputCounts[i][j];
                        int n = k;
                        dArray2[n] = dArray2[n] + myCounts[i][j][k];
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            myCounts = null;
            return;
        }
    }

    private double[][][] getCounts() {
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        double[][][] countData = new double[][][]{new double[this.timeNumBins + 1][numEPs], new double[this.msgNumBins + 1][numEPs]};
        int curPeCount = 0;
        ++curPeCount;
        GenericLogReader reader = new GenericLogReader(this.pe, MainWindow.runObject[this.myRun].getVersion());
        try {
            int nestingLevel = 0;
            LogEntryData prevBegin = null;
            block10: while (true) {
                LogEntryData logdata = reader.nextEvent();
                switch (logdata.type) {
                    case 2: {
                        if (++nestingLevel != 1) break;
                        prevBegin = logdata;
                        break;
                    }
                    case 3: {
                        int targetBin;
                        if (--nestingLevel == 0) {
                            long executionTime;
                            long adjustedTime;
                            if (logdata.time >= this.startTime && logdata.time <= this.endTime && (adjustedTime = (executionTime = logdata.time - prevBegin.time) - this.timeMinBinSize) >= 0L) {
                                targetBin = (int)(adjustedTime / this.timeBinSize);
                                if (targetBin >= this.timeNumBins) {
                                    targetBin = this.timeNumBins;
                                }
                                double[] dArray = countData[0][targetBin];
                                int n = logdata.entry;
                                dArray[n] = dArray[n] + 1.0;
                            }
                            prevBegin = null;
                            break;
                        }
                        if (nestingLevel >= 0) break;
                        nestingLevel = 0;
                        prevBegin = null;
                        break;
                    }
                    case 1: {
                        long adjustedSize;
                        if (logdata.time > this.endTime || (adjustedSize = (long)logdata.msglen - this.msgMinBinSize) < 0L) continue block10;
                        int targetBin = (int)(adjustedSize / this.msgBinSize);
                        if (targetBin >= this.msgNumBins) {
                            targetBin = this.msgNumBins;
                        }
                        double[] dArray = countData[1][targetBin];
                        int n = logdata.entry;
                        dArray[n] = dArray[n] + 1.0;
                    }
                }
            }
        }
        catch (EndOfLogSuccess e) {
        }
        catch (Exception e) {
            System.err.println("Exception " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + this.pe);
        }
        return countData;
    }
}

