/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.MemoryUsage;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import projections.Tools.MemoryUsage.ThreadedFileReader;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.analysis.TimedProgressThreadExecutor;
import projections.gui.IntervalChooserPanel;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.U;
import projections.misc.LogEntryData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryUsageWindow
extends ProjectionsWindow {
    private int myRun = 0;
    private TreeMap<Long, XYSeries> memorySamples;
    private MemoryUsageWindow thisWindow = this;
    private MainWindow mainWindow;
    private JMenuBar mbar;
    private JMenuItem mShowPhaseInfo;
    private JMenuItem mViewDataAsText;
    private JMenuItem mViewPhaseInfoAsText;
    private Vector<String> availableStepStrings;
    private Vector<Long> availableStepTimes;
    private IntervalChooserPanel intervalPanel;
    private double timeScalingFactor = 1.0;
    private String timeUnits = "us-default";
    private long intervalSize;
    private long startInterval;
    private long endInterval;
    private TreeMap<Long, double[]> memoryData;

    public MemoryUsageWindow(MainWindow mainWindow) {
        super(mainWindow);
        this.mainWindow = mainWindow;
        this.memorySamples = new TreeMap();
        this.setForeground(Color.lightGray);
        this.setTitle("Memory Usage - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.createMenus();
        this.pack();
        this.showDialog();
    }

    private void createMenus() {
        this.mbar = new JMenuBar();
        JMenu m1 = new JMenu("Phase Information");
        this.mShowPhaseInfo = new JMenuItem("Display Phase Information");
        m1.add(this.mShowPhaseInfo);
        this.mShowPhaseInfo.addActionListener(new PhaseInformationDisplay());
        JMenu m2 = new JMenu("Export Data");
        this.mViewDataAsText = new JMenuItem("Max Memory Usage");
        m2.add(this.mViewDataAsText);
        this.mViewDataAsText.addActionListener(new ViewMaxMemAsTextDisplay());
        this.mViewPhaseInfoAsText = new JMenuItem("Phase Information");
        m2.add(this.mViewPhaseInfoAsText);
        this.mViewPhaseInfoAsText.addActionListener(new ViewPhaseInfoAsTextDisplay());
        this.mbar.add(m1);
        this.mbar.add(m2);
        this.setJMenuBar(this.mbar);
    }

    @Override
    public void showDialog() {
        try {
            if (this.dialog == null) {
                this.intervalPanel = new IntervalChooserPanel();
                this.dialog = new RangeDialog(this, "Select Range", this.intervalPanel, false);
            }
            this.dialog.displayDialog();
            if (!this.dialog.isCancelled()) {
                final OrderedIntList pes = this.dialog.getSelectedProcessors();
                this.intervalSize = this.intervalPanel.getIntervalSize();
                this.startInterval = this.intervalPanel.getStartInterval();
                this.endInterval = this.intervalPanel.getEndInterval();
                SwingWorker worker = new SwingWorker(){

                    public Object doInBackground() {
                        MemoryUsageWindow.this.thisWindow.loadData(pes);
                        return null;
                    }

                    public void done() {
                        MemoryUsageWindow.this.thisWindow.createPlot();
                    }
                };
                worker.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createPlot() {
        this.setVisible(false);
        Iterator<Long> pes = this.memorySamples.keySet().iterator();
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        int totalSampleCount = 0;
        while (pes.hasNext()) {
            Long pe = pes.next();
            XYSeries series = this.memorySamples.get(pe);
            totalSampleCount += series.getItemCount();
            seriesCollection.addSeries(series);
        }
        if (totalSampleCount == 0) {
            JOptionPane.showMessageDialog(this, "No memory usage entries found in log files. Add calls to traceMemoryUsage() in the application", "Warning", 2);
            Container windowPane = this.thisWindow.getContentPane();
            windowPane.removeAll();
            windowPane.setLayout(new BorderLayout());
            windowPane.add((Component)new JLabel("No memory log entries found!"), "Center");
            this.setJMenuBar(this.mbar);
            this.setSize(400, 400);
            this.validate();
            this.repaint();
            this.setVisible(true);
            return;
        }
        JFreeChart chart = ChartFactory.createScatterPlot("Memory Usage (at " + U.humanReadableString(this.intervalSize) + " resolution)", "Time (" + this.timeUnits + ")", "MB", seriesCollection, PlotOrientation.VERTICAL, true, true, false);
        XYDotRenderer renderer = new XYDotRenderer();
        renderer.setDotWidth(2);
        renderer.setDotHeight(2);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(true);
        plot.setRenderer(renderer);
        this.determineStepsFromPEZero();
        for (int i = 0; i < this.availableStepTimes.size(); ++i) {
            ValueMarker m = new ValueMarker((double)this.availableStepTimes.elementAt(i).longValue() * this.timeScalingFactor, Color.black, new BasicStroke(1.0f));
            plot.addDomainMarker(m);
        }
        ChartPanel chartpanel = new ChartPanel(chart);
        chart.setBackgroundPaint(Color.white);
        chartpanel.setPreferredSize(new Dimension(1100, 700));
        Container windowPane = this.thisWindow.getContentPane();
        windowPane.removeAll();
        windowPane.setLayout(new BorderLayout());
        windowPane.add((Component)chartpanel, "Center");
        this.thisWindow.setJMenuBar(this.mbar);
        this.thisWindow.pack();
        this.thisWindow.setVisible(true);
    }

    private void loadData(OrderedIntList processorList) {
        double timeSpan = (this.endInterval - this.startInterval) * this.intervalSize;
        if (timeSpan > 5000000.0) {
            this.timeScalingFactor = 1.0E-6;
            this.timeUnits = "s";
        } else if (timeSpan > 5000.0) {
            this.timeScalingFactor = 0.001;
            this.timeUnits = "ms";
        } else {
            this.timeScalingFactor = 1.0;
            this.timeUnits = "us";
        }
        if (MainWindow.runObject[this.myRun].hasLogFiles() || MainWindow.runObject[this.myRun].hasSumDetailFiles()) {
            LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
            while (processorList.hasMoreElements()) {
                int nextPe = processorList.nextElement();
                readyReaders.add(new ThreadedFileReader(nextPe, this.myRun, this.intervalSize, this.startInterval, this.endInterval, this.timeScalingFactor));
            }
            Component guiRootForProgressBar = null;
            if (this.thisWindow != null && this.thisWindow.isVisible()) {
                guiRootForProgressBar = this.thisWindow;
            } else if (this.mainWindow != null && this.mainWindow.isVisible()) {
                guiRootForProgressBar = this.mainWindow;
            } else if (MainWindow.runObject[this.myRun].guiRoot != null && MainWindow.runObject[this.myRun].guiRoot.isVisible()) {
                guiRootForProgressBar = MainWindow.runObject[this.myRun].guiRoot;
            }
            TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Time Profile in Parallel", readyReaders, guiRootForProgressBar, true);
            threadManager.runAll();
            this.memorySamples = new TreeMap();
            this.memoryData = new TreeMap();
            for (ThreadedFileReader threadedFileReader : readyReaders) {
                this.memorySamples.put(threadedFileReader.getPe(), threadedFileReader.getMemorySamples());
                this.memoryData.put(threadedFileReader.getPe(), threadedFileReader.getData());
            }
        }
    }

    private Vector<Long> determineStepsFromPEZero() {
        this.availableStepStrings = new Vector();
        this.availableStepTimes = new Vector();
        if (!MainWindow.runObject[this.myRun].hasLogData()) {
            return this.availableStepTimes;
        }
        int pe = 0;
        GenericLogReader reader = new GenericLogReader(pe, MainWindow.runObject[this.myRun].getVersion());
        try {
            int c = 0;
            while (true) {
                LogEntryData data = reader.nextEvent();
                if (data.type != 28 || !data.note.contains("***")) continue;
                String pruned = data.note.replace("*** ", "");
                this.availableStepStrings.add("" + c++ + ": " + pruned);
                this.availableStepTimes.add(data.time);
            }
        }
        catch (EndOfLogSuccess e) {
        }
        catch (Exception e) {
            System.err.println("Error occured while reading data for pe " + pe);
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + pe);
        }
        return this.availableStepTimes;
    }

    private class PhaseInformationDisplay
    implements ActionListener {
        PhaseInformationDisplay() {
        }

        public void actionPerformed(ActionEvent e) {
            String info = "";
            for (int i = 0; i < MemoryUsageWindow.this.availableStepTimes.size(); ++i) {
                info = info + "" + U.humanReadableString((Long)MemoryUsageWindow.this.availableStepTimes.elementAt(i)) + "\t" + (String)MemoryUsageWindow.this.availableStepStrings.elementAt(i) + "\n";
            }
            System.out.println("Phase Info:\n" + info + "\n");
            new FrameWithText(info, "Phase Information:");
        }
    }

    private class ViewMaxMemAsTextDisplay
    implements ActionListener {
        ViewMaxMemAsTextDisplay() {
        }

        public void actionPerformed(ActionEvent e) {
            int numIntervals = (int)(MemoryUsageWindow.this.endInterval - MemoryUsageWindow.this.startInterval);
            double[] memMax = new double[numIntervals];
            for (Long pe : MemoryUsageWindow.this.memoryData.keySet()) {
                double[] data = (double[])MemoryUsageWindow.this.memoryData.get(pe);
                for (int i = 0; i < data.length; ++i) {
                    if (!(memMax[i] < data[i])) continue;
                    memMax[i] = data[i];
                }
            }
            String info = "Copy & paste into your favorite spreadsheet or plotting tool:\n\nTime\tMaximum memory Usage Across All PEs:\n";
            for (int i = 0; i < numIntervals; ++i) {
                double time = (double)(((long)i + MemoryUsageWindow.this.startInterval) * MemoryUsageWindow.this.intervalSize) * MemoryUsageWindow.this.timeScalingFactor;
                if (!(memMax[i] > 0.0)) continue;
                info = info + "" + time + "\t" + memMax[i] + "\n";
            }
            new FrameWithText(info, "Maximum Memory Usage:");
        }
    }

    private class ViewPhaseInfoAsTextDisplay
    implements ActionListener {
        ViewPhaseInfoAsTextDisplay() {
        }

        public void actionPerformed(ActionEvent e) {
            String info = "Copy & paste into your favorite spreadsheet or plotting tool:\n\nTime\tMaximum memory Usage Across All PEs:\n";
            for (int i = 0; i < MemoryUsageWindow.this.availableStepTimes.size(); ++i) {
                info = info + "" + U.humanReadableString((Long)MemoryUsageWindow.this.availableStepTimes.elementAt(i)) + "\t" + (String)MemoryUsageWindow.this.availableStepStrings.elementAt(i) + "\n";
            }
            System.out.println("Phase Info:\n" + info + "\n");
            new FrameWithText(info, "Phase Information:");
        }
    }

    private class FrameWithText {
        FrameWithText(String text, String title) {
            JFrame f = new JFrame();
            JTextArea textArea = new JTextArea(text);
            textArea.setFont(new Font("Arial", 0, 16));
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            JScrollPane areaScrollPane = new JScrollPane(textArea);
            areaScrollPane.setVerticalScrollBarPolicy(22);
            areaScrollPane.setPreferredSize(new Dimension(900, 600));
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add((Component)areaScrollPane, "Center");
            f.setTitle(title);
            f.pack();
            f.setVisible(true);
        }
    }
}

