/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.MemoryUsage;

import java.io.IOException;
import org.jfree.data.xy.XYSeries;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

class ThreadedFileReader
implements Runnable {
    private int pe;
    private int myRun;
    private XYSeries series;
    private long intervalSize;
    private long startInterval;
    private long endInterval;
    private double timeScalingFactor;
    private double[] maxUsage;

    protected ThreadedFileReader(int pe, int myRun, long intervalSize, long startInterval, long endInterval, double timeScalingFactor) {
        this.pe = pe;
        this.myRun = myRun;
        this.intervalSize = intervalSize;
        this.startInterval = startInterval;
        this.endInterval = endInterval;
        this.timeScalingFactor = timeScalingFactor;
    }

    public void run() {
        GenericLogReader reader = new GenericLogReader(this.pe, MainWindow.runObject[this.myRun].getVersion());
        int numIntervals = (int)(this.endInterval - this.startInterval);
        this.maxUsage = new double[numIntervals];
        int count = 0;
        try {
            while (true) {
                LogEntryData data = reader.nextEvent();
                ++count;
                double memMB = (double)data.memoryUsage / 1048576.0;
                int interval = (int)(data.time / this.intervalSize);
                if ((long)interval >= this.endInterval || (long)interval < this.startInterval || data.type != 27 || !(memMB > this.maxUsage[interval])) continue;
                this.maxUsage[interval] = memMB;
            }
        }
        catch (EndOfLogSuccess e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + this.pe);
        }
        this.series = new XYSeries((Comparable)((Object)("PE " + this.pe)));
        for (int i = 0; i < numIntervals; ++i) {
            long time = (this.startInterval + (long)i) * this.intervalSize + this.intervalSize / 2L;
            if (this.maxUsage[i] > 0.0) {
                this.series.add((double)time * this.timeScalingFactor, this.maxUsage[i]);
                continue;
            }
            this.series.add((double)time * this.timeScalingFactor, (Number)null);
        }
    }

    public double[] getData() {
        return this.maxUsage;
    }

    protected XYSeries getMemorySamples() {
        return this.series;
    }

    public long getPe() {
        return this.pe;
    }
}

