/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Overview;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import projections.Tools.Overview.ThreadedFileReader;
import projections.analysis.TimedProgressThreadExecutor;
import projections.gui.ColorMap;
import projections.gui.JPanelToImage;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ScalePanel;
import projections.gui.U;

class OverviewPanel
extends ScalePanel.Child {
    private int myRun = 0;
    private int[][] entryData;
    private int[][] idleData;
    private int[][] utilData;
    private int[][] colors;
    private int intervalSize;
    private int nPe;
    private OrderedIntList selectedPEs;
    private long startTime;
    private long endTime;
    private int startInterval;
    private int endInterval;
    private int numEPs;
    private boolean saveImage;
    private ColorMap colorMap;
    private int mode;

    public String getPointInfo(double time, double procs) {
        int p = (int)procs;
        if (p < 0 || p >= this.nPe || procs < 0.0) {
            return "";
        }
        long t = (long)time;
        if (t < 0L || t >= this.totalTime()) {
            return "";
        }
        if (this.selectedPEs != null) {
            int pe = 0;
            this.selectedPEs.reset();
            for (int count = 0; count <= p; ++count) {
                pe = this.selectedPEs.nextElement();
            }
            int interval = (int)(t / (long)this.intervalSize);
            long timedisplay = t + this.startTime;
            if (interval >= this.entryData[p].length) {
                return "some bug has occurred";
            }
            if (this.mode == 0) {
                return "Processor " + pe + ": Usage = " + this.utilData[p][interval] + "%" + " IDLE = " + this.idleData[p][interval] + "%" + " at " + U.humanReadableString(timedisplay) + " (" + timedisplay + " us). ";
            }
            if (this.mode == 1) {
                if (this.entryData[p][interval] > 0) {
                    return "Processor " + pe + ": Usage = " + this.utilData[p][interval] + "%" + " at " + U.humanReadableString(timedisplay) + " (" + timedisplay + " us)." + " EP = " + this.entryName(this.entryData[p][interval]);
                }
                return "Processor " + pe + ": Usage = " + this.utilData[p][interval] + "%" + " at " + U.humanReadableString(timedisplay) + " (" + timedisplay + " us). ";
            }
        }
        return "";
    }

    private String entryName(int entry) {
        if (entry < this.numEPs) {
            return MainWindow.runObject[this.myRun].getEntryNameByIndex(entry);
        }
        if (entry == this.numEPs) {
            return "Overhead";
        }
        if (entry == this.numEPs + 1) {
            return "Idle";
        }
        return "";
    }

    public void paint(ScalePanel.Child.RepaintRequest req) {
        double time2pix = req.x(1.0) - req.x(0.0);
        double pix2time = 1.0 / time2pix;
        double tl = req.xInv(0.0);
        double th = req.xInv(req.w - 1);
        double pl = req.yInv(0.0);
        double ph = req.yInv(req.h - 1);
        if (tl < 0.0) {
            tl = 0.0;
        }
        if (tl >= (double)this.totalTime()) {
            tl = (double)this.totalTime() - 0.001;
        }
        if (th < 0.0) {
            th = 0.0;
        }
        if (th >= (double)this.totalTime()) {
            th = (double)this.totalTime() - 0.001;
        }
        if (pl < 0.0) {
            pl = 0.0;
        }
        if (pl >= (double)this.nPe) {
            pl = (double)this.nPe - 0.001;
        }
        if (ph < 0.0) {
            ph = 0.0;
        }
        if (ph >= (double)this.nPe) {
            ph = (double)this.nPe - 0.001;
        }
        int startx = (int)Math.ceil(req.x(tl));
        int endx = (int)Math.floor(req.x(th));
        int starty = (int)Math.ceil(req.y(pl));
        int endy = (int)Math.floor(req.y(ph));
        int wid = endx - startx;
        int ht = endy - starty;
        double x2t_off = req.xInv(startx) / (double)this.intervalSize;
        double x2t_slope = pix2time / (double)this.intervalSize;
        if (this.selectedPEs != null && wid > 0 && ht > 0) {
            int proc;
            int[] offBuf = new int[wid * ht];
            this.selectedPEs.reset();
            int p = 0;
            while ((proc = this.selectedPEs.nextElement()) != -1) {
                if (proc == -1) continue;
                int y_min = (int)Math.floor(req.y(p));
                int y_max = (int)Math.floor(req.y(p + 1));
                if (y_min < starty) {
                    y_min = starty;
                }
                if (y_max > endy) {
                    y_max = endy;
                }
                if (p < this.colors.length) {
                    this.renderRow(this.colors[p], x2t_off, x2t_slope, offBuf, wid, y_min - starty, y_max - starty, startx - startx, endx - startx);
                }
                ++p;
            }
            Image offImg = this.createImage(new MemoryImageSource(wid, ht, offBuf, 0, wid));
            req.g.drawImage(offImg, startx, starty, null);
        }
        req.g.setColor(Color.black);
        req.g.fillRect(0, 0, startx, endy);
        req.g.fillRect(startx, 0, req.w, starty);
        req.g.fillRect(endx, starty, req.w, endy);
        req.g.fillRect(0, endy, req.w, req.h);
    }

    private void renderRow(int[] src, double off, double slope, int[] dest, int w, int yLo, int yHi, int xLo, int xHi) {
        int iOff = (int)(65536.0 * off);
        int iSlope = (int)(65536.0 * slope);
        int iCur = iOff + xLo * iSlope;
        int srcIndex = 0;
        for (int x = xLo; x < xHi; ++x) {
            srcIndex = iCur >> 16;
            if (srcIndex < 0) {
                srcIndex = 0;
                continue;
            }
            if (srcIndex >= src.length) {
                iCur += iSlope;
                continue;
            }
            int val = src[srcIndex];
            iCur += iSlope;
            int loc = yLo * w + x;
            int y = yLo;
            while (y < yHi) {
                if (loc < dest.length) {
                    dest[loc] = val;
                }
                ++y;
                loc += w;
            }
        }
    }

    public void setColorMap(ColorMap cm) {
        this.colorMap = cm;
    }

    private void applyColorMap(int[][] data, boolean entryBased) {
        int numIntervals;
        int numPE;
        if (!entryBased) {
            int nPE = data.length;
            this.colors = new int[nPE][];
            for (int p = 0; p < nPE; ++p) {
                int n = data[p].length;
                this.colors[p] = new int[n];
                for (int i = 0; i < n; ++i) {
                    if (data[p][i] > 255 || data[p][i] < 0) {
                        this.colors[p][i] = this.colorMap.apply(255);
                        System.err.println("[" + p + "] Warning: Invalid " + "value " + data[p][i] + " being " + "applied to the color map " + "at time interval " + i + "!");
                        continue;
                    }
                    this.colors[p][i] = this.colorMap.apply(data[p][i]);
                }
            }
        } else {
            numPE = data.length;
            numIntervals = data[numPE - 1].length;
            this.colors = new int[numPE][numIntervals];
            for (int pe = 0; pe < numPE; ++pe) {
                for (int interval = 0; interval < numIntervals; ++interval) {
                    this.colors[pe][interval] = data[pe][interval] == this.numEPs ? Color.black.getRGB() : (data[pe][interval] == this.numEPs + 1 ? Color.white.getRGB() : (data[pe][interval] > 0 ? MainWindow.runObject[this.myRun].getEntryColor(data[pe][interval]).getRGB() : Color.black.getRGB()));
                }
            }
        }
        this.repaint();
        if (this.saveImage) {
            numPE = this.colors.length;
            numIntervals = this.colors[numPE - 1].length;
            BufferedImage image = new BufferedImage(numIntervals, numPE, 1);
            Graphics2D g = image.createGraphics();
            for (int y = 0; y < numPE; ++y) {
                for (int x = 0; x < numIntervals; ++x) {
                    Color c = new Color(this.colors[y][x]);
                    g.setColor(c);
                    g.fillRect(x, y, 1, 1);
                }
            }
            g.dispose();
            JPanelToImage.saveToFileChooserSelection(image, "Save Overview to PNG or JPG", "Overview.png");
        }
    }

    private long totalTime() {
        return this.endTime - this.startTime;
    }

    protected void setRanges(OrderedIntList selectedPEs, long startTime, long endTime) {
        this.selectedPEs = selectedPEs;
        this.startTime = startTime;
        this.endTime = endTime;
        int desiredIntervals = this.totalTime() < 7000L ? (int)((double)this.totalTime() - 1.0) : 7000;
        double trialintervalSize = this.totalTime() / (long)desiredIntervals;
        if (trialintervalSize < 5.0) {
            trialintervalSize = this.totalTime() / (long)(desiredIntervals /= 5);
        }
        this.intervalSize = (int)trialintervalSize;
        this.startInterval = (int)(startTime / (long)this.intervalSize);
        this.endInterval = (int)(endTime / (long)this.intervalSize);
        this.nPe = selectedPEs.size();
        this.numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
    }

    protected void loadData(boolean saveImage) {
        if (!MainWindow.runObject[this.myRun].hasLogData()) {
            System.err.println("No log files are available.");
            JOptionPane.showMessageDialog(null, "No log files are available.");
            return;
        }
        this.saveImage = saveImage;
        this.mode = 1;
        LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
        this.selectedPEs.size();
        int numIntervals = this.endInterval - this.startInterval;
        this.entryData = new int[this.selectedPEs.size()][numIntervals];
        float[][] utilizationData = new float[this.selectedPEs.size()][numIntervals];
        int pIdx = 0;
        this.selectedPEs.reset();
        while (this.selectedPEs.hasMoreElements()) {
            int nextPe = this.selectedPEs.nextElement();
            readyReaders.add(new ThreadedFileReader(nextPe, this.intervalSize, this.myRun, this.startInterval, this.endInterval, this.entryData[pIdx], utilizationData[pIdx]));
            ++pIdx;
        }
        TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Overview in Parallel", readyReaders, this, true);
        threadManager.runAll();
        this.utilData = new int[utilizationData.length][utilizationData[0].length];
        for (int i = 0; i < utilizationData.length; ++i) {
            for (int j = 0; j < utilizationData[i].length; ++j) {
                this.utilData[i][j] = (int)(100.0f * utilizationData[i][j]);
            }
        }
        utilizationData = null;
        this.colorByEntry();
    }

    protected void colorByEntry() {
        this.mode = 1;
        this.applyColorMap(this.entryData, true);
    }

    protected void colorByUtil() {
        this.mode = 0;
        this.applyColorMap(this.utilData, false);
    }
}

