/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import projections.Tools.Timeline.Data;
import projections.gui.Util;

class AxisPanel
extends JPanel {
    private int smallTickHalfLength = 2;
    private int largeTickHalfLength = 5;
    private Data data;
    private DecimalFormat format_ = new DecimalFormat();

    private int totalHeight() {
        if (this.data.useMinimalView()) {
            return this.axispos() + this.largeTickHalfLength;
        }
        return 14 + this.axispos() + this.largeTickHalfLength;
    }

    private int axispos() {
        if (this.data.useMinimalView()) {
            return 2 + this.largeTickHalfLength + this.textpos();
        }
        return 5 + this.largeTickHalfLength + this.textpos();
    }

    private int axisLabelPositionY() {
        if (this.data.useMinimalView()) {
            return 0;
        }
        return 15;
    }

    private int textpos() {
        if (this.data.useMinimalView()) {
            return this.data.axisFont.getSize() + this.axisLabelPositionY();
        }
        return 5 + this.data.axisFont.getSize() + this.axisLabelPositionY();
    }

    protected AxisPanel(Data data) {
        this.data = data;
        this.format_.setGroupingUsed(true);
    }

    public Dimension getPreferredSize() {
        int preferredWidth = 200;
        int preferredHeight = this.totalHeight();
        return new Dimension(preferredWidth, preferredHeight);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(this.data.axisFont);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.data.getBackgroundColor());
        Rectangle clipBounds = g.getClipBounds();
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        int maxx = this.getWidth();
        int xLeft = this.data.offset();
        int xRight = maxx - this.data.offset();
        g.setColor(this.data.getForegroundColor());
        g.drawLine(xLeft, this.axispos(), xRight, this.axispos());
        for (int i = 0; i < this.numBigTicks() + 1; ++i) {
            double timeForTick = this.startTimePretty() + (long)(i * this.smallTickTimeIncrement() * this.smallTicksPerBigTick());
            int pixelForTickX = this.data.timeToScreenPixel(timeForTick);
            if (pixelForTickX < xLeft || pixelForTickX > xRight) continue;
            String label = this.format_.format(timeForTick);
            g.drawLine(pixelForTickX, this.axispos() - this.largeTickHalfLength, pixelForTickX, this.axispos() + this.largeTickHalfLength);
            g.drawString(label, pixelForTickX - fm.stringWidth(label) / 2, this.textpos());
        }
        double timeForFirstBigTick = this.startTimePretty();
        for (int i = 0; i < this.numSmallTicks() + 1; ++i) {
            double timeForTick = timeForFirstBigTick + (double)(i * this.smallTickTimeIncrement());
            int pixelForTickX = this.data.timeToScreenPixel(timeForTick);
            if (pixelForTickX < xLeft || pixelForTickX > xRight) continue;
            g.drawLine(pixelForTickX, this.axispos() - this.smallTickHalfLength, pixelForTickX, this.axispos() + this.smallTickHalfLength);
        }
        g.drawString(this.axisLabel(), this.getWidth() / 2 - fm.stringWidth(this.axisLabel()) / 2, this.axisLabelPositionY());
    }

    private long startTimePretty() {
        return this.data.startTime() / (long)this.smallTickTimeIncrement() * (long)this.smallTickTimeIncrement();
    }

    private String axisLabel() {
        return "Time In Microseconds";
    }

    private int smallTickTimeIncrement() {
        int actualDisplayWidth = this.getWidth();
        double pixelPerMicrosecond = (double)this.data.lineWidth(actualDisplayWidth) / (double)this.data.totalTime();
        double pixelsPerSmallTick = 5.0;
        int microsecondPerTick = Util.getBestIncrement((int)Math.ceil(pixelsPerSmallTick / pixelPerMicrosecond));
        return microsecondPerTick;
    }

    private int numSmallIntervals() {
        return (int)(this.data.totalTime() / (long)this.smallTickTimeIncrement() + 1L);
    }

    private int numSmallTicks() {
        return 1 + this.numSmallIntervals();
    }

    private int numBigIntervals() {
        return this.numSmallIntervals() / this.smallTicksPerBigTick();
    }

    private int numBigTicks() {
        return 1 + this.numBigIntervals();
    }

    private double pixelsPerTickMark() {
        return (double)this.data.lineWidth(this.getWidth()) / (double)this.numSmallIntervals();
    }

    private int smallTicksPerBigTick() {
        return Util.getBestIncrement((int)Math.ceil((double)this.data.maxLabelLen() / this.pixelsPerTickMark()));
    }
}

