/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import projections.Tools.Timeline.ClickableColorBox1;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.MyTableModel1;
import projections.gui.ColorEditor;
import projections.gui.ColorRenderer;

class ChooseEntriesWindow
extends JFrame {
    private Data data;
    private Map<Integer, String> entryNames;
    private Vector<Vector> tabledata;
    private Vector<String> columnNames;
    private JButton checkAll;
    private JButton uncheckAll;

    ChooseEntriesWindow(Data _data) {
        this.data = _data;
        this.createLayout();
    }

    private void createLayout() {
        this.setTitle("Choose which entry methods are displayed and their colors");
        this.columnNames = new Vector();
        this.columnNames.add(new String("Visible"));
        this.columnNames.add(new String("Entry Method"));
        this.columnNames.add(new String("ID"));
        this.columnNames.add(new String("Color"));
        this.tabledata = new Vector();
        this.entryNames = this.data.getEntryNames();
        this.entryNames.put(-1, "Overhead");
        this.entryNames.put(-2, "Idle");
        for (Integer id : this.entryNames.keySet()) {
            String name = this.entryNames.get(id);
            Vector<Object> tableRow = new Vector<Object>();
            Boolean b = this.data.entryIsVisibleID(id);
            ClickableColorBox1 c = new ClickableColorBox1(id, this.data.getEntryColor(id), this.data);
            tableRow.add(b);
            tableRow.add(name);
            tableRow.add(id);
            tableRow.add(c);
            this.tabledata.add(tableRow);
        }
        MyTableModel1 tableModel = new MyTableModel1(this.tabledata, this.columnNames, this.data, this.checkAll, this.uncheckAll);
        JTable table = new JTable(tableModel);
        this.initColumnSizes(table);
        table.setDefaultRenderer(ClickableColorBox1.class, new ColorRenderer());
        table.setDefaultEditor(ClickableColorBox1.class, new ColorEditor());
        JScrollPane scroller = new JScrollPane(table);
        scroller.setHorizontalScrollBarPolicy(30);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.checkAll = new JButton("Make All Visible");
        this.uncheckAll = new JButton("Hide All");
        this.checkAll.addActionListener(tableModel);
        this.uncheckAll.addActionListener(tableModel);
        buttonPanel.add(this.checkAll);
        buttonPanel.add(this.uncheckAll);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)buttonPanel, "North");
        p.add((Component)scroller, "Center");
        this.setContentPane(p);
        this.pack();
        this.setSize(800, 400);
        this.setVisible(true);
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(70);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(680);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(50);
    }
}

