/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import projections.Tools.Timeline.Data;

class ChooseUserEventsWindow
extends JFrame {
    private Data data;
    private Map<Integer, String> names;
    private Vector<Vector> tabledata;
    private Vector<String> columnNames;

    ChooseUserEventsWindow(Data _data) {
        this.data = _data;
        this.createLayout();
    }

    private void createLayout() {
        this.setTitle("Choose which user events are displayed");
        this.columnNames = new Vector();
        this.columnNames.add(new String("Visible"));
        this.columnNames.add(new String("User Event Name"));
        this.columnNames.add(new String("ID"));
        this.columnNames.add(new String("Color"));
        this.tabledata = new Vector();
        this.names = this.data.getUserEventNames();
        Boolean b = true;
        Vector<Object> tableRow = new Vector<Object>();
        tableRow.add(b);
        tableRow.add("Unspecified");
        tableRow.add("");
        tableRow.add(Color.white);
        this.tabledata.add(tableRow);
        for (Integer id : this.names.keySet()) {
            String name = this.names.get(id);
            Vector<Object> tableRow2 = new Vector<Object>();
            Boolean b2 = this.data.entryIsVisibleID(id);
            Color c = this.data.getUserEventColor(id);
            tableRow2.add(b2);
            tableRow2.add(name);
            tableRow2.add(id);
            tableRow2.add(c);
            this.tabledata.add(tableRow2);
        }
        MyTableModel tableModel = new MyTableModel();
        JTable table = new JTable(tableModel);
        this.initColumnSizes(table);
        table.setDefaultRenderer(Color.class, new ColorRenderer());
        JScrollPane scroller = new JScrollPane(table);
        scroller.setHorizontalScrollBarPolicy(30);
        this.setContentPane(scroller);
        this.pack();
        this.setSize(800, 400);
        this.setVisible(true);
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(70);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(680);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(50);
    }

    private class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        private ColorRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground((Color)color);
            return this;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        public boolean isCellEditable(int row, int col) {
            return col < 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return ChooseUserEventsWindow.this.tabledata.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((Vector)ChooseUserEventsWindow.this.tabledata.get(rowIndex)).get(columnIndex);
        }

        public String getColumnName(int col) {
            return (String)ChooseUserEventsWindow.this.columnNames.get(col);
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                Boolean newValue = (Boolean)value;
                if (row == 0) {
                    if (newValue.booleanValue()) {
                        ChooseUserEventsWindow.this.data.makeUserSuppliedNotesVisible();
                    } else {
                        ChooseUserEventsWindow.this.data.makeUserSuppliedNotesInvisible();
                    }
                } else {
                    Integer id = (Integer)((Vector)ChooseUserEventsWindow.this.tabledata.get(row)).get(2);
                    if (newValue.booleanValue()) {
                        ChooseUserEventsWindow.this.data.makeUserEventVisibleID(id);
                    } else {
                        ChooseUserEventsWindow.this.data.makeUserEventInvisibleID(id);
                    }
                }
            }
            ((Vector)ChooseUserEventsWindow.this.tabledata.get(row)).set(col, value);
            this.fireTableCellUpdated(row, col);
        }
    }
}

