/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ToolTipManager;
import projections.Tools.Timeline.EntryMethodObject;
import projections.Tools.Timeline.MainHandler;
import projections.Tools.Timeline.MemoryColorRangeChooser;
import projections.Tools.Timeline.MemoryLegend;
import projections.Tools.Timeline.MessageStructures;
import projections.Tools.Timeline.ThreadedFileReader;
import projections.Tools.Timeline.TimelineMessage;
import projections.Tools.Timeline.UserEventObject;
import projections.analysis.PackTime;
import projections.analysis.TimedProgressThreadExecutor;
import projections.analysis.TimelineEvent;
import projections.gui.Analysis;
import projections.gui.ColorManager;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.OrderedUsageList;
import projections.misc.LogLoadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Data {
    protected static final int BlueGradientColors = 0;
    protected static final int RandomColors = 1;
    int myRun = 0;
    private MainHandler modificationHandler = null;
    private float scaleFactor = 1.0f;
    private double preferredViewTime = -1.0;
    private int mostRecentScaledScreenWidth;
    private LinkedList<Integer> peToLine;
    private boolean colorByObjectId;
    private boolean colorByMemoryUsage;
    private boolean colorByUserSupplied;
    private boolean colorByEntryId;
    private boolean colorByEntryIdFreq;
    private int[] entries;
    private Color[] entryColor;
    public TreeMap<Integer, Color> entryColorsMapping = new TreeMap();
    private Set<Integer> hiddenEntryPoints;
    private Set<Integer> hiddenUserEvents;
    private boolean hideUserSuppliedNotes = false;
    protected Map<Integer, List<EntryMethodObject>> allEntryMethodObjects = new TreeMap<Integer, List<EntryMethodObject>>();
    protected Map<Integer, Set<UserEventObject>> allUserEventObjects = new TreeMap<Integer, Set<UserEventObject>>();
    protected TreeMap<Integer, LinkedList<Integer>> frequencyTreeMap = new TreeMap();
    protected Vector<Integer> frequencyVector = new Vector();
    float[] processorUsage;
    float[] idleUsage;
    private float[] packUsage;
    private OrderedUsageList[] entryUsageList;
    private long startTime;
    private long endTime;
    private long oldBT;
    private long oldET;
    private long minMem;
    private long maxMem;
    private long minMemColorRange;
    private long maxMemColorRange;
    MessageStructures messageStructures;
    private boolean showPacks;
    private boolean showIdle;
    private boolean showMsgs;
    private boolean showUserEvents;
    private boolean skipIdleRegions;
    private boolean skipLoadingMessages;
    private boolean skipLoadingUserEvents;
    private long minEntryDuration;
    protected Font labelFont;
    protected Font axisFont;
    private boolean useMinimalView = false;
    protected Set<EntryMethodObject> drawMessagesForTheseObjects;
    protected Set<EntryMethodObject> drawMessagesForTheseObjectsAlt;
    private boolean useCustomColors = false;
    private Color customForeground;
    private Color customBackground;
    private int numUserEventRows = 1;
    boolean drawNestedUserEventRows = false;
    protected long minUserSupplied = 0L;
    protected long maxUserSupplied = 0L;
    private float scaleChangeFactor = (float)Math.pow(2.0, 0.5);
    private int selection1 = -1;
    private int selection2 = -1;
    private int highlight = -1;
    private boolean keepViewCentered = false;
    private Set<Object> highlightedObjects;
    private boolean traceMessagesBackOnHover;
    private boolean traceMessagesForwardOnHover;
    private boolean traceOIDOnHover;
    private boolean useCompactView;
    int colorSchemeForUserSupplied;

    protected boolean useMinimalView() {
        return this.useMinimalView;
    }

    public Data(MainHandler rh) {
        this.modificationHandler = rh;
        this.showPacks = false;
        this.showMsgs = true;
        this.showIdle = true;
        this.showUserEvents = true;
        this.peToLine = new LinkedList();
        this.messageStructures = new MessageStructures(this);
        this.hiddenEntryPoints = new TreeSet<Integer>();
        this.hiddenUserEvents = new TreeSet<Integer>();
        this.oldBT = -1L;
        this.oldET = -1L;
        this.processorUsage = null;
        this.entryUsageList = null;
        this.minMem = Integer.MAX_VALUE;
        this.maxMem = Integer.MIN_VALUE;
        this.minUserSupplied = Integer.MAX_VALUE;
        this.maxUserSupplied = Integer.MIN_VALUE;
        this.startTime = 0L;
        this.endTime = MainWindow.runObject[this.myRun].getTotalTime();
        this.drawMessagesForTheseObjects = new HashSet<EntryMethodObject>();
        this.drawMessagesForTheseObjectsAlt = new HashSet<EntryMethodObject>();
        this.allEntryMethodObjects = null;
        this.entries = new int[MainWindow.runObject[this.myRun].getNumUserEntries()];
        this.makeFrequencyMap(this.entries);
        this.makeFreqVector();
        this.entryColor = MainWindow.runObject[this.myRun].getEPColorMap();
        this.labelFont = new Font("SansSerif", 0, 12);
        this.axisFont = new Font("SansSerif", 0, 10);
        this.highlightedObjects = new HashSet<Object>();
        this.colorByMemoryUsage = false;
        this.colorByObjectId = false;
        this.colorByUserSupplied = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.customForeground = Color.white;
        this.customBackground = Color.black;
        this.skipIdleRegions = false;
        this.skipLoadingMessages = false;
        this.skipLoadingUserEvents = false;
        this.minEntryDuration = 0L;
        this.loadGlobalPEList();
    }

    protected void addProcessor(int pe) {
        System.out.println("Add processor " + pe);
        Integer p = pe;
        if (!this.peToLine.contains(p)) {
            this.peToLine.addLast(p);
            System.out.println("Add processor " + pe + " to peToLine size=" + this.peToLine.size());
            this.modificationHandler.notifyProcessorListHasChanged();
            this.storeRangeToPersistantStorage();
            this.displayMustBeRedrawn();
        }
    }

    private void storeRangeToPersistantStorage() {
        MainWindow.runObject[this.myRun].persistantRangeData.update(this.startTime(), this.endTime(), this.processorListOrdered());
    }

    public void setProcessorList(OrderedIntList processorList) {
        this.peToLine.clear();
        processorList.reset();
        int p = processorList.nextElement();
        Integer line = 0;
        while (p != -1) {
            Integer pe = p;
            this.peToLine.addLast(pe);
            Integer n = line;
            Integer n2 = line = Integer.valueOf(line + 1);
            if (processorList.hasMoreElements()) {
                p = processorList.nextElement();
                continue;
            }
            p = -1;
        }
    }

    private void loadGlobalPEList() {
        OrderedIntList processorList = MainWindow.runObject[this.myRun].getValidProcessorList().copyOf();
        this.setProcessorList(processorList);
    }

    private OrderedIntList processorListOrdered() {
        OrderedIntList processorList = new OrderedIntList();
        for (Integer pe : this.peToLine) {
            processorList.insert(pe);
        }
        return processorList;
    }

    protected void setFontSizes(int labelFontSize, int axisFontSize, boolean useBoldForLabel) {
        this.labelFont = useBoldForLabel ? new Font("SansSerif", 1, labelFontSize) : new Font("SansSerif", 0, labelFontSize);
        this.axisFont = new Font("SansSerif", 0, axisFontSize);
    }

    protected long startTime() {
        return this.startTime;
    }

    protected void createTLOArray(boolean useHelperThreads, Component rootWindow, boolean showProgress) {
        this.messageStructures.kill();
        if (this.startTime >= this.oldBT && this.endTime <= this.oldET) {
            Map<Integer, List<EntryMethodObject>> oldEntryMethodObjects = this.allEntryMethodObjects;
            Map<Integer, Set<UserEventObject>> oldUserEventObjects = this.allUserEventObjects;
            this.allEntryMethodObjects = new TreeMap<Integer, List<EntryMethodObject>>();
            this.allUserEventObjects = new TreeMap<Integer, Set<UserEventObject>>();
            for (Integer pe : this.peToLine) {
                if (!oldEntryMethodObjects.containsKey(pe)) continue;
                this.allEntryMethodObjects.put(pe, oldEntryMethodObjects.get(pe));
                this.allUserEventObjects.put(pe, oldUserEventObjects.get(pe));
                if (this.allEntryMethodObjects.containsKey(pe)) {
                    List<EntryMethodObject> objs = this.allEntryMethodObjects.get(pe);
                    Iterator<EntryMethodObject> iter = objs.iterator();
                    while (iter.hasNext()) {
                        EntryMethodObject obj = iter.next();
                        if (obj.getEndTime() >= this.startTime && obj.getBeginTime() <= this.endTime) continue;
                        iter.remove();
                    }
                }
                if (!this.allUserEventObjects.containsKey(pe)) continue;
                Iterator<UserEventObject> iter2 = this.allUserEventObjects.get(pe).iterator();
                while (iter2.hasNext()) {
                    UserEventObject obj = iter2.next();
                    if (obj.EndTime >= this.startTime && obj.BeginTime <= this.endTime) continue;
                    iter2.remove();
                }
            }
        } else {
            this.allEntryMethodObjects = new TreeMap<Integer, List<EntryMethodObject>>();
            this.allUserEventObjects = new TreeMap<Integer, Set<UserEventObject>>();
        }
        this.oldBT = this.startTime;
        this.oldET = this.endTime;
        LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
        Iterator peIter = this.peToLine.iterator();
        int pIdx = 0;
        while (peIter.hasNext()) {
            Integer pe;
            pe = (Integer)peIter.next();
            if (!this.allEntryMethodObjects.containsKey(pe)) {
                readyReaders.add(new ThreadedFileReader(pe, this));
            }
            ++pIdx;
        }
        Component guiRootForProgressBar = null;
        if (rootWindow != null && rootWindow.isVisible()) {
            guiRootForProgressBar = rootWindow;
        } else if (MainWindow.runObject[this.myRun].guiRoot != null && MainWindow.runObject[this.myRun].guiRoot.isVisible()) {
            guiRootForProgressBar = MainWindow.runObject[this.myRun].guiRoot;
        }
        TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Timeline in Parallel", readyReaders, guiRootForProgressBar, showProgress);
        threadManager.runAll();
        if (this.memoryUsageValid()) {
            System.out.println("memory usage seen in the logs ranges from : " + this.minMem / 1024L / 1024L + "MB to " + this.maxMem / 1024L / 1024L + "MB");
        }
        for (int e = 0; e < MainWindow.runObject[this.myRun].getNumUserEntries(); ++e) {
            this.entries[e] = 0;
        }
        this.processorUsage = new float[this.numPEs()];
        this.entryUsageList = new OrderedUsageList[this.numPEs()];
        float[] entryUsageArray = new float[MainWindow.runObject[this.myRun].getNumUserEntries()];
        this.idleUsage = new float[this.numPEs()];
        this.packUsage = new float[this.numPEs()];
        for (int i = 0; i < MainWindow.runObject[this.myRun].getNumUserEntries(); ++i) {
            entryUsageArray[i] = 0.0f;
        }
        for (int p = 0; p < this.numPEs(); ++p) {
            this.processorUsage[p] = 0.0f;
            this.idleUsage[p] = 0.0f;
            this.packUsage[p] = 0.0f;
        }
        for (Integer pe : this.allEntryMethodObjects.keySet()) {
            List<EntryMethodObject> objs = this.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                float usage = obj.getUsage();
                int entryIndex = obj.getEntryIndex();
                if (entryIndex >= 0) {
                    int n = entryIndex;
                    this.entries[n] = this.entries[n] + 1;
                    int n2 = pe;
                    this.processorUsage[n2] = this.processorUsage[n2] + usage;
                    int n3 = pe;
                    this.packUsage[n3] = this.packUsage[n3] + obj.getPackUsage();
                    int n4 = entryIndex;
                    entryUsageArray[n4] = entryUsageArray[n4] + obj.getNonPackUsage();
                    continue;
                }
                int n = pe;
                this.idleUsage[n] = this.idleUsage[n] + usage;
            }
            this.entryUsageList[pe.intValue()] = new OrderedUsageList();
            for (int i = 0; i < MainWindow.runObject[this.myRun].getNumUserEntries(); ++i) {
                if (!(entryUsageArray[i] > 0.0f)) continue;
                this.entryUsageList[pe].insert(entryUsageArray[i]);
            }
        }
        this.messageStructures.create(useHelperThreads);
        this.printNumLoadedObjects();
    }

    private void printNumLoadedObjects() {
        int objCount = 0;
        for (Integer pe : this.allEntryMethodObjects.keySet()) {
            List<EntryMethodObject> list = this.allEntryMethodObjects.get(pe);
            objCount += list.size();
        }
        System.out.println("Displaying " + objCount + " entry method objects in the timeline visualization\n");
    }

    protected void displayMustBeRedrawn() {
        if (this.modificationHandler != null) {
            this.modificationHandler.refreshDisplay(true);
        }
    }

    protected void displayMustBeRepainted() {
        if (this.modificationHandler != null) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    private void toggleMessageSendLine(EntryMethodObject obj) {
        TimelineMessage created_message = obj.creationMessage();
        if (created_message != null) {
            if (this.drawMessagesForTheseObjects.contains(obj)) {
                this.drawMessagesForTheseObjects.remove(obj);
            } else {
                this.drawMessagesForTheseObjects.add(obj);
            }
            this.displayMustBeRepainted();
        } else {
            this.modificationHandler.displayWarning("Message was sent from outside the current time range");
        }
    }

    protected void addMessageSendLineAlt(Set<EntryMethodObject> s) {
        this.drawMessagesForTheseObjectsAlt.addAll(s);
    }

    protected void addMessageSendLine(Set<EntryMethodObject> s) {
        this.drawMessagesForTheseObjects.addAll(s);
    }

    protected void clearMessageSendLines() {
        this.drawMessagesForTheseObjects.clear();
        this.drawMessagesForTheseObjectsAlt.clear();
    }

    protected long endTime() {
        return this.endTime;
    }

    protected Color[] entryColor() {
        return this.entryColor;
    }

    protected Color getEntryColor(Integer id) {
        return MainWindow.runObject[this.myRun].getEntryColor(id);
    }

    protected Color getUserEventColor(Integer id) {
        return MainWindow.runObject[this.myRun].getUserEventColor(id);
    }

    public Color getBackgroundColor() {
        if (this.useCustomColors) {
            return this.customBackground;
        }
        return MainWindow.runObject[this.myRun].background;
    }

    void getData(Integer pe) {
        if (pe >= MainWindow.runObject[this.myRun].getSts().getProcessorCount()) {
            String err = "Your sts file only specifies " + MainWindow.runObject[this.myRun].getSts().getProcessorCount() + " PEs, but you are trying somehow to load pe " + pe;
            throw new RuntimeException(err);
        }
        LinkedList<TimelineEvent> tl = new LinkedList<TimelineEvent>();
        TreeSet<UserEventObject> userEvents = new TreeSet<UserEventObject>();
        LinkedList<EntryMethodObject> perPEObjects = new LinkedList<EntryMethodObject>();
        try {
            if (!MainWindow.runObject[this.myRun].hasLogData()) {
                System.err.println("createTL: No log files available!");
                return;
            }
            MainWindow.runObject[this.myRun].logLoader.createtimeline(pe, this.startTime, this.endTime, tl, userEvents, this.minEntryDuration);
        }
        catch (LogLoadException e) {
            System.err.println("LOG LOAD EXCEPTION");
            return;
        }
        if (this.skipLoadingUserEvents()) {
            userEvents.clear();
        }
        this.getDataSyncSaveObjectLists(pe, perPEObjects, userEvents);
        long minMemThisPE = Long.MAX_VALUE;
        long maxMemThisPE = 0L;
        long minUserSuppliedThisPE = Long.MAX_VALUE;
        long maxUserSuppliedThisPE = 0L;
        for (TimelineEvent tle : tl) {
            Vector<PackTime> packlist;
            Vector<TimelineMessage> msglist = tle.MsgsSent;
            TreeSet<TimelineMessage> msgs = new TreeSet<TimelineMessage>();
            if (msglist != null && !this.skipLoadingMessages()) {
                msgs.addAll(msglist);
            }
            int numpacks = (packlist = tle.PackTimes) == null || this.skipLoadingMessages() ? 0 : packlist.size();
            PackTime[] packs = new PackTime[numpacks];
            for (int p = 0; p < numpacks; ++p) {
                packs[p] = packlist.elementAt(p);
            }
            EntryMethodObject obj = new EntryMethodObject(this, tle, msgs, packs, pe);
            if (!obj.isIdleEvent() && !obj.isUnaccountedTime() || !this.skipLoadingIdleRegions()) {
                perPEObjects.add(obj);
            }
            if (tle.memoryUsage != 0L) {
                if (tle.memoryUsage > maxMemThisPE) {
                    maxMemThisPE = tle.memoryUsage;
                }
                if (tle.memoryUsage < minMemThisPE) {
                    minMemThisPE = tle.memoryUsage;
                }
            }
            if (tle.UserSpecifiedData == null) continue;
            if ((long)tle.UserSpecifiedData.intValue() > maxUserSuppliedThisPE) {
                maxUserSuppliedThisPE = tle.UserSpecifiedData.intValue();
            }
            if ((long)tle.UserSpecifiedData.intValue() >= minUserSuppliedThisPE) continue;
            minUserSuppliedThisPE = tle.UserSpecifiedData.intValue();
        }
        this.getDataSyncSaveMemUsage(minMemThisPE, maxMemThisPE, minUserSuppliedThisPE, maxUserSuppliedThisPE);
    }

    private synchronized void getDataSyncSaveObjectLists(Integer pe, List<EntryMethodObject> perPEObjects, Set<UserEventObject> userEvents) {
        this.allUserEventObjects.put(pe, userEvents);
        this.allEntryMethodObjects.put(pe, perPEObjects);
    }

    private synchronized void getDataSyncSaveMemUsage(long minMemThisPE, long maxMemThisPE, long minUserSuppliedThisPE, long maxUserSuppliedThisPE) {
        if (minMemThisPE < this.minMem) {
            this.minMem = minMemThisPE;
        }
        if (maxMemThisPE > this.maxMem) {
            this.maxMem = maxMemThisPE;
        }
        if (minUserSuppliedThisPE < this.minUserSupplied) {
            this.minUserSupplied = minUserSuppliedThisPE;
        }
        if (maxUserSuppliedThisPE > this.maxUserSupplied) {
            this.maxUserSupplied = maxUserSuppliedThisPE;
        }
    }

    private boolean memoryUsageValid() {
        return this.maxMem != Integer.MIN_VALUE && this.minMem != Integer.MAX_VALUE && this.maxMem != 0L;
    }

    public Color getForegroundColor() {
        if (this.useCustomColors) {
            return this.customForeground;
        }
        return MainWindow.runObject[this.myRun].foreground;
    }

    public int getNumUserEvents() {
        Iterator<Set<UserEventObject>> iter = this.allUserEventObjects.values().iterator();
        int num = 0;
        while (iter.hasNext()) {
            num += iter.next().size();
        }
        return num;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    private float roundScale(float scl) {
        int i = (int)(scl + 0.5f);
        if ((double)Math.abs((float)i - scl) < 0.01) {
            return i;
        }
        return scl;
    }

    protected void increaseScaleFactor() {
        this.setScaleFactor(this.roundScale(this.getScaleFactor() * this.scaleChangeFactor));
    }

    protected void decreaseScaleFactor() {
        this.setScaleFactor(this.roundScale(this.getScaleFactor() / this.scaleChangeFactor));
    }

    protected int lineWidth(int actualDisplayWidth) {
        return actualDisplayWidth - 2 * this.offset();
    }

    protected int maxLabelLen() {
        return 70;
    }

    protected int numPs() {
        return this.peToLine.size();
    }

    protected int numPEs() {
        return MainWindow.runObject[this.myRun].getNumProcessors();
    }

    protected int offset() {
        if (this.useMinimalView()) {
            return this.maxLabelLen() / 2;
        }
        return 5 + this.maxLabelLen() / 2;
    }

    private int leftOffset() {
        return this.offset();
    }

    private int topOffset() {
        if (this.useMinimalView() || this.useCompactView()) {
            return 1;
        }
        return 4;
    }

    private int bottomOffset() {
        if (this.useMinimalView() || this.useCompactView()) {
            return 1;
        }
        return 4;
    }

    protected int scaledScreenWidth(int actualDisplayWidth) {
        this.mostRecentScaledScreenWidth = (int)((float)actualDisplayWidth * this.scaleFactor);
        return this.mostRecentScaledScreenWidth;
    }

    protected int screenHeight() {
        int paddingForScrollbar = 25;
        return this.singleTimelineHeight() * this.numPs() + paddingForScrollbar;
    }

    protected int barheight() {
        if (this.useCompactView()) {
            return 12;
        }
        return 16;
    }

    public int singleTimelineHeight() {
        return this.topOffset() + this.userEventRectHeight() + this.barheight() + this.messageSendHeight() + this.bottomOffset();
    }

    protected int userEventRectHeight() {
        if (this.useCompactView()) {
            return 0;
        }
        if (this.drawNestedUserEventRows) {
            return 12 * this.getNumUserEventRows();
        }
        return 8 * this.getNumUserEventRows();
    }

    public void setHandler(MainHandler rh) {
        this.modificationHandler = rh;
        this.displayMustBeRedrawn();
    }

    protected void setNewRange(long beginTime, long endTime) {
        this.startTime = beginTime;
        this.endTime = endTime;
        this.setScaleFactor(1.0f);
        this.storeRangeToPersistantStorage();
    }

    public void setRange(long beginTime, long endTime) {
        this.startTime = beginTime;
        this.endTime = endTime;
        this.storeRangeToPersistantStorage();
    }

    public void setScaleFactor(float scale_) {
        this.scaleFactor = scale_;
        if ((double)this.scaleFactor < 1.0) {
            this.scaleFactor = 1.0f;
        }
        this.displayMustBeRedrawn();
    }

    protected long totalTime() {
        return this.endTime - this.startTime;
    }

    protected boolean selectionValid() {
        return this.selection1 >= 0 && this.selection2 >= 0 && this.selection1 != this.selection2;
    }

    protected boolean highlightValid() {
        return this.highlight >= 0;
    }

    protected void invalidateSelection() {
        this.selection1 = -1;
        this.selection2 = -1;
        this.modificationHandler.refreshDisplay(false);
    }

    protected int leftSelection() {
        if (this.selection1 < this.selection2) {
            return this.selection1;
        }
        return this.selection2;
    }

    protected int rightSelection() {
        if (this.selection1 < this.selection2) {
            return this.selection2;
        }
        return this.selection1;
    }

    public void setSelection1(int value) {
        this.selection1 = value;
        if (this.selectionValid()) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void setSelection2(int value) {
        this.selection2 = value;
        if (this.selectionValid()) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    protected void removeHighlight() {
        this.highlight = -1;
        this.modificationHandler.refreshDisplay(false);
    }

    protected void setHighlight(int x) {
        this.highlight = x;
        this.modificationHandler.refreshDisplay(false);
    }

    protected int getHighlight() {
        return this.highlight;
    }

    protected double getHighlightTime() {
        return this.screenToTime(this.getHighlight());
    }

    protected double leftSelectionTime() {
        return this.screenToTime(this.leftSelection());
    }

    protected double rightSelectionTime() {
        return this.screenToTime(this.rightSelection());
    }

    private long screenToTime(int xPixelCoord) {
        double fractionAlongAxis = (double)(xPixelCoord - this.leftOffset()) / (double)(this.mostRecentScaledScreenWidth - 2 * this.offset());
        return Math.round((double)this.startTime + fractionAlongAxis * (double)(this.endTime - this.startTime));
    }

    protected int timeToScreenPixelRight(double time) {
        double fractionAlongTimeAxis = (time + 0.5 - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)Math.floor(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    protected int timeToScreenPixelLeft(double time) {
        double fractionAlongTimeAxis = (time - 0.5 - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)Math.ceil(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    protected int timeToScreenPixel(double time) {
        double fractionAlongTimeAxis = (time - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    protected int timeToScreenPixel(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    protected int timeToScreenPixelLeft(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time - 0.5 - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)Math.ceil(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    protected int timeToScreenPixelRight(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time + 0.5 - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)Math.floor(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public void setPreferredViewTimeCenter(double time) {
        if (time > (double)this.startTime && time < (double)this.endTime) {
            this.preferredViewTime = time;
        }
    }

    protected int getNewPreferredViewCenter(int newScreenWidth) {
        double value = this.preferredViewTime;
        int coord = this.timeToScreenPixel(value, newScreenWidth);
        return coord;
    }

    protected void resetPreferredView() {
        this.preferredViewTime = -1.0;
    }

    protected boolean hasNewPreferredView() {
        return this.preferredViewTime >= 0.0 && (double)this.scaleFactor > 1.0;
    }

    public void setUseMinimalMargins(boolean useMinimalMargins) {
        this.useMinimalView = useMinimalMargins;
    }

    protected void keepViewCentered(boolean b) {
        this.keepViewCentered = b;
    }

    protected boolean keepViewCentered() {
        return this.keepViewCentered;
    }

    protected int messageSendHeight() {
        if (this.useCompactView()) {
            return 0;
        }
        return 5;
    }

    protected int messagePackHeight() {
        return 3;
    }

    protected void clickTraceSender(EntryMethodObject obj) {
        if (!this.useMinimalView()) {
            this.addProcessor(obj.pCreation);
            this.toggleMessageSendLine(obj);
        }
    }

    protected void clearObjectHighlights() {
        this.highlightedObjects.clear();
    }

    protected void highlightObjects(Set<Object> objects) {
        this.highlightedObjects.addAll(objects);
    }

    protected boolean isObjectDimmed(Object o) {
        if (this.highlightedObjects.size() == 0) {
            return false;
        }
        return !this.highlightedObjects.contains(o);
    }

    protected boolean traceMessagesBackOnHover() {
        return this.traceMessagesBackOnHover;
    }

    protected boolean traceMessagesForwardOnHover() {
        return this.traceMessagesForwardOnHover;
    }

    protected boolean traceOIDOnHover() {
        return this.traceOIDOnHover;
    }

    public void setTraceMessagesBackOnHover(boolean traceMessagesOnHover) {
        this.traceMessagesBackOnHover = traceMessagesOnHover;
        if (traceMessagesOnHover) {
            this.setToolTipDelayLarge();
        } else {
            this.setToolTipDelaySmall();
        }
    }

    public void setTraceMessagesForwardOnHover(boolean traceMessagesForwardOnHover) {
        this.traceMessagesForwardOnHover = traceMessagesForwardOnHover;
        if (traceMessagesForwardOnHover) {
            this.setToolTipDelayLarge();
        } else {
            this.setToolTipDelaySmall();
        }
    }

    public void setTraceOIDOnHover(boolean showOIDOnHover) {
        this.traceOIDOnHover = showOIDOnHover;
    }

    protected void setToolTipDelaySmall() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(600000);
    }

    private void setToolTipDelayLarge() {
        ToolTipManager.sharedInstance().setInitialDelay(2000);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    public Color getMessageColor() {
        return this.getForegroundColor();
    }

    public Color getMessageAltColor() {
        return Color.yellow;
    }

    protected void showUserEvents(boolean b) {
        this.showUserEvents = b;
    }

    protected boolean showUserEvents() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showUserEvents;
    }

    protected void setColorByDefault() {
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByUserSupplied = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    public void setColorForEntry(int id, Color c) {
        if (c != null) {
            MainWindow.runObject[this.myRun].setEntryColor(id, c);
            this.displayMustBeRepainted();
        }
    }

    protected void setColorByMemoryUsage() {
        if (this.memoryUsageValid()) {
            new MemoryColorRangeChooser(this);
        } else {
            this.modificationHandler.displayWarning("No memory usage entries found. Use traceMemoryUsage() in the application");
        }
    }

    protected void finalizeColorByMemoryUsage() {
        this.colorByMemoryUsage = true;
        this.colorByObjectId = false;
        this.colorByUserSupplied = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    public void setColorByUserSupplied(int colorScheme) {
        this.colorSchemeForUserSupplied = colorScheme;
        this.colorByUserSupplied = true;
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    protected void setColorByObjectID() {
        this.colorByObjectId = true;
        this.colorByMemoryUsage = false;
        this.colorByUserSupplied = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    public void setColorByUserSuppliedAndObjID(int colorScheme) {
        this.colorSchemeForUserSupplied = colorScheme;
        this.colorByUserSupplied = true;
        this.colorByObjectId = true;
        this.colorByMemoryUsage = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    public void setColorByUserSuppliedAndEID(int colorScheme) {
        this.colorSchemeForUserSupplied = colorScheme;
        this.colorByUserSupplied = true;
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByEntryId = true;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    public void setColorByEID() {
        this.colorByUserSupplied = false;
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByEntryId = true;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    public void setColorByEIDFreq() {
        this.colorByUserSupplied = false;
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = true;
        this.displayMustBeRepainted();
    }

    protected boolean colorByEID() {
        return this.colorByEntryId;
    }

    protected boolean colorByEIDFreq() {
        return this.colorByEntryIdFreq;
    }

    protected boolean colorByOID() {
        return this.colorByObjectId;
    }

    protected boolean colorByUserSupplied() {
        return this.colorByUserSupplied;
    }

    protected boolean colorByMemoryUsage() {
        return this.colorByMemoryUsage;
    }

    protected void fixTachyons() {
        System.out.println("The fix tachyons feature is still experimental. It will probably not work well if new processors are loaded, or ranges are changed");
        int numIterations = 100;
        long threshold_us = 10L;
        System.out.println("Executing at most " + numIterations + " times or until no tachyons longer than " + threshold_us + "us are found");
        for (int iteration = 0; iteration < numIterations; ++iteration) {
            long minLatency = Integer.MAX_VALUE;
            int minDest = -1;
            for (Integer pe : this.allEntryMethodObjects.keySet()) {
                List<EntryMethodObject> objs = this.allEntryMethodObjects.get(pe);
                for (EntryMethodObject obj : objs) {
                    TimelineMessage m = obj.creationMessage();
                    if (m == null) continue;
                    long sendTime = m.Time;
                    long executeTime = obj.getBeginTime();
                    long latency = executeTime - sendTime;
                    int executingPE = obj.pCurrent;
                    if (minLatency <= latency) continue;
                    minLatency = latency;
                    minDest = executingPE;
                }
            }
            System.out.println("Processor " + minDest + " is lagging behind by " + -1L * minLatency + "us");
            Integer laggingPE = minDest;
            long shift = -1L * minLatency;
            if (shift < threshold_us) {
                System.out.println("No tachyons go back further than " + threshold_us + " us");
                break;
            }
            for (EntryMethodObject e : this.allEntryMethodObjects.get(laggingPE)) {
                e.shiftTimesBy(shift);
                for (TimelineMessage msg : e.messages) {
                    msg.shiftTimesBy(shift);
                }
            }
            for (UserEventObject u : this.allUserEventObjects.get(laggingPE)) {
                u.shiftTimesBy(shift);
            }
        }
        this.displayMustBeRedrawn();
    }

    public void setCompactView(boolean b) {
        this.useCompactView = b;
        this.displayMustBeRedrawn();
    }

    protected boolean showPacks() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showPacks;
    }

    protected boolean showMsgs() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showMsgs;
    }

    protected boolean showIdle() {
        return this.showIdle;
    }

    protected void showIdle(boolean b) {
        this.showIdle = b;
    }

    protected void showPacks(boolean b) {
        this.showPacks = b;
    }

    protected void showMsgs(boolean b) {
        this.showMsgs = b;
    }

    protected boolean useCompactView() {
        return this.useCompactView;
    }

    private int whichTimelineVerticalPosition(int PE) {
        if (this.peToLine == null) {
            throw new RuntimeException("peToLine is null");
        }
        if (!this.peToLine.contains(PE)) {
            throw new RuntimeException("peToLine does not contain pe " + PE);
        }
        return this.peToLine.indexOf(PE);
    }

    protected int whichPE(int verticalPosition) {
        Integer which = this.peToLine.get(verticalPosition);
        return which;
    }

    protected void movePEToLine(int PE, int newPos) {
        Integer p = PE;
        this.peToLine.remove(p);
        this.peToLine.add(newPos, p);
        this.displayMustBeRedrawn();
    }

    public void setBackgroundColor(Color c) {
        this.customBackground = c;
        this.useCustomColors = true;
        this.displayMustBeRedrawn();
    }

    public void setForegroundColor(Color c) {
        this.customForeground = c;
        this.useCustomColors = true;
        this.displayMustBeRedrawn();
    }

    public void setColors(Color backgroundColor, Color foregroundColor) {
        this.setBackgroundColor(backgroundColor);
        this.setForegroundColor(foregroundColor);
    }

    protected void printUserEventInfo() {
        System.out.println("printUserEventInfo()");
        HashMap<Integer, Long> min = new HashMap<Integer, Long>();
        HashMap<Integer, Long> max = new HashMap<Integer, Long>();
        HashMap<Integer, Long> total = new HashMap<Integer, Long>();
        HashMap<Integer, Long> count = new HashMap<Integer, Long>();
        HashMap<Integer, String> name = new HashMap<Integer, String>();
        for (Integer pe : this.allUserEventObjects.keySet()) {
            for (UserEventObject obj : this.allUserEventObjects.get(pe)) {
                if (obj.Type != 2) continue;
                long BeginTime = obj.BeginTime;
                long EndTime = obj.EndTime;
                Integer UserEventID = obj.UserEventID;
                long duration = EndTime - BeginTime;
                if (!min.containsKey(UserEventID)) {
                    min.put(UserEventID, new Long(duration));
                    max.put(UserEventID, new Long(duration));
                    total.put(UserEventID, new Long(duration));
                    count.put(UserEventID, new Long(1L));
                    name.put(UserEventID, obj.getName());
                    continue;
                }
                if ((Long)min.get(UserEventID) > duration) {
                    min.put(UserEventID, duration);
                }
                if ((Long)max.get(UserEventID) < duration) {
                    max.put(UserEventID, duration);
                }
                total.put(UserEventID, (Long)total.get(UserEventID) + Long.valueOf(duration));
                count.put(UserEventID, (Long)count.get(UserEventID) + Long.valueOf(1L));
            }
        }
        for (Integer UserEventID : min.keySet()) {
            double avg = ((Long)total.get(UserEventID)).doubleValue() / ((Long)count.get(UserEventID)).doubleValue();
            System.out.print("User Event #" + UserEventID + "  \"" + (String)name.get(UserEventID) + "\"");
            System.out.print("    count = " + count.get(UserEventID));
            System.out.print("    min   = " + min.get(UserEventID) + " us");
            System.out.print("    max   = " + max.get(UserEventID) + " us");
            System.out.print("    avg   = " + avg + " us");
            System.out.print("    total = " + total.get(UserEventID) + " us");
            System.out.println();
        }
    }

    private int determineUserEventNestings() {
        int maxDepth = 0;
        for (Integer pe : this.allUserEventObjects.keySet()) {
            Stack<Long> activeEndTimes = new Stack<Long>();
            for (UserEventObject obj : this.allUserEventObjects.get(pe)) {
                if (obj.Type != 2) continue;
                long BeginTime = obj.BeginTime;
                long EndTime = obj.EndTime;
                while (activeEndTimes.size() > 0 && (Long)activeEndTimes.peek() <= BeginTime) {
                    activeEndTimes.pop();
                }
                activeEndTimes.push(EndTime);
                obj.setNestedRow(activeEndTimes.size() - 1);
                if (activeEndTimes.size() <= maxDepth) continue;
                maxDepth = activeEndTimes.size();
            }
        }
        return maxDepth;
    }

    protected void showNestedUserEvents(boolean b) {
        this.drawNestedUserEventRows = b;
        if (b) {
            this.setNumUserEventRows(this.determineUserEventNestings());
        } else {
            this.setNumUserEventRows(1);
        }
        this.displayMustBeRedrawn();
    }

    public void setNumUserEventRows(int numUserEventRows) {
        this.numUserEventRows = numUserEventRows;
    }

    public int getNumUserEventRows() {
        return this.numUserEventRows;
    }

    protected int entryMethodLocationTop(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset() + this.userEventRectHeight();
    }

    protected int entryMethodLocationHeight() {
        return this.barheight() + this.messageSendHeight();
    }

    private int userEventLocationTop(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset();
    }

    protected int userEventLocationBottom(int pe) {
        return this.userEventLocationTop(pe) + this.userEventRectHeight();
    }

    protected int horizontalLineLocationTop(int i) {
        return this.singleTimelineHeight() * i + this.topOffset() + this.userEventRectHeight() + this.barheight() / 2;
    }

    protected int messageSendLocationY(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset() + this.userEventRectHeight() + this.barheight() + this.messageSendHeight();
    }

    protected int messageRecvLocationY(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset() + this.userEventRectHeight();
    }

    protected void dropPEsUnrelatedToPE(Integer pe) {
        this.dropPEsUnrelatedToObjects((Collection<EntryMethodObject>)this.allEntryMethodObjects.get(pe));
    }

    protected void dropPEsUnrelatedToObject(EntryMethodObject obj) {
        System.out.println("dropPEsUnrelatedToObject()");
        HashSet<EntryMethodObject> set = new HashSet<EntryMethodObject>();
        set.add(obj);
        this.dropPEsUnrelatedToObjects(set);
    }

    private void dropPEsUnrelatedToObjects(Collection<EntryMethodObject> objs) {
        System.out.println("dropPEsUnrelatedToObjects()");
        HashSet<EntryMethodObject> allRelatedEntries = new HashSet<EntryMethodObject>();
        for (EntryMethodObject obj : objs) {
            allRelatedEntries.add(obj);
            allRelatedEntries.addAll(obj.traceForwardDependencies());
            allRelatedEntries.addAll(obj.traceBackwardDependencies());
        }
        HashSet<Integer> relatedPEs = new HashSet<Integer>();
        for (EntryMethodObject o : allRelatedEntries) {
            relatedPEs.add(o.pCurrent);
        }
        this.dropPEsNotInList(relatedPEs);
    }

    private void dropPEsNotInList(Set<Integer> keepPEs) {
        HashSet<Integer> currentPEs = new HashSet<Integer>();
        currentPEs.addAll(this.peToLine);
        for (Integer p : currentPEs) {
            if (keepPEs.contains(p)) continue;
            this.peToLine.remove(p);
        }
        this.modificationHandler.notifyProcessorListHasChanged();
        this.displayMustBeRedrawn();
    }

    public Map<Integer, String> getEntryNames() {
        return MainWindow.runObject[this.myRun].getSts().getPrettyEntryNames();
    }

    public Map<Integer, String> getUserEventNames() {
        return MainWindow.runObject[this.myRun].getSts().getUserEventNameMap();
    }

    protected void makeEntryVisibleID(Integer id) {
        this.makeEntryVisibleID(id, true);
    }

    protected void makeEntryInvisibleID(Integer id) {
        this.makeEntryInvisibleID(id, true);
    }

    protected void makeEntryVisibleID(Integer id, boolean redraw) {
        this.hiddenEntryPoints.remove(id);
        if (redraw) {
            this.displayMustBeRedrawn();
        }
    }

    protected void makeEntryInvisibleID(Integer id, boolean redraw) {
        this.hiddenEntryPoints.add(id);
        if (redraw) {
            this.displayMustBeRedrawn();
        }
    }

    protected void makeUserEventVisibleID(Integer id) {
        this.hiddenUserEvents.remove(id);
        this.displayMustBeRedrawn();
    }

    protected void makeUserEventInvisibleID(Integer id) {
        this.hiddenUserEvents.add(id);
        this.displayMustBeRedrawn();
    }

    protected void makeUserSuppliedNotesVisible() {
        this.hideUserSuppliedNotes = false;
        this.displayMustBeRedrawn();
    }

    protected void makeUserSuppliedNotesInvisible() {
        this.hideUserSuppliedNotes = true;
        this.displayMustBeRedrawn();
    }

    protected boolean userSuppliedNotesHidden() {
        return this.hideUserSuppliedNotes;
    }

    protected boolean entryIsHiddenID(Integer id) {
        return this.hiddenEntryPoints.contains(id);
    }

    protected boolean entryIsVisibleID(Integer id) {
        return !this.hiddenEntryPoints.contains(id);
    }

    protected boolean userEventIsHiddenID(Integer id) {
        return this.hiddenUserEvents.contains(id);
    }

    protected void skipLoadingIdleRegions(boolean b, boolean filterAlreadyLoaded) {
        this.skipIdleRegions = b;
        if (this.skipIdleRegions && filterAlreadyLoaded) {
            this.pruneOutIdleRegions();
        }
    }

    protected void skipLoadingMessages(boolean b, boolean filterAlreadyLoaded) {
        this.skipLoadingMessages = b;
        if (this.skipLoadingMessages && filterAlreadyLoaded) {
            this.pruneOutMessages();
        }
    }

    protected void skipLoadingUserEvents(boolean b) {
        this.skipLoadingUserEvents = b;
    }

    private boolean skipLoadingUserEvents() {
        return this.skipLoadingUserEvents;
    }

    private void pruneOutIdleRegions() {
        System.out.println("pruneOutIdleRegions");
        for (Integer pe : this.allEntryMethodObjects.keySet()) {
            List<EntryMethodObject> list = this.allEntryMethodObjects.get(pe);
            Iterator<EntryMethodObject> iter2 = list.iterator();
            while (iter2.hasNext()) {
                EntryMethodObject o = iter2.next();
                if (!o.isIdleEvent()) continue;
                iter2.remove();
            }
        }
        this.modificationHandler.notifyProcessorListHasChanged();
        this.displayMustBeRedrawn();
    }

    private void pruneOutMessages() {
        System.out.println("pruneOutMessages");
        for (Integer pe : this.allEntryMethodObjects.keySet()) {
            List<EntryMethodObject> list = this.allEntryMethodObjects.get(pe);
            for (EntryMethodObject o : list) {
                o.messages = new TreeSet<TimelineMessage>();
            }
        }
        this.messageStructures.clearAll();
        this.clearMessageSendLines();
        this.modificationHandler.notifyProcessorListHasChanged();
        this.displayMustBeRedrawn();
    }

    private boolean skipLoadingIdleRegions() {
        return this.skipIdleRegions;
    }

    private boolean skipLoadingMessages() {
        return this.skipLoadingMessages;
    }

    protected long minMemMB() {
        return this.minMem / 1024L / 1024L;
    }

    protected long maxMemMB() {
        return this.maxMem / 1024L / 1024L;
    }

    protected long minMemBColorRange() {
        return this.minMemColorRange;
    }

    protected long maxMemBColorRange() {
        return this.maxMemColorRange;
    }

    protected void setMemColorRange(long minMemVal, long maxMemVal) {
        this.minMemColorRange = minMemVal;
        this.maxMemColorRange = maxMemVal;
    }

    protected void setFilterEntryShorterThan(long l) {
        this.minEntryDuration = l;
    }

    protected void displayLegend() {
        if (this.memoryUsageValid()) {
            new MemoryLegend(this);
        }
    }

    public void finalize() throws Throwable {
        this.disposeOfStructures();
        super.finalize();
    }

    public void disposeOfStructures() {
        this.entries = null;
        this.entryColor = null;
        this.hiddenEntryPoints = null;
        this.allEntryMethodObjects = null;
        this.allUserEventObjects = null;
        this.processorUsage = null;
        this.packUsage = null;
        this.entryUsageList = null;
        this.messageStructures = null;
        this.drawMessagesForTheseObjects = null;
        this.drawMessagesForTheseObjectsAlt = null;
    }

    public void makeFrequencyMap(int[] frequencyOfEntries) {
        TreeMap mapToReturn = new TreeMap();
        for (int i = 0; i < frequencyOfEntries.length; ++i) {
            if (mapToReturn.containsKey(this.entries[i])) {
                ((LinkedList)mapToReturn.get(this.entries[i])).add(i);
                continue;
            }
            LinkedList<Integer> ll = new LinkedList<Integer>();
            ll.add(i);
            mapToReturn.put(this.entries[i], ll);
        }
        this.frequencyTreeMap = mapToReturn;
    }

    public void makeFreqVector() {
        Vector<Integer> vectorToReturn = new Vector<Integer>();
        Collection<LinkedList<Integer>> collec = this.frequencyTreeMap.values();
        for (LinkedList<Integer> tempLinkedL : collec) {
            for (int i = 0; i < tempLinkedL.size(); ++i) {
                vectorToReturn.add(0, tempLinkedL.get(i));
            }
        }
        this.frequencyVector = vectorToReturn;
    }

    public void setFrequencyColors() {
        Analysis a = MainWindow.runObject[this.myRun];
        a.activityColors = a.colorManager.defaultColorMap();
        a.entryColors = ColorManager.entryColorsByFrequency(ColorManager.createComplementaryColorMap(this.entries.length), this.frequencyVector);
        a.userEventColors = a.activityColors[1];
        a.functionColors = a.activityColors[2];
    }
}

