/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.MessageStructures;
import projections.Tools.Timeline.MessageWindow;
import projections.Tools.Timeline.TimelineMessage;
import projections.analysis.AmpiFunctionData;
import projections.analysis.ObjectId;
import projections.analysis.PackTime;
import projections.analysis.TimelineEvent;
import projections.gui.MainWindow;
import projections.gui.U;
import projections.misc.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntryMethodObject
extends JComponent
implements Comparable,
MouseListener,
ActionListener {
    private MessageWindow msgwindow;
    private long beginTime;
    private long endTime;
    private long recvTime;
    private long cpuTime;
    private long cpuBegin;
    private long cpuEnd;
    private int entry;
    private int entryIndex;
    private int msglen;
    int EventID;
    private ObjectId tid;
    int pCurrent;
    int pCreation;
    private static final String popupChangeColor = "Change Entry Point Color";
    private static final String popupShowDetails = "Show details";
    private static final String popupTraceSender = "Trace message to sender";
    private static final String popupDropPEsForObject = "Drop all PEs unrelated to this entry method";
    private static final String popupDropPEsForPE = "Drop all PEs unrelated to entry methods on this PE";
    Integer userSuppliedData;
    private long memoryUsage;
    private double usage;
    private float packusage;
    private long packtime;
    private int leftCoord = 0;
    private int rightCoord = 0;
    private String tleUserEventName;
    private Data data = null;
    protected Set<TimelineMessage> messages;
    private PackTime[] packs;
    private int numPapiCounts = 0;
    private long[] papiCounts;
    private boolean isFunction = false;
    private static DecimalFormat format_ = new DecimalFormat();
    private AmpiFunctionData[] funcData;

    protected EntryMethodObject(Data data, TimelineEvent tle, TreeSet<TimelineMessage> msgs, PackTime[] packs, int p1) {
        this.setFocusable(false);
        this.setVisible(true);
        this.setOpaque(false);
        this.setBackground(MainWindow.runObject[data.myRun].background);
        this.setForeground(MainWindow.runObject[data.myRun].foreground);
        this.data = data;
        this.beginTime = tle.BeginTime;
        this.endTime = tle.EndTime;
        this.cpuBegin = tle.cpuBegin;
        this.cpuEnd = tle.cpuEnd;
        this.cpuTime = this.cpuEnd - this.cpuBegin;
        this.entry = tle.EntryPoint;
        this.entryIndex = MainWindow.runObject[data.myRun].getEntryIndex(this.entry);
        this.messages = msgs;
        this.packs = packs;
        this.pCurrent = p1;
        this.pCreation = tle.SrcPe;
        this.EventID = tle.EventID;
        this.msglen = tle.MsgLen;
        this.recvTime = tle.RecvTime;
        this.tid = tle.id != null ? new ObjectId(tle.id) : new ObjectId();
        this.userSuppliedData = tle.UserSpecifiedData;
        this.memoryUsage = tle.memoryUsage;
        this.tleUserEventName = tle.userEventName;
        this.numPapiCounts = tle.numPapiCounts;
        this.papiCounts = tle.papiCounts;
        this.isFunction = tle.isFunction;
        format_.setGroupingUsed(true);
        this.setUsage();
        this.setPackUsage();
        if (this.isFunction) {
            this.funcData = new AmpiFunctionData[tle.callStack.size()];
            tle.callStack.copyInto(this.funcData);
        } else if (tle.EntryPoint >= 0) {
            // empty if block
        }
        if (!this.isIdleEvent()) {
            this.addMouseListener(this);
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        StringBuilder infoString = new StringBuilder(5000);
        if (this.isFunction) {
            infoString.append("<i>Function</i>: " + MainWindow.runObject[this.data.myRun].getFunctionName(this.entry) + "<br>");
            infoString.append("<i>Begin Time</i>: " + format_.format(this.beginTime) + "<br>");
            infoString.append("<i>End Time</i>: " + format_.format(this.endTime) + "<br>");
            infoString.append("<i>Total Time</i>: " + U.humanReadableString(this.endTime - this.beginTime) + "<br>");
            infoString.append("<i>Msgs created</i>: " + this.messages.size() + "<br>");
            infoString.append("<i>Id</i>: " + this.tid.id[0] + ":" + this.tid.id[1] + ":" + this.tid.id[2] + "<br>");
            infoString.append("<hr><br><i>Function Callstack</i>:<br>");
            for (int i = 0; i < this.funcData.length; ++i) {
                AmpiFunctionData functionData = this.funcData[i];
                infoString.append("<i>[Func]</i>: " + MainWindow.runObject[this.data.myRun].getFunctionName(functionData.FunctionID) + "<br>");
                infoString.append("&nbsp&nbps&nbsp&nbps<i>line</i>:" + functionData.LineNo + " <i>file</i>: " + functionData.sourceFileName + "<br>");
            }
        } else if (this.entry >= 0) {
            infoString.append("<b>" + MainWindow.runObject[this.data.myRun].getEntryFullNameByID(this.entry, true) + "</b><br><br>");
            if (this.msglen > 0) {
                infoString.append("<i>Msg Len</i>: " + this.msglen + "<br>");
            }
            infoString.append("<i>Begin Time</i>: " + format_.format(this.beginTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + format_.format(this.cpuBegin) + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>End Time</i>: " + format_.format(this.endTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + format_.format(this.cpuEnd) + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>Total Time</i>: " + U.humanReadableString(this.endTime - this.beginTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + U.humanReadableString(this.cpuTime) + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>Packing</i>: " + U.humanReadableString(this.packtime));
            if (this.packtime > 0L) {
                infoString.append(" (" + 100.0f * (float)this.packtime / (float)(this.endTime - this.beginTime + 1L) + "%)");
            }
            infoString.append("<br>");
            infoString.append("<i>Msgs created</i>: " + this.messages.size() + "<br>");
            infoString.append("<i>Created by processor</i>: " + this.pCreation + "<br>");
            infoString.append("<i>Id</i>: " + this.tid.id[0] + ":" + this.tid.id[1] + ":" + this.tid.id[2] + "<br>");
            if (this.tleUserEventName != null) {
                infoString.append("<i>Associated User Event</i>: " + this.tleUserEventName + "<br>");
            }
            if (this.recvTime > 0L) {
                infoString.append("<i>Recv Time</i>: " + this.recvTime + "<br>");
            }
            if (this.numPapiCounts > 0) {
                infoString.append("<i>*** PAPI counts ***</i><br>");
                for (int i = 0; i < this.numPapiCounts; ++i) {
                    infoString.append(MainWindow.runObject[this.data.myRun].getPerfCountNames()[i] + " = " + format_.format(this.papiCounts[i]) + "<br>");
                }
            }
        } else if (this.entry == -1) {
            infoString.append("<b>Idle Time</b><br><br>");
            infoString.append("<i>Begin Time</i>: " + format_.format(this.beginTime) + "<br>");
            infoString.append("<i>End Time</i>: " + format_.format(this.endTime) + "<br>");
            infoString.append("<i>Total Time</i>: " + U.humanReadableString(this.endTime - this.beginTime) + "<br>");
        } else if (this.entry == -2) {
            infoString.append("<i>Unaccounted Time</i><br>");
            infoString.append("<i>Begin Time</i>: " + format_.format(this.beginTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + format_.format(this.cpuBegin) + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>End Time</i>: " + format_.format(this.endTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + format_.format(this.cpuEnd) + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>Total Time</i>: " + U.humanReadableString(this.endTime - this.beginTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + this.cpuTime + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>Packing</i>: " + U.humanReadableString(this.packtime));
            if (this.packtime > 0L) {
                infoString.append(" (" + 100.0f * (float)this.packtime / (float)(this.endTime - this.beginTime + 1L) + "%)");
            }
            infoString.append("<br>");
            infoString.append("<i>Num Msgs created</i>: " + this.messages.size() + "<br>");
        }
        if (this.userSuppliedData != null) {
            infoString.append("<i>User Supplied Parameter(timestep):</i> " + this.userSuppliedData + "<br>");
        }
        if (this.memoryUsage != 0L) {
            infoString.append("<i>Memory Usage:</i> " + this.memoryUsage / 1024L / 1024L + " MB<br>");
        }
        return "<html><body>" + infoString.toString() + "</html></body>";
    }

    private void drawLeftArrow(Graphics2D g, Paint c, int startY, int h) {
        int[] xpts = new int[]{5, 0, 5};
        int[] ypts = new int[]{startY, startY + h / 2, startY + h - 1};
        g.setPaint(c);
        g.fillPolygon(xpts, ypts, 3);
        g.setPaint(this.makeMoreLikeForeground(c));
        g.drawLine(xpts[0], ypts[0], xpts[1], ypts[1]);
        g.setPaint(this.makeMoreLikeBackground(c));
        g.drawLine(xpts[1], ypts[1], xpts[2], ypts[2]);
    }

    private void drawRightArrow(Graphics2D g, Paint c, int startY, int h, int right) {
        int[] xpts = new int[]{right - 6, right, right - 6};
        int[] ypts = new int[]{startY, startY + h / 2, startY + h - 1};
        g.setPaint(c);
        g.fillPolygon(xpts, ypts, 3);
        g.setPaint(this.makeMoreLikeForeground(c));
        g.drawLine(xpts[0], ypts[0], xpts[1], ypts[1]);
        g.setPaint(this.makeMoreLikeBackground(c));
        g.drawLine(xpts[1], ypts[1], xpts[2], ypts[2]);
    }

    private Paint makeMoreLikeBackground(Paint c) {
        Color other = this.getBackground();
        if (c instanceof Color) {
            return this.mixColors((Color)c, other, 0.8f);
        }
        return c;
    }

    private Paint makeMoreLikeForeground(Paint c) {
        Color other = this.getForeground();
        if (c instanceof Color) {
            return this.mixColors((Color)c, other, 0.8f);
        }
        return c;
    }

    private Color mixColors(Color a, Color b, float ratio) {
        float red = (float)((double)(ratio * (float)a.getRed()) + (1.0 - (double)ratio) * (double)b.getRed());
        float green = (float)((double)(ratio * (float)a.getGreen()) + (1.0 - (double)ratio) * (double)b.getGreen());
        float blue = (float)((double)(ratio * (float)a.getBlue()) + (1.0 - (double)ratio) * (double)b.getBlue());
        return new Color(red / 256.0f, green / 256.0f, blue / 256.0f);
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getEntryID() {
        return this.entry;
    }

    public int getEntryIndex() {
        return MainWindow.runObject[this.data.myRun].getEntryIndex(this.entry);
    }

    public Set<TimelineMessage> getMessages() {
        return this.messages;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.getSize().width, this.getSize().height);
    }

    public float getNonPackUsage() {
        return (float)this.usage - this.packusage;
    }

    public int getNumMsgs() {
        if (this.messages == null) {
            return 0;
        }
        return this.messages.size();
    }

    public float getPackUsage() {
        return this.packusage;
    }

    public int getPCreation() {
        return this.pCreation;
    }

    public int getPCurrent() {
        return this.pCurrent;
    }

    public float getUsage() {
        return (float)this.usage;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (this.entry >= 0) {
            if (evt.getModifiers() == 16) {
                this.data.clickTraceSender(this);
            } else {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem menuItem = new JMenuItem(popupShowDetails);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                menuItem = new JMenuItem(popupTraceSender);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                menuItem = new JMenuItem(popupChangeColor);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                menuItem = new JMenuItem(popupDropPEsForObject);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                menuItem = new JMenuItem(popupDropPEsForPE);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                popup.show(this, evt.getX(), evt.getY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<EntryMethodObject> traceBackwardDependencies() {
        MessageStructures messageStructures = this.data.messageStructures;
        synchronized (messageStructures) {
            HashSet<EntryMethodObject> v = new HashSet<EntryMethodObject>();
            if (this.data.traceMessagesBackOnHover()) {
                EntryMethodObject obj = this;
                boolean done = false;
                while (!done) {
                    TimelineMessage created_message;
                    done = true;
                    v.add(obj);
                    if (obj.entry == -1 || obj.pCreation > this.data.numPEs() || (created_message = obj.creationMessage()) == null || (obj = this.data.messageStructures.getMessageToSendingObjectsMap().get(created_message)) == null) continue;
                    done = false;
                }
            }
            return v;
        }
    }

    protected Set<EntryMethodObject> traceForwardDependencies() {
        HashSet<EntryMethodObject> v = new HashSet<EntryMethodObject>();
        LinkedList<EntryMethodObject> toExamine = new LinkedList<EntryMethodObject>();
        toExamine.add(this);
        while (toExamine.size() > 0) {
            EntryMethodObject current = (EntryMethodObject)toExamine.poll();
            v.add(current);
            for (Integer pe : this.data.allEntryMethodObjects.keySet()) {
                List<EntryMethodObject> entryMethods = this.data.allEntryMethodObjects.get(pe);
                for (EntryMethodObject obj : entryMethods) {
                    TimelineMessage m = obj.creationMessage();
                    if (m == null || !current.messages.contains(m)) continue;
                    toExamine.add(obj);
                }
            }
            if (this.data.traceMessagesForwardOnHover()) continue;
            break;
        }
        v.remove(this);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimelineMessage creationMessage() {
        MessageStructures messageStructures = this.data.messageStructures;
        synchronized (messageStructures) {
            if (this.data == null) {
                return null;
            }
            if (this.pCreation < 0) {
                return null;
            }
            if (this.data.messageStructures.getEventIDToMessageMap() == null) {
                return null;
            }
            if (this.pCreation >= this.data.messageStructures.getEventIDToMessageMap().length) {
                return null;
            }
            if (this.data.messageStructures.getEventIDToMessageMap()[this.pCreation] == null) {
                return null;
            }
            return (TimelineMessage)this.data.messageStructures.getEventIDToMessageMap()[this.pCreation].get(this.EventID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseEntered(MouseEvent evt) {
        boolean needRepaint = false;
        if (this.data.traceMessagesBackOnHover() || this.data.traceMessagesForwardOnHover()) {
            Set<EntryMethodObject> fwd = this.traceForwardDependencies();
            Set<EntryMethodObject> back = this.traceBackwardDependencies();
            HashSet<Object> fwdGeneric = new HashSet<Object>();
            HashSet<Object> backGeneric = new HashSet<Object>();
            fwdGeneric.addAll(fwd);
            backGeneric.addAll(back);
            this.data.clearMessageSendLines();
            this.data.addMessageSendLine(back);
            this.data.addMessageSendLineAlt(fwd);
            this.data.highlightObjects(fwdGeneric);
            this.data.highlightObjects(backGeneric);
            needRepaint = true;
        }
        if (this.data.traceOIDOnHover()) {
            MessageStructures messageStructures = this.data.messageStructures;
            synchronized (messageStructures) {
                Set allWithSameId = (Set)this.data.messageStructures.getOidToEntryMethodObjectsMap().get(this.tid);
                this.data.highlightObjects(allWithSameId);
                needRepaint = true;
            }
        }
        if (needRepaint) {
            this.data.displayMustBeRepainted();
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        boolean needRepaint = false;
        if (this.data.traceMessagesBackOnHover() || this.data.traceMessagesForwardOnHover()) {
            this.data.clearObjectHighlights();
            this.data.clearMessageSendLines();
            needRepaint = true;
        }
        if (this.data.traceOIDOnHover()) {
            this.data.clearObjectHighlights();
            needRepaint = true;
        }
        if (needRepaint) {
            this.data.displayMustBeRepainted();
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    private void OpenMessageWindow() {
        if (this.msgwindow == null) {
            this.msgwindow = new MessageWindow(this);
            Dimension d = this.msgwindow.getPreferredSize();
            this.msgwindow.setSize(480, d.width);
        }
        this.msgwindow.setVisible(true);
    }

    public boolean isIdleEvent() {
        return this.entry == -1;
    }

    public boolean isUnaccountedTime() {
        return this.entry == -2;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.isIdleEvent() && !this.data.showIdle()) {
            return;
        }
        if (this.isIdleEvent() && MainWindow.IGNORE_IDLE) {
            return;
        }
        if (this.data.entryIsHiddenID(this.getEntryID())) {
            return;
        }
        Paint c = this.determineColor();
        if (this.data.isObjectDimmed(this)) {
            c = this.makeMoreLikeBackground(c);
        }
        int rectWidth = this.getWidth();
        int rectHeight = this.data.barheight();
        int verticalInset = 0;
        if (this.entryIndex == -1) {
            rectHeight -= 6;
            verticalInset += 3;
        }
        int left = 0;
        int right = rectWidth - 1;
        if (this.beginTime < this.data.startTime()) {
            this.drawLeftArrow(g2d, c, verticalInset, rectHeight);
            rectWidth -= 5;
            left = 5;
        }
        if (this.endTime > this.data.endTime()) {
            this.drawRightArrow(g2d, c, verticalInset, rectHeight, rectWidth);
            right = (rectWidth -= 5) - 6;
        }
        g2d.setPaint(c);
        if (rectWidth > 1 || this.entryIndex != -1) {
            g2d.fillRect(left, verticalInset, rectWidth, rectHeight);
        }
        if (rectWidth > 2 && !this.data.colorByMemoryUsage()) {
            g2d.setPaint(this.makeMoreLikeForeground(c));
            g2d.drawLine(left, verticalInset, right, verticalInset);
            if (left == 0) {
                g2d.drawLine(0, verticalInset, 0, verticalInset + rectHeight - 1);
            }
            g2d.setPaint(this.makeMoreLikeBackground(c));
            g2d.drawLine(left, verticalInset + rectHeight - 1, right, verticalInset + rectHeight - 1);
            if (right == rectWidth - 1) {
                g2d.drawLine(rectWidth - 1, verticalInset, rectWidth - 1, verticalInset + rectHeight - 1);
            }
        }
        if (this.data.showPacks() && this.packs != null) {
            g.setColor(Color.pink);
            for (int p = 0; p < this.packs.length; ++p) {
                long packBeginTime = this.packs[p].BeginTime;
                long packEndTime = this.packs[p].EndTime;
                if (packEndTime < this.data.startTime() || packBeginTime > this.data.endTime()) continue;
                int packBeginPanelCoordX = this.data.timeToScreenPixelLeft(packBeginTime);
                int packBeginObjectCoordX = packBeginPanelCoordX - this.leftCoord - 1;
                int packEndPanelCoordX = this.data.timeToScreenPixelRight(packEndTime);
                int packEndObjectCoordX = packEndPanelCoordX - this.leftCoord - 1;
                g.fillRect(packBeginObjectCoordX, verticalInset + rectHeight, packEndObjectCoordX - packBeginObjectCoordX + 1, this.data.messagePackHeight());
            }
        }
        if (this.data.showMsgs() && this.messages != null) {
            g.setColor(this.getForeground());
            for (TimelineMessage msg : this.messages) {
                long msgtime = msg.Time;
                if (msgtime < this.data.startTime() || msgtime > this.data.endTime()) continue;
                int msgPanelCoordX = this.data.timeToScreenPixel(msgtime);
                int msgObjectCoordX = msgPanelCoordX - this.leftCoord;
                g.drawLine(msgObjectCoordX, verticalInset + rectHeight, msgObjectCoordX, verticalInset + rectHeight + this.data.messageSendHeight());
            }
        }
    }

    private Paint determineColor() {
        if (this.isIdleEvent()) {
            return MainWindow.runObject[this.data.myRun].getIdleColor();
        }
        if (this.entryIndex == -2) {
            return MainWindow.runObject[this.data.myRun].getOverheadColor();
        }
        if (this.isFunction) {
            return MainWindow.runObject[this.data.myRun].getFunctionColor(this.entryIndex);
        }
        if (this.data.entryColorsMapping.containsKey(this.entryIndex)) {
            return this.data.entryColorsMapping.get(this.entryIndex);
        }
        if (this.data.colorByMemoryUsage()) {
            if (this.memoryUsage == 0L) {
                return Color.darkGray;
            }
            float normalizedValue = (float)(this.memoryUsage - this.data.minMemBColorRange()) / (float)(this.data.maxMemBColorRange() - this.data.minMemBColorRange());
            if ((double)normalizedValue < 0.0 || (double)normalizedValue > 1.0) {
                return Color.darkGray;
            }
            return Color.getHSBColor(0.6f - normalizedValue * 0.65f, 1.0f, 1.0f);
        }
        if (this.data.colorByUserSupplied() && this.data.colorSchemeForUserSupplied == 0) {
            if (this.userSuppliedData != null) {
                long value = this.userSuppliedData.longValue();
                float normalizedValue = (float)(value - this.data.minUserSupplied) / (float)(this.data.maxUserSupplied - this.data.minUserSupplied);
                return Color.getHSBColor(0.25f - normalizedValue * 0.75f, 1.0f, 1.0f);
            }
            return Color.darkGray;
        }
        if (this.data.colorByOID() || this.data.colorByUserSupplied() || this.data.colorByEID()) {
            long color = 0L;
            if (this.data.colorByOID()) {
                int h1 = this.getTid().id[0] * 139 % 509;
                int h2 = this.getTid().id[1] * 101 % 1039;
                int h3 = this.getTid().id[2] * 67 % 1291;
                int h4 = this.getTid().id[3] * 2789 % 1721;
                color += (long)(h1 ^ h3 ^ h2 ^ h4);
            }
            if (this.data.colorByEID()) {
                color += (long)(this.entryIndex * 251 % 5113);
            }
            if (this.data.colorByUserSupplied() && this.userSuppliedData != null) {
                color += (long)(this.userSuppliedData * 359 % 4903);
            }
            if (this.data.colorByMemoryUsage() && this.memoryUsage != 0L) {
                color += this.memoryUsage * 6121L % 5953L;
            }
            float h2 = (float)((color + 512L) % 512L) / 256.0f;
            float h = (float)((color + 512L) % 512L) / 512.0f;
            float s = 1.0f;
            float b = 1.0f;
            if ((double)h2 > 1.0) {
                b = 0.6f;
            }
            return Color.getHSBColor(h, s, b);
        }
        return this.data.entryColor()[this.entryIndex];
    }

    public void setLocationAndSize(int actualDisplayWidth) {
        int width;
        if (this.data.entryIsHiddenID(this.entry)) {
            this.setBounds(0, 0, 0, 0);
            return;
        }
        this.leftCoord = this.data.timeToScreenPixel(this.beginTime, actualDisplayWidth);
        this.rightCoord = this.data.timeToScreenPixel(this.endTime, actualDisplayWidth);
        if (this.endTime > this.data.endTime()) {
            this.rightCoord = this.data.timeToScreenPixelRight(this.data.endTime(), actualDisplayWidth);
        }
        if (this.beginTime < this.data.startTime()) {
            this.leftCoord = this.data.timeToScreenPixelLeft(this.data.startTime(), actualDisplayWidth);
        }
        if ((width = this.rightCoord - this.leftCoord + 1) < 1) {
            width = 1;
        }
        this.setBounds(this.leftCoord, this.data.entryMethodLocationTop(this.pCurrent), width, this.data.entryMethodLocationHeight());
    }

    private void setPackUsage() {
        this.packtime = 0L;
        if (this.packs != null) {
            for (int p = 0; p < this.packs.length; ++p) {
                this.packtime += this.packs[p].EndTime - this.packs[p].BeginTime;
                if (this.packs[p].BeginTime < this.data.startTime()) {
                    this.packtime -= this.data.startTime() - this.packs[p].BeginTime;
                }
                if (this.packs[p].EndTime <= this.data.endTime()) continue;
                this.packtime -= this.packs[p].EndTime - this.data.endTime();
            }
            this.packusage = this.packtime * 100L;
            this.packusage /= (float)(this.data.endTime() - this.data.startTime());
        }
    }

    private void setUsage() {
        if (this.entryIndex < -1) {
            return;
        }
        this.usage = this.endTime - this.beginTime;
        if (this.beginTime < this.data.startTime()) {
            this.usage -= (double)(this.data.startTime() - this.beginTime);
        }
        if (this.endTime > this.data.endTime()) {
            this.usage -= (double)(this.endTime - this.data.endTime());
        }
        this.usage /= (double)(this.data.endTime() - this.data.startTime());
        this.usage *= 100.0;
    }

    public int compareTo(Object o) {
        EntryMethodObject obj = (EntryMethodObject)o;
        if (this.pCreation != obj.pCreation) {
            return MiscUtil.sign(this.pCreation - obj.pCreation);
        }
        if (this.pCurrent != obj.pCurrent) {
            return MiscUtil.sign(this.pCurrent - obj.pCurrent);
        }
        return MiscUtil.sign(this.EventID - obj.EventID);
    }

    public ObjectId getTid() {
        return this.tid;
    }

    protected void shiftTimesBy(long s) {
        this.beginTime += s;
        this.endTime += s;
        this.recvTime += s;
        this.cpuBegin += s;
        this.cpuEnd += s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals(popupChangeColor)) {
                Color old = MainWindow.runObject[this.data.myRun].getEntryColor(this.entry);
                Color c = JColorChooser.showDialog(null, "Choose new color", old);
                if (c != null) {
                    this.data.entryColorsMapping.put(this.entry, c);
                    this.data.displayMustBeRepainted();
                }
            } else if (arg.equals(popupShowDetails)) {
                this.OpenMessageWindow();
            } else if (arg.equals(popupTraceSender)) {
                this.data.clickTraceSender(this);
            } else if (arg.equals(popupDropPEsForObject)) {
                this.data.dropPEsUnrelatedToObject(this);
            } else if (arg.equals(popupDropPEsForPE)) {
                this.data.dropPEsUnrelatedToPE(this.pCurrent);
            }
        }
    }
}

