/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.EntryMethodObject;
import projections.Tools.Timeline.MainHandler;
import projections.Tools.Timeline.MainLayout;
import projections.Tools.Timeline.MainPanelBackground;
import projections.Tools.Timeline.MainPanelForeground;
import projections.Tools.Timeline.NullFocusTraversalPolicy;
import projections.Tools.Timeline.UserEventObject;

public class MainPanel
extends JPanel
implements Scrollable,
MouseListener,
MouseMotionListener {
    private int viewX;
    private int viewY;
    private Data data;
    private MainHandler handler;

    public MainPanel(Data data, MainHandler handler) {
        this.handler = handler;
        this.data = data;
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new NullFocusTraversalPolicy());
        this.setAutoscrolls(true);
        this.addMouseMotionListener(this);
        this.setLayout(new MainLayout(data));
        this.add(new MainPanelForeground(data));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void disposeOfStructures() {
        this.handler = null;
        this.removeAll();
        this.data.disposeOfStructures();
    }

    public void loadTimelineObjects(boolean useHelperThreads, Component rootWindow, boolean showProgress) {
        this.setCursor(new Cursor(3));
        this.removeAll();
        this.data.createTLOArray(useHelperThreads, rootWindow, showProgress);
        this.add(new MainPanelForeground(this.data));
        for (LinkedList linkedList : this.data.allEntryMethodObjects.values()) {
            for (EntryMethodObject obj : linkedList) {
                this.add(obj);
                MouseMotionListener[] mml = obj.getMouseMotionListeners();
                boolean found = false;
                for (int mml_index = 0; mml_index < mml.length; ++mml_index) {
                    if (mml[mml_index] != this) continue;
                    found = true;
                }
                if (found) continue;
                obj.addMouseListener(this);
                obj.addMouseMotionListener(this);
            }
        }
        Iterator<Set<UserEventObject>> iterator = this.data.allUserEventObjects.values().iterator();
        while (iterator.hasNext()) {
            for (UserEventObject ueo : iterator.next()) {
                this.add(ueo);
            }
        }
        MainPanelBackground b = new MainPanelBackground(this.data);
        b.addMouseListener(this);
        b.addMouseMotionListener(this);
        this.add(b);
        this.handler.setData(this.data);
        this.handler.refreshDisplay(true);
        this.setCursor(new Cursor(0));
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.data.screenHeight());
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.data.singleTimelineHeight();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5 * this.data.singleTimelineHeight();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            JViewport jv = (JViewport)this.getParent();
            Point p = jv.getViewPosition();
            int newX = p.x - (e.getX() - this.viewX);
            int newY = p.y - (e.getY() - this.viewY);
            int maxX = this.getWidth() - jv.getWidth();
            int maxY = this.getHeight() - jv.getHeight();
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            if (newX < 0) {
                newX = 0;
            }
            if (newY < 0) {
                newY = 0;
            }
            jv.setViewPosition(new Point(newX, newY));
        }
        this.data.displayMustBeRepainted();
    }

    public void mousePressed(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            this.viewX = e.getX();
            this.viewY = e.getY();
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

