/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import projections.Tools.Timeline.Data;

class MainPanelBackground
extends JPanel {
    private Data data;

    protected MainPanelBackground(Data data) {
        this.data = data;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        g.setColor(this.data.getBackgroundColor());
        Rectangle clipBounds = g.getClipBounds();
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        if (this.data.selectionValid()) {
            g.setColor(new Color(100, 100, 100));
            g.fillRect(this.data.leftSelection(), 0, this.data.rightSelection() - this.data.leftSelection(), this.getHeight() - 1);
            g.setColor(this.data.getForegroundColor());
            g.drawLine(this.data.leftSelection(), 0, this.data.leftSelection(), this.getHeight() - 1);
            g.drawLine(this.data.rightSelection(), 0, this.data.rightSelection(), this.getHeight() - 1);
        }
        if (this.data.highlightValid()) {
            g.setColor(this.data.getForegroundColor());
            g.drawLine(this.data.getHighlight(), 0, this.data.getHighlight(), this.getHeight() - 1);
        }
        g.setColor(new Color(128, 128, 128));
        for (int i = 0; i < this.data.numPs(); ++i) {
            int y = this.data.horizontalLineLocationTop(i);
            g.drawLine(0 + this.data.offset(), y, width - this.data.offset(), y);
        }
    }
}

