/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Set;
import javax.swing.JPanel;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.EntryMethodObject;

class MainPanelForeground
extends JPanel {
    private Data data;

    protected MainPanelForeground(Data data) {
        this.data = data;
        this.setOpaque(false);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintMessageSendLines(g, this.data.getMessageColor(), this.data.getBackgroundColor(), this.data.drawMessagesForTheseObjects);
        this.paintMessageSendLines(g, this.data.getMessageAltColor(), this.data.getBackgroundColor(), this.data.drawMessagesForTheseObjectsAlt);
    }

    private void paintMessageSendLines(Graphics g, Color c, Color bgColor, Set drawMessagesForObjects) {
        Graphics2D g2d = (Graphics2D)g;
        if (drawMessagesForObjects.size() > 0) {
            for (Object o : drawMessagesForObjects) {
                EntryMethodObject obj;
                if (!(o instanceof EntryMethodObject) || (obj = (EntryMethodObject)o).creationMessage() == null) continue;
                int pCreation = obj.pCreation;
                int pExecution = obj.pCurrent;
                int x1 = this.data.timeToScreenPixel(obj.creationMessage().Time);
                double y1 = this.data.messageSendLocationY(pCreation);
                int x2 = this.data.timeToScreenPixel(obj.getBeginTime());
                double y2 = this.data.messageRecvLocationY(pExecution);
                g2d.setPaint(bgColor);
                g2d.setStroke(new BasicStroke(4.0f));
                g2d.drawLine(x1, (int)y1, x2, (int)y2);
                g2d.setPaint(c);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(x1, (int)y1, x2, (int)y2);
            }
        }
    }
}

