/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JOptionPane;
import projections.Tools.Timeline.AxisLayout;
import projections.Tools.Timeline.AxisOverlayPanel;
import projections.Tools.Timeline.AxisPanel;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.LabelPanel;
import projections.Tools.Timeline.LayeredPanel;
import projections.Tools.Timeline.MainHandler;
import projections.Tools.Timeline.MainPanel;
import projections.Tools.Timeline.ScrollingPanel;
import projections.Tools.Timeline.WindowControls;
import projections.gui.MainWindow;
import projections.gui.ProjectionsWindow;

public class TimelineWindow
extends ProjectionsWindow
implements MainHandler {
    private int myRun = 0;
    protected ScrollingPanel scrollingPanel;
    protected LabelPanel labelPanel;
    protected LayeredPanel axisPanel;
    protected MainPanel mainPanel;
    private WindowControls controls;
    private TimelineWindow thisWindow = this;
    Data data = new Data(this);

    public void refreshDisplay(boolean doRevalidate) {
        if (this.data.selectionValid()) {
            this.controls.setSelectedTime(this.data.leftSelectionTime(), this.data.rightSelectionTime());
        } else {
            this.controls.unsetSelectedTime();
        }
        if (this.data.highlightValid()) {
            this.controls.setHighlightTime(this.data.getHighlightTime());
        } else {
            this.controls.unsetHighlightTime();
        }
        this.controls.updateScaleField();
        this.scrollingPanel.updateBackgroundColor();
        this.scrollingPanel.refreshDisplay(doRevalidate);
    }

    public TimelineWindow(MainWindow parentWindow) {
        super(parentWindow);
        this.labelPanel = new LabelPanel(this.data);
        AxisPanel ap = new AxisPanel(this.data);
        AxisOverlayPanel op = new AxisOverlayPanel(this.data);
        AxisLayout lay = new AxisLayout(ap);
        this.axisPanel = new LayeredPanel(ap, op, lay);
        ap.setOpaque(false);
        op.setOpaque(false);
        this.mainPanel = new MainPanel(this.data, this);
        this.scrollingPanel = new ScrollingPanel(this.data, this.mainPanel, this.axisPanel, this.labelPanel);
        this.controls = new WindowControls(this, this.data);
        this.scrollingPanel.updateBackgroundColor();
        this.thisWindow.getContentPane().setLayout(new BorderLayout());
        this.thisWindow.getContentPane().add((Component)this.scrollingPanel, "Center");
        this.thisWindow.getContentPane().add((Component)this.controls, "South");
        this.setTitle("Projections Timelines - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.controls.CreateMenus();
        this.data.setProcessorList(MainWindow.runObject[this.myRun].getValidProcessorList());
        this.data.setRange(0L, MainWindow.runObject[this.myRun].getTotalTime());
        this.showDialog();
    }

    protected void showDialog() {
        this.controls.showDialog();
    }

    public void setData(Data data) {
        this.controls.userEventWindowSetData();
    }

    public void notifyProcessorListHasChanged() {
        this.mainPanel.loadTimelineObjects(false, this, true);
    }

    public void addProcessor(int p) {
        this.data.addProcessor(p);
    }

    public void displayWarning(String message2) {
        JOptionPane.showMessageDialog(this, message2, "Warning", 2);
    }
}

