/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import projections.Tools.Timeline.Data;
import projections.gui.MainWindow;
import projections.misc.MiscUtil;

public class UserEventObject
extends JComponent
implements Comparable,
MouseListener,
ActionListener {
    private static int myRun = 0;
    public static final int SINGLE = 1;
    public static final int PAIR = 2;
    protected int Type;
    public long BeginTime;
    public long EndTime;
    public int UserEventID;
    public int CharmEventID;
    private Data data;
    private int pe;
    private String note = null;
    private static final String popupChangeColor = "Change Color";
    private int nestedRow;

    public UserEventObject(int pe, long t, int e, int event, int type) {
        this.setFocusable(false);
        this.Type = type;
        this.BeginTime = this.EndTime = t;
        this.UserEventID = e;
        this.CharmEventID = event;
        this.pe = pe;
        this.setOpaque(false);
        this.addMouseListener(this);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    public UserEventObject(int pe, long t, String note) {
        this.setFocusable(false);
        this.BeginTime = this.EndTime = t;
        this.pe = pe;
        this.note = note;
        this.UserEventID = -1;
        this.setOpaque(false);
        this.addMouseListener(this);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    public UserEventObject(int pe, long t, int e, int event, int type, String note) {
        this.setFocusable(false);
        this.Type = type;
        this.BeginTime = this.EndTime = t;
        this.UserEventID = e;
        this.CharmEventID = event;
        this.pe = pe;
        this.note = note;
        this.addMouseListener(this);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    public String getName() {
        String name = "";
        boolean addNewline = false;
        String userEventName = MainWindow.runObject[myRun].getUserEventName(this.UserEventID);
        if (userEventName != null) {
            name = name + userEventName;
            addNewline = true;
        }
        if (this.note != null) {
            if (addNewline) {
                name = name + "\n";
            }
            name = name + this.note;
        }
        return name;
    }

    public Color getColor() {
        Color c = MainWindow.runObject[myRun].getUserEventColor(this.UserEventID);
        if (c != null) {
            return c;
        }
        return this.data.getForegroundColor();
    }

    protected void setLocationAndSize(Data data, int actualDisplayWidth) {
        this.data = data;
        if (data.userEventIsHiddenID(this.UserEventID) || data.userSuppliedNotesHidden() && this.UserEventID == -1) {
            this.setBounds(0, 0, 0, 0);
            return;
        }
        int left = data.timeToScreenPixel(this.BeginTime, actualDisplayWidth);
        int rightCoord = data.timeToScreenPixel(this.EndTime, actualDisplayWidth);
        if (this.EndTime > data.endTime()) {
            rightCoord = data.timeToScreenPixel(data.endTime(), actualDisplayWidth) - 5;
        }
        if (this.BeginTime < data.startTime()) {
            left = data.timeToScreenPixel(data.startTime(), actualDisplayWidth) + 5;
        }
        int width = rightCoord - left + 1;
        int heightPerRow = data.userEventRectHeight() / data.getNumUserEventRows();
        int bottom = data.userEventLocationBottom(this.pe);
        if (data.drawNestedUserEventRows) {
            bottom -= heightPerRow * this.nestedRow;
        }
        int top = bottom - heightPerRow;
        int height = heightPerRow;
        if (this.getName().contains("***")) {
            top = 3;
            height = data.screenHeight() - top;
        }
        this.setBounds(left, top, width, height);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.data.userEventIsHiddenID(this.UserEventID)) {
            return;
        }
        if (this.data.showUserEvents()) {
            Color c = this.getColor();
            g.setColor(c);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.getWidth() > 1) {
                g.setColor(c.brighter());
                g.drawLine(0, 0, 0, this.getHeight());
                g.setColor(c.darker());
                g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            if (this.getName() != null) {
                int leftpad = 3;
                int rightpad = 3;
                int toppad = 1;
                int bottompad = 1;
                int fontsize = this.getHeight() - toppad - bottompad;
                g.setFont(this.data.labelFont);
                FontMetrics fm = g.getFontMetrics();
                int stringWidth = fm.stringWidth(this.getName());
                if (fontsize >= 9 && stringWidth < this.getWidth() - leftpad - rightpad) {
                    g.setColor(Color.black);
                    g.drawString(this.getName(), leftpad, toppad + fontsize);
                    g.setPaintMode();
                }
            }
        }
    }

    public String getToolTipText(MouseEvent evt) {
        if (this.note == null) {
            return "<html><body><p><i>User Traced Event:</i> <b>" + this.getName() + "</b></p><p><i>Duration:</i> " + (this.EndTime - this.BeginTime) + " us</p><p><i>event:</i> " + this.UserEventID + "</p><p><i>occurred on PE:</i> " + this.pe + "</p></html></body>";
        }
        if (this.EndTime - this.BeginTime > 0L) {
            return "<html><body><p><i>User Supplied Note:</i></p><p></p>" + this.note + "</html></body>";
        }
        return "<html><body><p><i>User Supplied Note:</i></p><p></p>" + this.note + "<p><i>Duration</i>: " + (this.EndTime - this.BeginTime) + "us</p></html></body>";
    }

    protected void shiftTimesBy(long shift) {
        this.BeginTime += shift;
        this.EndTime += shift;
    }

    public int compareTo(Object o) {
        UserEventObject ueo = (UserEventObject)o;
        if (this.pe != ueo.pe) {
            return this.pe - ueo.pe;
        }
        if (this.BeginTime != ueo.BeginTime) {
            return MiscUtil.sign(this.BeginTime - ueo.BeginTime);
        }
        if (this.EndTime != ueo.EndTime) {
            return MiscUtil.sign(ueo.EndTime - this.EndTime);
        }
        if (this != ueo) {
            return MiscUtil.sign(this.UserEventID - ueo.UserEventID);
        }
        System.err.println("ERROR: compareTo not working correctly for class UserEventObject");
        return 0;
    }

    public void setNestedRow(int row) {
        this.nestedRow = row;
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getModifiers() != 16) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(popupChangeColor);
            menuItem.addActionListener(this);
            popup.add(menuItem);
            popup.show(this, evt.getX(), evt.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Color c;
        String arg;
        if (e.getSource() instanceof JMenuItem && (arg = ((JMenuItem)e.getSource()).getText()).equals(popupChangeColor) && (c = JColorChooser.showDialog(null, "Choose color for " + this.getName(), this.getColor())) != null) {
            MainWindow.runObject[myRun].setUserEventColor(this.UserEventID, c);
            this.data.displayMustBeRepainted();
        }
    }
}

