/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import projections.analysis.IntervalCapableReader;
import projections.analysis.IntervalUtils;
import projections.analysis.ParseTokenizer;
import projections.analysis.ProjectionsFormatException;
import projections.analysis.ProjectionsReader;

class AccumulatedSummaryReader
extends ProjectionsReader
implements IntervalCapableReader {
    private double intervalSize;
    private double[] utilization;

    private AccumulatedSummaryReader(File file, String version) {
        super(file, version);
    }

    protected boolean checkAvailable() {
        return this.sourceFile.canRead();
    }

    private ParseTokenizer initNewTokenizer(Reader reader) {
        ParseTokenizer tokenizer = new ParseTokenizer(reader);
        tokenizer.parseNumbers();
        tokenizer.eolIsSignificant(true);
        tokenizer.whitespaceChars(47, 47);
        tokenizer.whitespaceChars(58, 58);
        tokenizer.whitespaceChars(91, 91);
        tokenizer.whitespaceChars(93, 93);
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        return tokenizer;
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }

    public void loadIntervalData(long startInterval, long endInterval) throws IOException {
        this.loadIntervalData(this.intervalSize, startInterval, endInterval);
    }

    public void loadIntervalData(double intervalSize, long startInterval, long endInterval) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.sourceFile));
        ParseTokenizer tokenizer = this.initNewTokenizer(reader);
        int numIntervals = (int)(endInterval - startInterval + 1L);
        this.utilization = new double[numIntervals];
        tokenizer.skipLine();
        double originalIntervalSize = this.intervalSize;
        double newStartTime = intervalSize * (double)startInterval;
        double newEndTime = (double)endInterval * intervalSize;
        long interval = 0L;
        while (!tokenizer.isEOL()) {
            if ((double)(interval + 1L) * originalIntervalSize < newStartTime) {
                ++interval;
                continue;
            }
            double valueRead = tokenizer.nval;
            IntervalUtils.fillIntervals(this.utilization, (long)intervalSize, startInterval, (long)((double)interval * originalIntervalSize), (long)((double)(interval + 1L) * originalIntervalSize), originalIntervalSize * (valueRead / 100.0), false);
            if (!((double)(++interval) * originalIntervalSize > newEndTime)) continue;
            break;
        }
        if (tokenizer.isEOL()) {
            throw new ProjectionsFormatException(this.expectedVersion, "Unexpected EOL when reading utilization data!");
        }
        reader.close();
        IntervalUtils.timeToUtil(this.utilization, intervalSize);
    }

    public double[] getUtilData() {
        return this.utilization;
    }
}

