/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;

class AsciiLineParser {
    private int pos;
    private String line;

    protected AsciiLineParser(String _line) {
        this.line = _line;
        this.pos = 0;
    }

    private final boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t';
    }

    private final char nextChar() throws IOException {
        if (this.pos > this.line.length()) {
            throw new IOException();
        }
        if (this.pos == this.line.length()) {
            ++this.pos;
            return '\n';
        }
        char c = this.line.charAt(this.pos);
        ++this.pos;
        return c;
    }

    protected String restOfLine() {
        return this.line.substring(this.pos);
    }

    protected final long nextLong() throws IOException {
        char c;
        if (this.line == null) {
            throw new IOException();
        }
        int multiplier = 1;
        while (this.isSpace(c = this.nextChar())) {
        }
        if (c == '-') {
            multiplier = -1;
            c = this.nextChar();
        }
        long ret = this.toDigit(c);
        while (!this.isSpace(c = this.nextChar())) {
            ret = 10L * ret + (long)this.toDigit(c);
        }
        return ret * (long)multiplier;
    }

    private final int toDigit(char c) {
        return c - 48;
    }
}

