/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import projections.analysis.AsciiLineParser;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.PointCapableReader;
import projections.analysis.ProjectionsReader;
import projections.gui.Analysis;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

public class GenericLogReader
extends ProjectionsReader
implements PointCapableReader {
    private static int myRun = 0;
    private int bufferSize = 262144;
    private double version;
    private BufferedReader reader;
    private long lastRecordedTime = 0L;
    private LogEntryData lastBeginEvent = null;
    private boolean endComputationOccurred;

    public GenericLogReader(int peNum, double Nversion) {
        super(MainWindow.runObject[myRun].getLog(peNum), String.valueOf(Nversion));
        this.sourceFile = MainWindow.runObject[myRun].getLog(peNum);
        this.lastBeginEvent = new LogEntryData();
        this.lastBeginEvent.setValid(false);
        this.endComputationOccurred = false;
        this.reader = this.createBufferedReader(this.sourceFile);
        this.version = Nversion;
        try {
            this.reader.readLine();
        }
        catch (IOException e) {
            System.err.println("Error reading file");
        }
    }

    private BufferedReader createBufferedReader(File file) {
        BufferedReader r = null;
        String filename = file.getAbsolutePath();
        String s3 = filename.substring(filename.length() - 3);
        try {
            if (s3.compareTo(".gz") == 0) {
                FileInputStream fis = new FileInputStream(file);
                GZIPInputStream gis = new GZIPInputStream(fis);
                r = new BufferedReader(new InputStreamReader(gis), this.bufferSize);
            } else {
                FileReader fr = new FileReader(file);
                r = new BufferedReader(fr, this.bufferSize);
            }
        }
        catch (IOException e2) {
            System.err.println("Error reading file " + filename);
            return null;
        }
        return r;
    }

    protected boolean checkAvailable() {
        return this.sourceFile.canRead();
    }

    private String interpretNote(String input) {
        Analysis a = MainWindow.runObject[myRun];
        String modified = input;
        if (modified.contains("<EP")) {
            int numEntries = a.getEntryCount();
            for (int i = 0; i < numEntries; ++i) {
                String name = a.getEntryFullNameByID(i);
                modified = modified.replace("<EP " + i + ">", name);
            }
        }
        return modified;
    }

    public LogEntryData nextEvent() throws IOException, EndOfLogSuccess {
        LogEntryData data = new LogEntryData();
        String line = this.reader.readLine();
        AsciiLineParser parser = new AsciiLineParser(line);
        if (this.endComputationOccurred) {
            throw new EndOfLogSuccess();
        }
        if (line == null) {
            this.endComputationOccurred = true;
            data.type = 7;
            data.time = this.lastRecordedTime;
            System.err.println("[" + this.sourceFile.getAbsolutePath() + "] WARNING: Partial or Corrupted Projections log. Faked END_COMPUTATION entry added for last recorded time of " + data.time);
            return data;
        }
        data.type = (int)parser.nextLong();
        switch (data.type) {
            case 14: {
                this.lastBeginEvent.time = data.time = parser.nextLong();
                this.lastBeginEvent.pe = data.pe = (int)parser.nextLong();
                this.lastBeginEvent.setValid(true);
                break;
            }
            case 15: {
                data.time = parser.nextLong();
                data.pe = (int)parser.nextLong();
                this.lastBeginEvent.setValid(false);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                data.time = parser.nextLong();
                data.pe = (int)parser.nextLong();
                break;
            }
            case 26: {
                data.userSupplied = new Integer((int)parser.nextLong());
                break;
            }
            case 28: {
                data.time = parser.nextLong();
                parser.nextLong();
                String r = parser.restOfLine();
                data.note = this.interpretNote(r);
                break;
            }
            case 29: {
                data.time = parser.nextLong();
                data.endTime = parser.nextLong();
                data.entry = data.userEventID = (int)parser.nextLong();
                parser.nextLong();
                data.note = this.interpretNote(parser.restOfLine());
                break;
            }
            case 27: {
                data.memoryUsage = parser.nextLong();
                data.time = parser.nextLong();
                break;
            }
            case 1: {
                data.mtype = (int)parser.nextLong();
                data.entry = (int)parser.nextLong();
                data.time = parser.nextLong();
                data.event = (int)parser.nextLong();
                data.pe = (int)parser.nextLong();
                data.msglen = this.version >= 2.0 ? (int)parser.nextLong() : -1;
                if (!(this.version >= 5.0)) break;
                data.sendTime = parser.nextLong();
                break;
            }
            case 20: {
                data.mtype = (int)parser.nextLong();
                data.entry = (int)parser.nextLong();
                data.time = parser.nextLong();
                data.event = (int)parser.nextLong();
                data.pe = (int)parser.nextLong();
                data.msglen = this.version >= 2.0 ? (int)parser.nextLong() : -1;
                if (this.version >= 5.0) {
                    data.sendTime = parser.nextLong();
                }
                data.numPEs = (int)parser.nextLong();
                break;
            }
            case 21: {
                data.mtype = (int)parser.nextLong();
                data.entry = (int)parser.nextLong();
                data.time = parser.nextLong();
                data.event = (int)parser.nextLong();
                data.pe = (int)parser.nextLong();
                data.msglen = this.version >= 2.0 ? (int)parser.nextLong() : -1;
                if (this.version >= 5.0) {
                    data.sendTime = parser.nextLong();
                }
                data.numPEs = (int)parser.nextLong();
                data.destPEs = new int[data.numPEs];
                for (int i = 0; i < data.numPEs; ++i) {
                    data.destPEs[i] = (int)parser.nextLong();
                }
                break;
            }
            case 2: {
                this.lastBeginEvent.mtype = data.mtype = (int)parser.nextLong();
                this.lastBeginEvent.entry = data.entry = (int)parser.nextLong();
                this.lastBeginEvent.time = data.time = parser.nextLong();
                this.lastBeginEvent.event = data.event = (int)parser.nextLong();
                this.lastBeginEvent.pe = data.pe = (int)parser.nextLong();
                if (this.version >= 2.0) {
                    this.lastBeginEvent.msglen = data.msglen = (int)parser.nextLong();
                } else {
                    data.msglen = -1;
                    this.lastBeginEvent.msglen = -1;
                }
                if (this.version >= 4.0) {
                    this.lastBeginEvent.recvTime = data.recvTime = parser.nextLong();
                    this.lastBeginEvent.id[0] = data.id[0] = (int)parser.nextLong();
                    this.lastBeginEvent.id[1] = data.id[1] = (int)parser.nextLong();
                    this.lastBeginEvent.id[2] = data.id[2] = (int)parser.nextLong();
                }
                if (this.version >= 7.0) {
                    this.lastBeginEvent.id[3] = data.id[3] = (int)parser.nextLong();
                }
                if (this.version >= 6.5) {
                    this.lastBeginEvent.cpuStartTime = data.cpuStartTime = parser.nextLong();
                }
                if (this.version >= 6.6) {
                    this.lastBeginEvent.numPerfCounts = data.numPerfCounts = (int)parser.nextLong();
                    this.lastBeginEvent.perfCounts = new long[data.numPerfCounts];
                    data.perfCounts = new long[data.numPerfCounts];
                    for (int i = 0; i < data.numPerfCounts; ++i) {
                        this.lastBeginEvent.perfCounts[i] = data.perfCounts[i] = parser.nextLong();
                    }
                }
                this.lastBeginEvent.setValid(true);
                break;
            }
            case 3: {
                data.mtype = (int)parser.nextLong();
                data.entry = (int)parser.nextLong();
                data.time = parser.nextLong();
                data.event = (int)parser.nextLong();
                data.pe = (int)parser.nextLong();
                data.msglen = this.version >= 2.0 ? (int)parser.nextLong() : -1;
                if (this.version >= 6.5) {
                    data.cpuEndTime = parser.nextLong();
                }
                if (!(this.version >= 6.6)) break;
                data.numPerfCounts = (int)parser.nextLong();
                data.perfCounts = new long[data.numPerfCounts];
                for (int i = 0; i < data.numPerfCounts; ++i) {
                    data.perfCounts[i] = parser.nextLong();
                }
                break;
            }
            case 11: {
                data.time = parser.nextLong();
                this.lastBeginEvent.setValid(false);
                break;
            }
            case 12: {
                data.time = parser.nextLong();
                break;
            }
            case 22: {
                data.time = parser.nextLong();
                data.entry = (int)parser.nextLong();
                data.lineNo = (int)parser.nextLong();
                data.funcName = parser.restOfLine();
                break;
            }
            case 23: {
                data.time = parser.nextLong();
                data.entry = (int)parser.nextLong();
                break;
            }
            case 10: {
                data.mtype = (int)parser.nextLong();
                data.time = parser.nextLong();
                data.event = (int)parser.nextLong();
                data.pe = (int)parser.nextLong();
                data.msglen = (int)parser.nextLong();
                break;
            }
            case 4: 
            case 5: {
                data.mtype = (int)parser.nextLong();
                data.time = parser.nextLong();
                data.event = (int)parser.nextLong();
                data.pe = (int)parser.nextLong();
                break;
            }
            case 8: 
            case 9: {
                data.time = parser.nextLong();
                data.event = (int)parser.nextLong();
                data.pe = (int)parser.nextLong();
                break;
            }
            case 6: {
                data.time = parser.nextLong();
                break;
            }
            case 7: {
                data.time = parser.nextLong();
                this.endComputationOccurred = true;
                break;
            }
            case 13: {
                data.entry = data.userEventID = (int)parser.nextLong();
                data.time = parser.nextLong();
                data.event = (int)parser.nextLong();
                data.pe = (int)parser.nextLong();
                break;
            }
            case 100: {
                data.entry = data.userEventID = (int)parser.nextLong();
                data.time = parser.nextLong();
                data.event = (int)parser.nextLong();
                data.pe = (int)parser.nextLong();
                break;
            }
            default: {
                data.type = -1;
            }
        }
        this.lastRecordedTime = data.time;
        return data;
    }

    public LogEntryData nextEventOnOrAfter(long timestamp) throws IOException, EndOfLogSuccess {
        LogEntryData data = new LogEntryData();
        do {
            data = this.nextEvent();
            while (data.type == -1) {
                data = this.nextEvent();
            }
        } while (data.time < timestamp);
        return data;
    }

    public LogEntryData nextEventOfType(int eventType) throws IOException, EndOfLogSuccess {
        LogEntryData data = new LogEntryData();
        do {
            data = this.nextEvent();
        } while (data.type != eventType);
        return data;
    }

    public LogEntryData getLastBE() {
        if (this.lastBeginEvent.isValid()) {
            return this.lastBeginEvent;
        }
        return null;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

