/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import projections.Tools.Timeline.TimelineMessage;
import projections.Tools.Timeline.UserEventObject;
import projections.analysis.AmpiFunctionData;
import projections.analysis.AmpiProcessProfile;
import projections.analysis.CallStackManager;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.analysis.LogEntry;
import projections.analysis.LogLoaderEndTimeThread;
import projections.analysis.ObjectId;
import projections.analysis.PackTime;
import projections.analysis.ProjDefs;
import projections.analysis.TimedProgressThreadExecutor;
import projections.analysis.TimelineEvent;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.misc.LogEntryData;
import projections.misc.LogLoadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogLoader
extends ProjDefs {
    private int myRun = 0;
    private boolean isProcessing = false;
    private boolean ampiTraceOn = false;

    public long determineEndTime(OrderedIntList validPEs) {
        LinkedList<Runnable> workerThreads = new LinkedList<Runnable>();
        validPEs.reset();
        while (validPEs.hasMoreElements()) {
            int pe = validPEs.nextElement();
            workerThreads.add(new LogLoaderEndTimeThread(pe));
        }
        TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Computing End Time in Parallel", workerThreads, MainWindow.runObject[this.myRun].guiRoot, true);
        threadManager.runAll();
        Iterator iter = workerThreads.iterator();
        long maxTimeFound = Long.MIN_VALUE;
        while (iter.hasNext()) {
            LogLoaderEndTimeThread worker = (LogLoaderEndTimeThread)iter.next();
            if (worker.result <= maxTimeFound) continue;
            maxTimeFound = worker.result;
        }
        return maxTimeFound;
    }

    public void createAMPIUsageProfile(int procId, long beginTime, long endTime, Vector procThdVec) throws LogLoadException {
        GenericLogReader logFileRd = null;
        LogEntryData rawLogData = null;
        LogEntry curEntry = null;
        LogEntry prevEntry = null;
        AmpiProcessProfile curProcessing = null;
        Hashtable<Object, AmpiProcessProfile> procThdMap = new Hashtable<Object, AmpiProcessProfile>();
        try {
            logFileRd = new GenericLogReader(procId, MainWindow.runObject[this.myRun].getVersion());
            do {
                rawLogData = logFileRd.nextEvent();
                curEntry = new LogEntry(rawLogData);
            } while (curEntry.TransactionType != 2 || curEntry.Entry == -1 || curEntry.Time < beginTime);
            curProcessing = new AmpiProcessProfile(curEntry.id);
            prevEntry = curEntry;
            boolean reachEndTime = false;
            while (!reachEndTime) {
                rawLogData = logFileRd.nextEvent();
                curEntry = new LogEntry(rawLogData);
                if (curEntry.Entry == -1) continue;
                switch (curEntry.TransactionType) {
                    case 2: {
                        if (curProcessing != null) {
                            System.err.println("Error in parsing log file as processing overlapped!");
                            return;
                        }
                        AmpiProcessProfile tmp = new AmpiProcessProfile(curEntry.id);
                        AmpiProcessProfile storedProfile = (AmpiProcessProfile)procThdMap.get(tmp.toHashKey());
                        curProcessing = storedProfile == null ? tmp : storedProfile;
                        break;
                    }
                    case 3: {
                        AmpiFunctionData curFunc;
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as processing is not paired!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        if (!curProcessing.getAuxCallFuncStack().empty()) {
                            curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                            curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        }
                        if (procThdMap.get(curProcessing.toHashKey()) == null) {
                            procThdMap.put(curProcessing.toHashKey(), curProcessing);
                        }
                        curProcessing = null;
                        if (curEntry.Time < endTime) break;
                        reachEndTime = true;
                        break;
                    }
                    case 22: {
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        AmpiFunctionData curFunc = curEntry.ampiData;
                        Stack auxStk = curProcessing.getAuxCallFuncStack();
                        auxStk.push(curFunc);
                        break;
                    }
                    case 23: {
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        if (curProcessing.getAuxCallFuncStack().empty()) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        AmpiFunctionData curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                        if (curFunc.FunctionID != curEntry.FunctionID) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        curProcessing.getAuxCallFuncStack().pop();
                        curProcessing.getFinalCallFuncStack().push(curFunc);
                        break;
                    }
                    case 1: 
                    case 16: 
                    case 18: {
                        if (curProcessing == null) break;
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        if (curProcessing.getAuxCallFuncStack().empty()) break;
                        AmpiFunctionData curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                        curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        break;
                    }
                }
                prevEntry = curEntry;
            }
        }
        catch (EndOfLogSuccess e) {
        }
        catch (FileNotFoundException E) {
            System.out.println("ERROR: couldn't open file " + MainWindow.runObject[this.myRun].getLogName(procId));
        }
        catch (IOException E) {
            throw new LogLoadException(MainWindow.runObject[this.myRun].getLogName(procId));
        }
        Enumeration e = procThdMap.keys();
        while (e.hasMoreElements()) {
            AmpiProcessProfile p = (AmpiProcessProfile)procThdMap.get(e.nextElement());
            if (p.getFinalCallFuncStack().size() <= 0) continue;
            procThdVec.add(p);
        }
    }

    public void createAMPIFuncTimeProfile(int procId, long beginTime, long endTime, Vector procThdVec) throws LogLoadException {
        GenericLogReader logFileRd = null;
        LogEntryData rawLogData = null;
        LogEntry curEntry = null;
        LogEntry prevEntry = null;
        AmpiProcessProfile curProcessing = null;
        Hashtable<Object, AmpiProcessProfile> procThdMap = new Hashtable<Object, AmpiProcessProfile>();
        try {
            logFileRd = new GenericLogReader(procId, MainWindow.runObject[this.myRun].getVersion());
            do {
                rawLogData = logFileRd.nextEvent();
                curEntry = new LogEntry(rawLogData);
            } while (curEntry.TransactionType != 2 || curEntry.Entry == -1 || curEntry.Time < beginTime);
            curProcessing = new AmpiProcessProfile(curEntry.id);
            prevEntry = curEntry;
            boolean reachEndTime = false;
            while (!reachEndTime) {
                rawLogData = logFileRd.nextEvent();
                curEntry = new LogEntry(rawLogData);
                if (curEntry.Entry == -1) continue;
                switch (curEntry.TransactionType) {
                    case 2: {
                        if (curProcessing != null) {
                            System.err.println("Error in parsing log file as processing overlapped!");
                            return;
                        }
                        AmpiProcessProfile tmp = new AmpiProcessProfile(curEntry.id);
                        AmpiProcessProfile storedProfile = (AmpiProcessProfile)procThdMap.get(tmp.toHashKey());
                        curProcessing = storedProfile == null ? tmp : storedProfile;
                        break;
                    }
                    case 3: {
                        AmpiFunctionData.AmpiFuncExecInterval gap;
                        AmpiFunctionData curFunc;
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as processing is not paired!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        if (!curProcessing.getAuxCallFuncStack().empty()) {
                            curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                            gap = new AmpiFunctionData.AmpiFuncExecInterval(prevEntry.Time, curEntry.Time);
                            curFunc.insertExecInterval(gap);
                            curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        }
                        if (procThdMap.get(curProcessing.toHashKey()) == null) {
                            procThdMap.put(curProcessing.toHashKey(), curProcessing);
                        }
                        curProcessing = null;
                        if (curEntry.Time < endTime) break;
                        reachEndTime = true;
                        break;
                    }
                    case 22: {
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        AmpiFunctionData curFunc = curEntry.ampiData;
                        Stack auxStk = curProcessing.getAuxCallFuncStack();
                        auxStk.push(curFunc);
                        break;
                    }
                    case 23: {
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        if (curProcessing.getAuxCallFuncStack().empty()) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        AmpiFunctionData curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                        if (curFunc.FunctionID != curEntry.FunctionID) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        AmpiFunctionData.AmpiFuncExecInterval gap = new AmpiFunctionData.AmpiFuncExecInterval(prevEntry.Time, curEntry.Time);
                        curFunc.insertExecInterval(gap);
                        curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        curProcessing.getAuxCallFuncStack().pop();
                        curProcessing.getFinalCallFuncStack().push(curFunc);
                        break;
                    }
                    case 1: 
                    case 16: 
                    case 18: {
                        if (curProcessing == null) break;
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        if (curProcessing.getAuxCallFuncStack().empty()) break;
                        AmpiFunctionData curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                        AmpiFunctionData.AmpiFuncExecInterval gap = new AmpiFunctionData.AmpiFuncExecInterval(prevEntry.Time, curEntry.Time);
                        curFunc.insertExecInterval(gap);
                        curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        break;
                    }
                }
                prevEntry = curEntry;
            }
        }
        catch (EndOfLogSuccess e) {
        }
        catch (FileNotFoundException E) {
            System.out.println("ERROR: couldn't open file " + MainWindow.runObject[this.myRun].getLogName(procId));
        }
        catch (IOException E) {
            throw new LogLoadException(MainWindow.runObject[this.myRun].getLogName(procId));
        }
        Enumeration e = procThdMap.keys();
        while (e.hasMoreElements()) {
            AmpiProcessProfile p = (AmpiProcessProfile)procThdMap.get(e.nextElement());
            if (p.getFinalCallFuncStack().size() <= 0) continue;
            procThdVec.add(p);
        }
    }

    public void createtimeline(int pe, long Begin, long End, LinkedList<TimelineEvent> Timeline2, Set<UserEventObject> userEventVector, long minEntryDuration) throws LogLoadException {
        long BeginTime = 0L;
        long Time2 = Long.MIN_VALUE;
        LogEntry LE = null;
        TimelineEvent TE = null;
        UserEventObject userEventObject = null;
        TimelineMessage TM = null;
        PackTime PT = null;
        GenericLogReader reader = new GenericLogReader(pe, MainWindow.runObject[this.myRun].getVersion());
        try {
            LogEntryData data2;
            if (MainWindow.runObject[this.myRun].getNumFunctionEvents() > 0) {
                this.ampiTraceOn = true;
            }
            this.isProcessing = false;
            LogEntry lastBeginEvent = null;
            TimelineEvent lastBeginTimelineEvent = null;
            while (true) {
                LogEntryData data = reader.nextEvent();
                LE = new LogEntry(data);
                if (LE.Time >= Begin) break;
                if (LE.Entry == -1) continue;
                if (LE.TransactionType == 2 && LE.Entry != -1) {
                    Time2 = LE.Time - BeginTime;
                    lastBeginEvent = LE;
                    continue;
                }
                if (LE.TransactionType == 3 && LE.Entry != -1) {
                    Time2 = LE.Time - BeginTime;
                    lastBeginEvent = null;
                    continue;
                }
                if (LE.TransactionType == 14) {
                    Time2 = LE.Time - BeginTime;
                    lastBeginEvent = LE;
                    continue;
                }
                if (LE.TransactionType != 15) continue;
                lastBeginEvent = null;
            }
            if (Time2 == Long.MIN_VALUE) {
                Time2 = Begin;
            }
            if (LE.Time > End) {
                switch (LE.TransactionType) {
                    case 2: {
                        System.out.println("finished empty timeline for " + pe);
                        return;
                    }
                    case 3: {
                        if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2 && lastBeginEvent.Entry == LE.Entry) {
                            TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, LE.Time - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                            Timeline2.add(TE);
                        }
                        return;
                    }
                    case 14: {
                        System.out.println("finished empty timeline for " + pe);
                        return;
                    }
                    case 15: {
                        if (lastBeginEvent != null && lastBeginEvent.TransactionType == 14) {
                            TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, LE.Time - BeginTime, -1, -1);
                            Timeline2.add(TE);
                        }
                        return;
                    }
                }
                if (lastBeginEvent != null) {
                    switch (lastBeginEvent.TransactionType) {
                        case 2: {
                            TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                            Timeline2.add(TE);
                            break;
                        }
                        case 14: {
                            TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, -1, -1);
                            Timeline2.add(TE);
                        }
                    }
                } else {
                    System.out.println("finished empty timeline for " + pe);
                }
                return;
            }
            CallStackManager cstack = new CallStackManager();
            LogEntry enclosingDummy = null;
            ObjectId tid = null;
            AmpiFunctionData ampiData = null;
            block35: while (true) {
                if (LE.Entry != -1) {
                    switch (LE.TransactionType) {
                        case 22: {
                            lastBeginEvent = null;
                            if (TE != null) {
                                TE.EndTime = LE.Time - BeginTime;
                                if (TE.EndTime - TE.BeginTime < minEntryDuration) {
                                    Timeline2.removeLast();
                                }
                            }
                            TE = new TimelineEvent();
                            TE.isFunction = true;
                            TE.BeginTime = LE.Time - BeginTime;
                            TE.EntryPoint = LE.FunctionID;
                            TE.EventID = -1;
                            TE.id = enclosingDummy.id;
                            cstack.push(LE.ampiData, TE.id.id[0], TE.id.id[1], TE.id.id[2]);
                            TE.callStack = cstack.getStack(TE.id.id[0], TE.id.id[1], TE.id.id[2]);
                            Timeline2.add(TE);
                            break;
                        }
                        case 23: {
                            if (TE != null) {
                                TE.EndTime = LE.Time - BeginTime;
                                cstack.pop(TE.id.id[0], TE.id.id[1], TE.id.id[2]);
                                if (TE.EndTime - TE.BeginTime < minEntryDuration) {
                                    Timeline2.removeLast();
                                }
                            }
                            TE = null;
                            tid = enclosingDummy.id;
                            ampiData = (AmpiFunctionData)cstack.read(tid.id[0], tid.id[1], tid.id[2]);
                            if (ampiData == null || ampiData.FunctionID == 0) {
                                TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, enclosingDummy.Entry, enclosingDummy.Pe, enclosingDummy.MsgLen, enclosingDummy.recvTime, enclosingDummy.id, -1, enclosingDummy.cpuBegin, enclosingDummy.cpuEnd, enclosingDummy.numPapiCounts, enclosingDummy.papiCounts);
                                Timeline2.add(TE);
                                break;
                            }
                            TE = new TimelineEvent();
                            TE.isFunction = true;
                            TE.BeginTime = LE.Time - BeginTime;
                            TE.EntryPoint = ampiData.FunctionID;
                            TE.EventID = -1;
                            TE.id = tid;
                            TE.callStack = cstack.getStack(TE.id.id[0], TE.id.id[1], TE.id.id[2]);
                            Timeline2.add(TE);
                            break;
                        }
                        case 2: {
                            lastBeginEvent = null;
                            if (this.isProcessing) {
                                if (TE != null) {
                                    TE.EndTime = LE.Time - BeginTime;
                                    if (TE.EndTime - TE.BeginTime < minEntryDuration) {
                                        Timeline2.removeLast();
                                    }
                                }
                                TE = null;
                            }
                            this.isProcessing = true;
                            if (this.ampiTraceOn && LE.Entry == 0) {
                                enclosingDummy = LE;
                                tid = enclosingDummy.id;
                                ampiData = (AmpiFunctionData)cstack.read(tid.id[0], tid.id[1], tid.id[2]);
                                if (ampiData != null && ampiData.FunctionID != 0) {
                                    TE = new TimelineEvent();
                                    TE.isFunction = true;
                                    TE.BeginTime = LE.Time - BeginTime;
                                    TE.EntryPoint = ampiData.FunctionID;
                                    TE.SrcPe = enclosingDummy.Pe;
                                    TE.EventID = enclosingDummy.EventID;
                                    TE.MsgLen = enclosingDummy.MsgLen;
                                    TE.RecvTime = enclosingDummy.recvTime;
                                    TE.id = tid;
                                    TE.callStack = cstack.getStack(TE.id.id[0], TE.id.id[1], TE.id.id[2]);
                                    Timeline2.add(TE);
                                    break;
                                }
                            }
                            TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, LE.Entry, LE.Pe, LE.MsgLen, LE.recvTime, LE.id, LE.EventID, LE.cpuBegin, LE.cpuEnd, LE.numPapiCounts, LE.papiCounts);
                            Timeline2.add(TE);
                            lastBeginTimelineEvent = TE;
                            break;
                        }
                        case 3: {
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2 && lastBeginEvent.Entry == LE.Entry) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, LE.Time - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                                if (LE.Time - lastBeginEvent.Time >= minEntryDuration) {
                                    Timeline2.add(TE);
                                }
                                TE = null;
                                this.isProcessing = false;
                                break;
                            }
                            lastBeginEvent = null;
                            if (this.ampiTraceOn && LE.Entry == 0) {
                                tid = enclosingDummy.id;
                                ampiData = (AmpiFunctionData)cstack.read(tid.id[0], tid.id[1], tid.id[2]);
                                if (ampiData != null && ampiData.FunctionID != 0) {
                                    if (TE != null) {
                                        TE.EndTime = LE.Time - BeginTime;
                                        if (TE.EndTime - TE.BeginTime < minEntryDuration) {
                                            Timeline2.removeLast();
                                        }
                                    }
                                    TE = null;
                                    enclosingDummy = null;
                                    break;
                                }
                            }
                            if (TE != null) {
                                TE.EndTime = LE.Time - BeginTime;
                                TE.cpuEnd = LE.cpuEnd;
                                if (TE.EndTime - TE.BeginTime < minEntryDuration) {
                                    Timeline2.removeLast();
                                }
                                for (int i = 0; i < LE.numPapiCounts; ++i) {
                                    TE.papiCounts[i] = LE.papiCounts[i] - TE.papiCounts[i];
                                }
                            }
                            TE = null;
                            this.isProcessing = false;
                            break;
                        }
                        case 26: {
                            if (LE.userSuppliedValue() == null || lastBeginTimelineEvent == null) break;
                            lastBeginTimelineEvent.UserSpecifiedData = LE.userSuppliedValue();
                            break;
                        }
                        case 29: {
                            UserEventObject note2 = new UserEventObject(pe, LE.Time - BeginTime, LE.Entry, LE.EventID, 2, LE.note);
                            note2.EndTime = LE.endTime;
                            userEventVector.add(note2);
                            break;
                        }
                        case 27: {
                            if (LE.memoryUsage() == 0L || lastBeginTimelineEvent == null) break;
                            lastBeginTimelineEvent.memoryUsage = LE.memoryUsage();
                            break;
                        }
                        case 1: {
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                                Timeline2.add(TE);
                                this.isProcessing = true;
                            }
                            lastBeginEvent = null;
                            boolean tempte = false;
                            if (TE == null) {
                                TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, -2, LE.Pe, LE.MsgLen);
                                Timeline2.add(TE);
                                tempte = true;
                            }
                            TM = new TimelineMessage(pe, LE.Time - BeginTime, LE.Entry, LE.MsgLen, LE.EventID);
                            TE.addMessage(TM);
                            if (!tempte) break;
                            TE = null;
                            break;
                        }
                        case 20: {
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                                Timeline2.add(TE);
                                this.isProcessing = true;
                            }
                            lastBeginEvent = null;
                            boolean tempte = false;
                            if (TE == null) {
                                TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, -2, LE.Pe, LE.MsgLen);
                                Timeline2.add(TE);
                                tempte = true;
                            }
                            TM = new TimelineMessage(pe, LE.Time - BeginTime, LE.Entry, LE.MsgLen, LE.EventID, LE.numPEs);
                            TE.addMessage(TM);
                            if (!tempte) break;
                            TE = null;
                            break;
                        }
                        case 21: {
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                                Timeline2.add(TE);
                                this.isProcessing = true;
                            }
                            lastBeginEvent = null;
                            boolean tempte = false;
                            if (TE == null) {
                                TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, -2, LE.Pe, LE.MsgLen);
                                Timeline2.add(TE);
                                tempte = true;
                            }
                            TM = new TimelineMessage(pe, LE.Time - BeginTime, LE.Entry, LE.MsgLen, LE.EventID, LE.destPEs);
                            TE.addMessage(TM);
                            if (!tempte) break;
                            TE = null;
                            break;
                        }
                        case 13: {
                            UserEventObject event = new UserEventObject(pe, LE.Time - BeginTime, LE.Entry, LE.EventID, 1);
                            userEventVector.add(event);
                            break;
                        }
                        case 28: {
                            UserEventObject note = new UserEventObject(pe, LE.Time - BeginTime, LE.note);
                            userEventVector.add(note);
                            break;
                        }
                        case 100: {
                            userEventObject = new UserEventObject(pe, LE.Time - BeginTime, LE.Entry, LE.EventID, 2);
                            userEventObject.EndTime = End;
                            LogEntryData data22 = reader.nextEvent();
                            LE = new LogEntry(data22);
                            if (LE.TransactionType != 100) {
                                userEventObject = null;
                                continue block35;
                            }
                            if (userEventObject.CharmEventID != LE.EventID || userEventObject.UserEventID != LE.Entry) {
                                userEventObject = null;
                                continue block35;
                            }
                            userEventObject.EndTime = LE.Time - BeginTime;
                            userEventVector.add(userEventObject);
                            if (Timeline2.isEmpty()) break;
                            TimelineEvent curLastOne = Timeline2.get(Timeline2.size() - 1);
                            long tleBeginTime = curLastOne.BeginTime;
                            if (tleBeginTime > userEventObject.BeginTime || userEventObject.BeginTime - tleBeginTime > 3L) break;
                            curLastOne.userEventName = userEventObject.getName();
                            break;
                        }
                        case 16: {
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                                Timeline2.add(TE);
                                this.isProcessing = true;
                            }
                            lastBeginEvent = null;
                            if (TE == null) {
                                TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, -2, LE.Pe);
                                Timeline2.add(TE);
                            }
                            PT = new PackTime(LE.Time - BeginTime);
                            TE.addPack(PT);
                            break;
                        }
                        case 17: {
                            if (PT != null) {
                                PT.EndTime = LE.Time - BeginTime;
                            }
                            PT = null;
                            if (TE == null || TE.EntryPoint != -2) break;
                            TE = null;
                            break;
                        }
                        case 14: {
                            lastBeginEvent = null;
                            if (MainWindow.IGNORE_IDLE) break;
                            TE = new TimelineEvent(LE.Time - BeginTime, Long.MAX_VALUE, -1, -1);
                            Timeline2.add(TE);
                            break;
                        }
                        case 15: {
                            if (MainWindow.IGNORE_IDLE) break;
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 14) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, -1, -1);
                                Timeline2.add(TE);
                                this.isProcessing = true;
                            }
                            lastBeginEvent = null;
                            if (TE != null) {
                                TE.EndTime = LE.Time - BeginTime;
                                if (TE.EndTime - TE.BeginTime < minEntryDuration) {
                                    Timeline2.removeLast();
                                }
                            }
                            TE = null;
                        }
                    }
                }
                data2 = reader.nextEvent();
                LE = new LogEntry(data2);
                if (LE.Entry != -1 && LE.Time - BeginTime > End) break;
            }
            while (TE != null) {
                if (LE.Entry != -1 && LE.TransactionType == 3) {
                    TE.EndTime = LE.Time - BeginTime;
                    if (TE.EndTime - TE.BeginTime < minEntryDuration) {
                        Timeline2.removeLast();
                    }
                    TE = null;
                }
                data2 = reader.nextEvent();
                LE = new LogEntry(data2);
            }
        }
        catch (EndOfLogSuccess e) {
        }
        catch (IOException E) {
            throw new LogLoadException(MainWindow.runObject[this.myRun].getLogName(pe));
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + pe);
        }
    }
}

